/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.X509CertificateWithOriginalPem;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import com.oracle.bmc.util.StreamUtils;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedX509CertificateSupplier
implements X509CertificateSupplier,
Refreshable {
    private static final String CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS_VAR_NAME = "OCI_JAVASDK_CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS";
    private static final String CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS_VAR_NAME = "OCI_JAVASDK_CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS";
    protected static final String CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS = System.getenv("OCI_JAVASDK_CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS");
    protected static final String CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS = System.getenv("OCI_JAVASDK_CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS");
    private static final boolean EXPERIMENTAL_SUPPRESS_X509_WORKAROUND = Boolean.getBoolean("oci.sdk.experimental.suppressX509Workaround");
    private static final Logger LOG = LoggerFactory.getLogger(URLBasedX509CertificateSupplier.class);
    private final AtomicReference<X509CertificateSupplier.CertificateAndPrivateKeyPair> certificateAndKeyPair = new AtomicReference<Object>(null);
    private final ResourceDetails certificateDetails;
    private final ResourceDetails privateKeyDetails;
    private final char[] privateKeyPassphraseCharacters;

    public URLBasedX509CertificateSupplier(ResourceDetails certificateResourceDetails, ResourceDetails privateKeyResourceDetails, char[] privateKeyPassphraseCharacters) {
        this.certificateDetails = certificateResourceDetails;
        this.privateKeyDetails = privateKeyResourceDetails;
        this.privateKeyPassphraseCharacters = privateKeyPassphraseCharacters;
        this.refresh();
    }

    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, char[] privateKeyPassphraseCharacters) {
        this(ResourceDetails.builder().url(certificateUrl).build(), ResourceDetails.builder().url(privateKeyUrl).build(), privateKeyPassphraseCharacters);
    }

    @Deprecated
    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, String privateKeyPassphrase) {
        this(certificateUrl, privateKeyUrl, privateKeyPassphrase != null ? privateKeyPassphrase.toCharArray() : null);
    }

    @Override
    @Deprecated
    public X509Certificate getCertificate() {
        return this.certificateAndKeyPair.get().getCertificate();
    }

    @Override
    public void refresh() {
        String rawCertificate = URLBasedX509CertificateSupplier.readRawCertificate(this.certificateDetails);
        X509Certificate certificate = URLBasedX509CertificateSupplier.readCertificate(rawCertificate);
        RSAPrivateKey privateKey = URLBasedX509CertificateSupplier.readPrivateKey(this.privateKeyDetails, this.privateKeyPassphraseCharacters);
        if (EXPERIMENTAL_SUPPRESS_X509_WORKAROUND) {
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(certificate, privateKey));
        } else {
            X509CertificateWithOriginalPem wrappedCertificate = new X509CertificateWithOriginalPem(certificate, rawCertificate);
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(wrappedCertificate, privateKey));
        }
    }

    @Override
    public boolean isCurrent() {
        return false;
    }

    private static X509Certificate readCertificate(String certificate) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid certificate.", e);
        }
    }

    private static String readRawCertificate(ResourceDetails certificateResourceDetails) {
        int MAX_RETRIES = 3;
        IOException lastException = null;
        int retry = 0;
        while (retry < 3) {
            String string;
            block11: {
                InputStream is = URLBasedX509CertificateSupplier.getResourceStream(certificateResourceDetails);
                try {
                    string = StreamUtils.toString(is, StandardCharsets.UTF_8);
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.info("Attempt {} to open stream of certificate failed.", (Object)(retry + 1), (Object)e);
                        lastException = e;
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.debug("Thread interrupted while waiting to make next readRawCertificate call to instance metadata service", (Throwable)interruptedException);
                            Thread.currentThread().interrupt();
                            break;
                        }
                        ++retry;
                    }
                }
                is.close();
            }
            return string;
        }
        throw new IllegalArgumentException("Open stream of certificate failed.", lastException);
    }

    private static InputStream getResourceStream(@Nonnull ResourceDetails resourceDetails) throws IOException {
        if (resourceDetails == null) {
            throw new NullPointerException("resourceDetails is marked non-null but is null");
        }
        Objects.requireNonNull(resourceDetails.getUrl(), "Resource url cannot be null.");
        URLConnection urlConnection = resourceDetails.getUrl().openConnection();
        if (CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS != null) {
            urlConnection.setReadTimeout(Integer.parseInt(CERTIFICATE_URL_CONNECTION_READ_TIMEOUT_IN_MILLIS));
        }
        if (CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS != null) {
            urlConnection.setConnectTimeout(Integer.parseInt(CERTIFICATE_URL_CONNECTION_TIMEOUT_IN_MILLIS));
        }
        if (resourceDetails.getHeaders() != null) {
            resourceDetails.getHeaders().forEach(urlConnection::setRequestProperty);
        }
        return urlConnection.getInputStream();
    }

    private static RSAPrivateKey readPrivateKey(ResourceDetails privateKeyResourceDetails, char[] privateKeyPassphrase) {
        if (privateKeyResourceDetails == null || privateKeyResourceDetails.getUrl() == null) {
            return null;
        }
        int MAX_RETRIES = 3;
        Exception lastException = null;
        int retry = 0;
        while (retry < 3) {
            RSAPrivateKey rSAPrivateKey;
            block12: {
                InputStream inputStream = URLBasedX509CertificateSupplier.getResourceStream(privateKeyResourceDetails);
                try {
                    rSAPrivateKey = new PEMFileRSAPrivateKeySupplier(inputStream, privateKeyPassphrase).supplyKey(null).orElse(null);
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (PEMFileRSAPrivateKeySupplier.PEMFileRSAPrivateKeySupplierException | IOException e) {
                        LOG.info("Attempt {} to read private key failed. ", (Object)(retry + 1), (Object)e);
                        lastException = e;
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.debug("Thread interrupted while waiting to make next readPrivateKey call to instance metadata service ", (Throwable)interruptedException);
                            Thread.currentThread().interrupt();
                            break;
                        }
                        ++retry;
                    }
                }
                inputStream.close();
            }
            return rSAPrivateKey;
        }
        throw new IllegalArgumentException("No file for private key ", lastException);
    }

    @Override
    @Deprecated
    public RSAPrivateKey getPrivateKey() {
        return this.getCertificateAndKeyPair().getPrivateKey();
    }

    @Override
    public X509CertificateSupplier.CertificateAndPrivateKeyPair getCertificateAndKeyPair() {
        return this.certificateAndKeyPair.get();
    }

    static {
        LOG.info("suppressX509Workaround flag set to {}", (Object)EXPERIMENTAL_SUPPRESS_X509_WORKAROUND);
    }

    public static class ResourceDetails {
        private final URL url;
        private final Map<String, String> headers;

        @ConstructorProperties(value={"url", "headers"})
        ResourceDetails(URL url, Map<String, String> headers) {
            this.url = url;
            this.headers = headers;
        }

        public static ResourceDetailsBuilder builder() {
            return new ResourceDetailsBuilder();
        }

        public URL getUrl() {
            return this.url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceDetails)) {
                return false;
            }
            ResourceDetails other = (ResourceDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "URLBasedX509CertificateSupplier.ResourceDetails(url=" + this.getUrl() + ", headers=" + this.getHeaders() + ")";
        }

        public static class ResourceDetailsBuilder {
            private URL url;
            private Map<String, String> headers;

            ResourceDetailsBuilder() {
            }

            public ResourceDetailsBuilder url(URL url) {
                this.url = url;
                return this;
            }

            public ResourceDetailsBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public ResourceDetails build() {
                return new ResourceDetails(this.url, this.headers);
            }

            public String toString() {
                return "URLBasedX509CertificateSupplier.ResourceDetails.ResourceDetailsBuilder(url=" + this.url + ", headers=" + this.headers + ")";
            }
        }
    }
}

