/* soapH.h
   Generated by gSOAP 2.8.130 for calc.h

gSOAP XML Web services tools
Copyright (C) 2000-2023, Robert van Engelen, Genivia Inc. All Rights Reserved.
The soapcpp2 tool and its generated software are released under the GPL.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
--------------------------------------------------------------------------------
A commercial use license is available from Genivia Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

#ifndef soapH_H
#define soapH_H
#include "soapStub.h"
#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap*, const void*, int);

#ifdef __cplusplus
}
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap*);
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap*);
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap*, const char*, int*);
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap*, const void*, const char*, int, int);
SOAP_FMAC3 void * SOAP_FMAC4 soap_dupelement(struct soap*, const void*, int);
SOAP_FMAC3 void SOAP_FMAC4 soap_delelement(const void*, int);

#ifdef __cplusplus
}
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap*);
SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap*, int, const char*, const char*, size_t*);
SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap *soap, struct soap_clist*);
SOAP_FMAC3 int SOAP_FMAC4 soap_fbase(int, int);
SOAP_FMAC3 void SOAP_FMAC4 soap_finsert(struct soap*, int, int, void*, size_t, const void*, void**);

#ifndef SOAP_TYPE_byte_DEFINED
#define SOAP_TYPE_byte_DEFINED

inline void soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap*, const char*, int, const char *, const char*);
SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap*, const char*, char *, const char*);

SOAP_FMAC3 char * SOAP_FMAC4 soap_new_byte(struct soap *soap, int n = -1);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap*, const char *, const char*, const char*);

inline int soap_write_byte(struct soap *soap, char const*p)
{
	soap_free_temp(soap);
	if (p)
	{	if (soap_begin_send(soap) || ::soap_put_byte(soap, p, "byte", "") || soap_end_send(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_PUT_byte(struct soap *soap, const char *URL, char const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_byte(soap, p, "byte", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_byte(struct soap *soap, const char *URL, char const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_byte(soap, p, "byte", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_byte(struct soap *soap, const char *URL, char const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_byte(soap, p, "byte", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap*, char *, const char*, const char*);

inline int soap_read_byte(struct soap *soap, char *p)
{
	if (p)
	{	if (soap_begin_recv(soap) || ::soap_get_byte(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_byte(struct soap *soap, const char *URL, char *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_byte(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_byte(struct soap *soap, char *p)
{
	if (::soap_read_byte(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_int_DEFINED
#define SOAP_TYPE_int_DEFINED

inline void soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap*, const char*, int, const int *, const char*);
SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap*, const char*, int *, const char*);

SOAP_FMAC3 int * SOAP_FMAC4 soap_new_int(struct soap *soap, int n = -1);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap*, const int *, const char*, const char*);

inline int soap_write_int(struct soap *soap, int const*p)
{
	soap_free_temp(soap);
	if (p)
	{	if (soap_begin_send(soap) || ::soap_put_int(soap, p, "int", "") || soap_end_send(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_PUT_int(struct soap *soap, const char *URL, int const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_int(soap, p, "int", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_int(struct soap *soap, const char *URL, int const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_int(soap, p, "int", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_int(struct soap *soap, const char *URL, int const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_int(soap, p, "int", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap*, int *, const char*, const char*);

inline int soap_read_int(struct soap *soap, int *p)
{
	if (p)
	{	if (soap_begin_recv(soap) || ::soap_get_int(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_int(struct soap *soap, const char *URL, int *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_int(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_int(struct soap *soap, int *p)
{
	if (::soap_read_int(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_double_DEFINED
#define SOAP_TYPE_double_DEFINED

inline void soap_default_double(struct soap *soap, double *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap*, const char*, int, const double *, const char*);
SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap*, const char*, double *, const char*);

SOAP_FMAC3 double * SOAP_FMAC4 soap_new_double(struct soap *soap, int n = -1);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap*, const double *, const char*, const char*);

inline int soap_write_double(struct soap *soap, double const*p)
{
	soap_free_temp(soap);
	if (p)
	{	if (soap_begin_send(soap) || ::soap_put_double(soap, p, "double", "") || soap_end_send(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_PUT_double(struct soap *soap, const char *URL, double const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_double(soap, p, "double", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_double(struct soap *soap, const char *URL, double const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_double(soap, p, "double", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_double(struct soap *soap, const char *URL, double const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_double(soap, p, "double", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap*, double *, const char*, const char*);

inline int soap_read_double(struct soap *soap, double *p)
{
	if (p)
	{	if (soap_begin_recv(soap) || ::soap_get_double(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_double(struct soap *soap, const char *URL, double *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_double(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_double(struct soap *soap, double *p)
{
	if (::soap_read_double(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_SOAP_ENV__Fault_DEFINED
#define SOAP_TYPE_SOAP_ENV__Fault_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap*, struct SOAP_ENV__Fault *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap*, const struct SOAP_ENV__Fault *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap*, const char*, int, const struct SOAP_ENV__Fault *, const char*);
SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap*, const char*, struct SOAP_ENV__Fault *, const char*);
SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap*, int, const char*, const char*, size_t*);

inline struct SOAP_ENV__Fault * soap_new_SOAP_ENV__Fault(struct soap *soap, int n = -1)
{
	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

inline struct SOAP_ENV__Fault * soap_new_req_SOAP_ENV__Fault(
	struct soap *soap)
{
	struct SOAP_ENV__Fault *_p = ::soap_new_SOAP_ENV__Fault(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Fault(soap, _p);
	}
	return _p;
}

inline struct SOAP_ENV__Fault * soap_new_set_SOAP_ENV__Fault(
	struct soap *soap,
	char *faultcode,
	char *faultstring,
	char *faultactor,
	struct SOAP_ENV__Detail *detail,
	struct SOAP_ENV__Code *SOAP_ENV__Code,
	struct SOAP_ENV__Reason *SOAP_ENV__Reason,
	char *SOAP_ENV__Node,
	char *SOAP_ENV__Role,
	struct SOAP_ENV__Detail *SOAP_ENV__Detail)
{
	struct SOAP_ENV__Fault *_p = ::soap_new_SOAP_ENV__Fault(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Fault(soap, _p);
		_p->faultcode = faultcode;
		_p->faultstring = faultstring;
		_p->faultactor = faultactor;
		_p->detail = detail;
		_p->SOAP_ENV__Code = SOAP_ENV__Code;
		_p->SOAP_ENV__Reason = SOAP_ENV__Reason;
		_p->SOAP_ENV__Node = SOAP_ENV__Node;
		_p->SOAP_ENV__Role = SOAP_ENV__Role;
		_p->SOAP_ENV__Detail = SOAP_ENV__Detail;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap*, const struct SOAP_ENV__Fault *, const char*, const char*);

inline int soap_write_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_SOAP_ENV__Fault(soap, p), 0) || ::soap_put_SOAP_ENV__Fault(soap, p, "SOAP-ENV:Fault", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_SOAP_ENV__Fault(struct soap *soap, const char *URL, struct SOAP_ENV__Fault const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Fault(soap, p), 0) || ::soap_put_SOAP_ENV__Fault(soap, p, "SOAP-ENV:Fault", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_SOAP_ENV__Fault(struct soap *soap, const char *URL, struct SOAP_ENV__Fault const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Fault(soap, p), 0) || ::soap_put_SOAP_ENV__Fault(soap, p, "SOAP-ENV:Fault", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_SOAP_ENV__Fault(struct soap *soap, const char *URL, struct SOAP_ENV__Fault const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Fault(soap, p), 0) || ::soap_put_SOAP_ENV__Fault(soap, p, "SOAP-ENV:Fault", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap*, struct SOAP_ENV__Fault *, const char*, const char*);

inline int soap_read_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{
	if (p)
	{	::soap_default_SOAP_ENV__Fault(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_SOAP_ENV__Fault(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_SOAP_ENV__Fault(struct soap *soap, const char *URL, struct SOAP_ENV__Fault *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_SOAP_ENV__Fault(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{
	if (::soap_read_SOAP_ENV__Fault(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_SOAP_ENV__Reason_DEFINED
#define SOAP_TYPE_SOAP_ENV__Reason_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap*, struct SOAP_ENV__Reason *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap*, const struct SOAP_ENV__Reason *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap*, const char*, int, const struct SOAP_ENV__Reason *, const char*);
SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap*, const char*, struct SOAP_ENV__Reason *, const char*);
SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap*, int, const char*, const char*, size_t*);

inline struct SOAP_ENV__Reason * soap_new_SOAP_ENV__Reason(struct soap *soap, int n = -1)
{
	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

inline struct SOAP_ENV__Reason * soap_new_req_SOAP_ENV__Reason(
	struct soap *soap)
{
	struct SOAP_ENV__Reason *_p = ::soap_new_SOAP_ENV__Reason(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Reason(soap, _p);
	}
	return _p;
}

inline struct SOAP_ENV__Reason * soap_new_set_SOAP_ENV__Reason(
	struct soap *soap,
	char *SOAP_ENV__Text)
{
	struct SOAP_ENV__Reason *_p = ::soap_new_SOAP_ENV__Reason(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Reason(soap, _p);
		_p->SOAP_ENV__Text = SOAP_ENV__Text;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap*, const struct SOAP_ENV__Reason *, const char*, const char*);

inline int soap_write_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_SOAP_ENV__Reason(soap, p), 0) || ::soap_put_SOAP_ENV__Reason(soap, p, "SOAP-ENV:Reason", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_SOAP_ENV__Reason(struct soap *soap, const char *URL, struct SOAP_ENV__Reason const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Reason(soap, p), 0) || ::soap_put_SOAP_ENV__Reason(soap, p, "SOAP-ENV:Reason", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_SOAP_ENV__Reason(struct soap *soap, const char *URL, struct SOAP_ENV__Reason const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Reason(soap, p), 0) || ::soap_put_SOAP_ENV__Reason(soap, p, "SOAP-ENV:Reason", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_SOAP_ENV__Reason(struct soap *soap, const char *URL, struct SOAP_ENV__Reason const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Reason(soap, p), 0) || ::soap_put_SOAP_ENV__Reason(soap, p, "SOAP-ENV:Reason", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap*, struct SOAP_ENV__Reason *, const char*, const char*);

inline int soap_read_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{
	if (p)
	{	::soap_default_SOAP_ENV__Reason(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_SOAP_ENV__Reason(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_SOAP_ENV__Reason(struct soap *soap, const char *URL, struct SOAP_ENV__Reason *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_SOAP_ENV__Reason(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{
	if (::soap_read_SOAP_ENV__Reason(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_SOAP_ENV__Detail_DEFINED
#define SOAP_TYPE_SOAP_ENV__Detail_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap*, struct SOAP_ENV__Detail *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap*, const struct SOAP_ENV__Detail *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap*, const char*, int, const struct SOAP_ENV__Detail *, const char*);
SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap*, const char*, struct SOAP_ENV__Detail *, const char*);
SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap*, int, const char*, const char*, size_t*);

inline struct SOAP_ENV__Detail * soap_new_SOAP_ENV__Detail(struct soap *soap, int n = -1)
{
	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

inline struct SOAP_ENV__Detail * soap_new_req_SOAP_ENV__Detail(
	struct soap *soap,
	int __type,
	void *fault)
{
	struct SOAP_ENV__Detail *_p = ::soap_new_SOAP_ENV__Detail(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Detail(soap, _p);
		_p->__type = __type;
		_p->fault = fault;
	}
	return _p;
}

inline struct SOAP_ENV__Detail * soap_new_set_SOAP_ENV__Detail(
	struct soap *soap,
	char *__any,
	int __type,
	void *fault)
{
	struct SOAP_ENV__Detail *_p = ::soap_new_SOAP_ENV__Detail(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Detail(soap, _p);
		_p->__any = __any;
		_p->__type = __type;
		_p->fault = fault;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap*, const struct SOAP_ENV__Detail *, const char*, const char*);

inline int soap_write_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_SOAP_ENV__Detail(soap, p), 0) || ::soap_put_SOAP_ENV__Detail(soap, p, "SOAP-ENV:Detail", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_SOAP_ENV__Detail(struct soap *soap, const char *URL, struct SOAP_ENV__Detail const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Detail(soap, p), 0) || ::soap_put_SOAP_ENV__Detail(soap, p, "SOAP-ENV:Detail", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_SOAP_ENV__Detail(struct soap *soap, const char *URL, struct SOAP_ENV__Detail const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Detail(soap, p), 0) || ::soap_put_SOAP_ENV__Detail(soap, p, "SOAP-ENV:Detail", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_SOAP_ENV__Detail(struct soap *soap, const char *URL, struct SOAP_ENV__Detail const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Detail(soap, p), 0) || ::soap_put_SOAP_ENV__Detail(soap, p, "SOAP-ENV:Detail", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap*, struct SOAP_ENV__Detail *, const char*, const char*);

inline int soap_read_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{
	if (p)
	{	::soap_default_SOAP_ENV__Detail(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_SOAP_ENV__Detail(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_SOAP_ENV__Detail(struct soap *soap, const char *URL, struct SOAP_ENV__Detail *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_SOAP_ENV__Detail(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{
	if (::soap_read_SOAP_ENV__Detail(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_SOAP_ENV__Code_DEFINED
#define SOAP_TYPE_SOAP_ENV__Code_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap*, struct SOAP_ENV__Code *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap*, const struct SOAP_ENV__Code *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap*, const char*, int, const struct SOAP_ENV__Code *, const char*);
SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap*, const char*, struct SOAP_ENV__Code *, const char*);
SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap*, int, const char*, const char*, size_t*);

inline struct SOAP_ENV__Code * soap_new_SOAP_ENV__Code(struct soap *soap, int n = -1)
{
	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

inline struct SOAP_ENV__Code * soap_new_req_SOAP_ENV__Code(
	struct soap *soap)
{
	struct SOAP_ENV__Code *_p = ::soap_new_SOAP_ENV__Code(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Code(soap, _p);
	}
	return _p;
}

inline struct SOAP_ENV__Code * soap_new_set_SOAP_ENV__Code(
	struct soap *soap,
	char *SOAP_ENV__Value,
	struct SOAP_ENV__Code *SOAP_ENV__Subcode)
{
	struct SOAP_ENV__Code *_p = ::soap_new_SOAP_ENV__Code(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Code(soap, _p);
		_p->SOAP_ENV__Value = SOAP_ENV__Value;
		_p->SOAP_ENV__Subcode = SOAP_ENV__Subcode;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap*, const struct SOAP_ENV__Code *, const char*, const char*);

inline int soap_write_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_SOAP_ENV__Code(soap, p), 0) || ::soap_put_SOAP_ENV__Code(soap, p, "SOAP-ENV:Code", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_SOAP_ENV__Code(struct soap *soap, const char *URL, struct SOAP_ENV__Code const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Code(soap, p), 0) || ::soap_put_SOAP_ENV__Code(soap, p, "SOAP-ENV:Code", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_SOAP_ENV__Code(struct soap *soap, const char *URL, struct SOAP_ENV__Code const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Code(soap, p), 0) || ::soap_put_SOAP_ENV__Code(soap, p, "SOAP-ENV:Code", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_SOAP_ENV__Code(struct soap *soap, const char *URL, struct SOAP_ENV__Code const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Code(soap, p), 0) || ::soap_put_SOAP_ENV__Code(soap, p, "SOAP-ENV:Code", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap*, struct SOAP_ENV__Code *, const char*, const char*);

inline int soap_read_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{
	if (p)
	{	::soap_default_SOAP_ENV__Code(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_SOAP_ENV__Code(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_SOAP_ENV__Code(struct soap *soap, const char *URL, struct SOAP_ENV__Code *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_SOAP_ENV__Code(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{
	if (::soap_read_SOAP_ENV__Code(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_SOAP_ENV__Header_DEFINED
#define SOAP_TYPE_SOAP_ENV__Header_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap*, struct SOAP_ENV__Header *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap*, const struct SOAP_ENV__Header *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap*, const char*, int, const struct SOAP_ENV__Header *, const char*);
SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap*, const char*, struct SOAP_ENV__Header *, const char*);
SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap*, int, const char*, const char*, size_t*);

inline struct SOAP_ENV__Header * soap_new_SOAP_ENV__Header(struct soap *soap, int n = -1)
{
	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

inline struct SOAP_ENV__Header * soap_new_req_SOAP_ENV__Header(
	struct soap *soap)
{
	struct SOAP_ENV__Header *_p = ::soap_new_SOAP_ENV__Header(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Header(soap, _p);
	}
	return _p;
}

inline struct SOAP_ENV__Header * soap_new_set_SOAP_ENV__Header(
	struct soap *soap)
{
	struct SOAP_ENV__Header *_p = ::soap_new_SOAP_ENV__Header(soap);
	if (_p)
	{	::soap_default_SOAP_ENV__Header(soap, _p);
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap*, const struct SOAP_ENV__Header *, const char*, const char*);

inline int soap_write_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_SOAP_ENV__Header(soap, p), 0) || ::soap_put_SOAP_ENV__Header(soap, p, "SOAP-ENV:Header", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_SOAP_ENV__Header(struct soap *soap, const char *URL, struct SOAP_ENV__Header const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Header(soap, p), 0) || ::soap_put_SOAP_ENV__Header(soap, p, "SOAP-ENV:Header", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_SOAP_ENV__Header(struct soap *soap, const char *URL, struct SOAP_ENV__Header const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Header(soap, p), 0) || ::soap_put_SOAP_ENV__Header(soap, p, "SOAP-ENV:Header", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_SOAP_ENV__Header(struct soap *soap, const char *URL, struct SOAP_ENV__Header const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_SOAP_ENV__Header(soap, p), 0) || ::soap_put_SOAP_ENV__Header(soap, p, "SOAP-ENV:Header", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap*, struct SOAP_ENV__Header *, const char*, const char*);

inline int soap_read_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{
	if (p)
	{	::soap_default_SOAP_ENV__Header(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_SOAP_ENV__Header(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_SOAP_ENV__Header(struct soap *soap, const char *URL, struct SOAP_ENV__Header *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_SOAP_ENV__Header(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{
	if (::soap_read_SOAP_ENV__Header(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

#ifndef SOAP_TYPE_ns__pow_DEFINED
#define SOAP_TYPE_ns__pow_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__pow(struct soap*, struct ns__pow *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__pow(struct soap*, const struct ns__pow *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__pow(struct soap*, const char*, int, const struct ns__pow *, const char*);
SOAP_FMAC3 struct ns__pow * SOAP_FMAC4 soap_in_ns__pow(struct soap*, const char*, struct ns__pow *, const char*);
SOAP_FMAC1 struct ns__pow * SOAP_FMAC2 soap_instantiate_ns__pow(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__pow * soap_new_ns__pow(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__pow(soap, n, NULL, NULL, NULL);
}

inline struct ns__pow * soap_new_req_ns__pow(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__pow *_p = ::soap_new_ns__pow(soap);
	if (_p)
	{	::soap_default_ns__pow(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}

inline struct ns__pow * soap_new_set_ns__pow(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__pow *_p = ::soap_new_ns__pow(soap);
	if (_p)
	{	::soap_default_ns__pow(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__pow(struct soap*, const struct ns__pow *, const char*, const char*);

inline int soap_write_ns__pow(struct soap *soap, struct ns__pow const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__pow(soap, p), 0) || ::soap_put_ns__pow(soap, p, "ns:pow", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__pow(struct soap *soap, const char *URL, struct ns__pow const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__pow(soap, p), 0) || ::soap_put_ns__pow(soap, p, "ns:pow", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__pow(struct soap *soap, const char *URL, struct ns__pow const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__pow(soap, p), 0) || ::soap_put_ns__pow(soap, p, "ns:pow", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__pow(struct soap *soap, const char *URL, struct ns__pow const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__pow(soap, p), 0) || ::soap_put_ns__pow(soap, p, "ns:pow", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__pow * SOAP_FMAC4 soap_get_ns__pow(struct soap*, struct ns__pow *, const char*, const char*);

inline int soap_read_ns__pow(struct soap *soap, struct ns__pow *p)
{
	if (p)
	{	::soap_default_ns__pow(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__pow(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__pow(struct soap *soap, const char *URL, struct ns__pow *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__pow(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__pow(struct soap *soap, struct ns__pow *p)
{
	if (::soap_read_ns__pow(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__powResponse_DEFINED
#define SOAP_TYPE_ns__powResponse_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__powResponse(struct soap*, struct ns__powResponse *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__powResponse(struct soap*, const struct ns__powResponse *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__powResponse(struct soap*, const char*, int, const struct ns__powResponse *, const char*);
SOAP_FMAC3 struct ns__powResponse * SOAP_FMAC4 soap_in_ns__powResponse(struct soap*, const char*, struct ns__powResponse *, const char*);
SOAP_FMAC1 struct ns__powResponse * SOAP_FMAC2 soap_instantiate_ns__powResponse(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__powResponse * soap_new_ns__powResponse(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__powResponse(soap, n, NULL, NULL, NULL);
}

inline struct ns__powResponse * soap_new_req_ns__powResponse(
	struct soap *soap)
{
	struct ns__powResponse *_p = ::soap_new_ns__powResponse(soap);
	if (_p)
	{	::soap_default_ns__powResponse(soap, _p);
	}
	return _p;
}

inline struct ns__powResponse * soap_new_set_ns__powResponse(
	struct soap *soap,
	double *result)
{
	struct ns__powResponse *_p = ::soap_new_ns__powResponse(soap);
	if (_p)
	{	::soap_default_ns__powResponse(soap, _p);
		_p->result = result;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__powResponse(struct soap*, const struct ns__powResponse *, const char*, const char*);

inline int soap_write_ns__powResponse(struct soap *soap, struct ns__powResponse const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__powResponse(soap, p), 0) || ::soap_put_ns__powResponse(soap, p, "ns:powResponse", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__powResponse(struct soap *soap, const char *URL, struct ns__powResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__powResponse(soap, p), 0) || ::soap_put_ns__powResponse(soap, p, "ns:powResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__powResponse(struct soap *soap, const char *URL, struct ns__powResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__powResponse(soap, p), 0) || ::soap_put_ns__powResponse(soap, p, "ns:powResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__powResponse(struct soap *soap, const char *URL, struct ns__powResponse const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__powResponse(soap, p), 0) || ::soap_put_ns__powResponse(soap, p, "ns:powResponse", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__powResponse * SOAP_FMAC4 soap_get_ns__powResponse(struct soap*, struct ns__powResponse *, const char*, const char*);

inline int soap_read_ns__powResponse(struct soap *soap, struct ns__powResponse *p)
{
	if (p)
	{	::soap_default_ns__powResponse(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__powResponse(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__powResponse(struct soap *soap, const char *URL, struct ns__powResponse *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__powResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__powResponse(struct soap *soap, struct ns__powResponse *p)
{
	if (::soap_read_ns__powResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__div_DEFINED
#define SOAP_TYPE_ns__div_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__div(struct soap*, struct ns__div *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__div(struct soap*, const struct ns__div *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__div(struct soap*, const char*, int, const struct ns__div *, const char*);
SOAP_FMAC3 struct ns__div * SOAP_FMAC4 soap_in_ns__div(struct soap*, const char*, struct ns__div *, const char*);
SOAP_FMAC1 struct ns__div * SOAP_FMAC2 soap_instantiate_ns__div(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__div * soap_new_ns__div(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__div(soap, n, NULL, NULL, NULL);
}

inline struct ns__div * soap_new_req_ns__div(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__div *_p = ::soap_new_ns__div(soap);
	if (_p)
	{	::soap_default_ns__div(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}

inline struct ns__div * soap_new_set_ns__div(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__div *_p = ::soap_new_ns__div(soap);
	if (_p)
	{	::soap_default_ns__div(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__div(struct soap*, const struct ns__div *, const char*, const char*);

inline int soap_write_ns__div(struct soap *soap, struct ns__div const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__div(soap, p), 0) || ::soap_put_ns__div(soap, p, "ns:div", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__div(struct soap *soap, const char *URL, struct ns__div const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__div(soap, p), 0) || ::soap_put_ns__div(soap, p, "ns:div", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__div(struct soap *soap, const char *URL, struct ns__div const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__div(soap, p), 0) || ::soap_put_ns__div(soap, p, "ns:div", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__div(struct soap *soap, const char *URL, struct ns__div const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__div(soap, p), 0) || ::soap_put_ns__div(soap, p, "ns:div", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__div * SOAP_FMAC4 soap_get_ns__div(struct soap*, struct ns__div *, const char*, const char*);

inline int soap_read_ns__div(struct soap *soap, struct ns__div *p)
{
	if (p)
	{	::soap_default_ns__div(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__div(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__div(struct soap *soap, const char *URL, struct ns__div *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__div(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__div(struct soap *soap, struct ns__div *p)
{
	if (::soap_read_ns__div(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__divResponse_DEFINED
#define SOAP_TYPE_ns__divResponse_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__divResponse(struct soap*, struct ns__divResponse *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__divResponse(struct soap*, const struct ns__divResponse *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__divResponse(struct soap*, const char*, int, const struct ns__divResponse *, const char*);
SOAP_FMAC3 struct ns__divResponse * SOAP_FMAC4 soap_in_ns__divResponse(struct soap*, const char*, struct ns__divResponse *, const char*);
SOAP_FMAC1 struct ns__divResponse * SOAP_FMAC2 soap_instantiate_ns__divResponse(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__divResponse * soap_new_ns__divResponse(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__divResponse(soap, n, NULL, NULL, NULL);
}

inline struct ns__divResponse * soap_new_req_ns__divResponse(
	struct soap *soap)
{
	struct ns__divResponse *_p = ::soap_new_ns__divResponse(soap);
	if (_p)
	{	::soap_default_ns__divResponse(soap, _p);
	}
	return _p;
}

inline struct ns__divResponse * soap_new_set_ns__divResponse(
	struct soap *soap,
	double *result)
{
	struct ns__divResponse *_p = ::soap_new_ns__divResponse(soap);
	if (_p)
	{	::soap_default_ns__divResponse(soap, _p);
		_p->result = result;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__divResponse(struct soap*, const struct ns__divResponse *, const char*, const char*);

inline int soap_write_ns__divResponse(struct soap *soap, struct ns__divResponse const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__divResponse(soap, p), 0) || ::soap_put_ns__divResponse(soap, p, "ns:divResponse", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__divResponse(struct soap *soap, const char *URL, struct ns__divResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__divResponse(soap, p), 0) || ::soap_put_ns__divResponse(soap, p, "ns:divResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__divResponse(struct soap *soap, const char *URL, struct ns__divResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__divResponse(soap, p), 0) || ::soap_put_ns__divResponse(soap, p, "ns:divResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__divResponse(struct soap *soap, const char *URL, struct ns__divResponse const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__divResponse(soap, p), 0) || ::soap_put_ns__divResponse(soap, p, "ns:divResponse", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__divResponse * SOAP_FMAC4 soap_get_ns__divResponse(struct soap*, struct ns__divResponse *, const char*, const char*);

inline int soap_read_ns__divResponse(struct soap *soap, struct ns__divResponse *p)
{
	if (p)
	{	::soap_default_ns__divResponse(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__divResponse(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__divResponse(struct soap *soap, const char *URL, struct ns__divResponse *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__divResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__divResponse(struct soap *soap, struct ns__divResponse *p)
{
	if (::soap_read_ns__divResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__mul_DEFINED
#define SOAP_TYPE_ns__mul_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__mul(struct soap*, struct ns__mul *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__mul(struct soap*, const struct ns__mul *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__mul(struct soap*, const char*, int, const struct ns__mul *, const char*);
SOAP_FMAC3 struct ns__mul * SOAP_FMAC4 soap_in_ns__mul(struct soap*, const char*, struct ns__mul *, const char*);
SOAP_FMAC1 struct ns__mul * SOAP_FMAC2 soap_instantiate_ns__mul(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__mul * soap_new_ns__mul(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__mul(soap, n, NULL, NULL, NULL);
}

inline struct ns__mul * soap_new_req_ns__mul(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__mul *_p = ::soap_new_ns__mul(soap);
	if (_p)
	{	::soap_default_ns__mul(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}

inline struct ns__mul * soap_new_set_ns__mul(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__mul *_p = ::soap_new_ns__mul(soap);
	if (_p)
	{	::soap_default_ns__mul(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__mul(struct soap*, const struct ns__mul *, const char*, const char*);

inline int soap_write_ns__mul(struct soap *soap, struct ns__mul const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__mul(soap, p), 0) || ::soap_put_ns__mul(soap, p, "ns:mul", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__mul(struct soap *soap, const char *URL, struct ns__mul const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mul(soap, p), 0) || ::soap_put_ns__mul(soap, p, "ns:mul", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__mul(struct soap *soap, const char *URL, struct ns__mul const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mul(soap, p), 0) || ::soap_put_ns__mul(soap, p, "ns:mul", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__mul(struct soap *soap, const char *URL, struct ns__mul const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mul(soap, p), 0) || ::soap_put_ns__mul(soap, p, "ns:mul", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__mul * SOAP_FMAC4 soap_get_ns__mul(struct soap*, struct ns__mul *, const char*, const char*);

inline int soap_read_ns__mul(struct soap *soap, struct ns__mul *p)
{
	if (p)
	{	::soap_default_ns__mul(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__mul(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__mul(struct soap *soap, const char *URL, struct ns__mul *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__mul(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__mul(struct soap *soap, struct ns__mul *p)
{
	if (::soap_read_ns__mul(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__mulResponse_DEFINED
#define SOAP_TYPE_ns__mulResponse_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__mulResponse(struct soap*, struct ns__mulResponse *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__mulResponse(struct soap*, const struct ns__mulResponse *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__mulResponse(struct soap*, const char*, int, const struct ns__mulResponse *, const char*);
SOAP_FMAC3 struct ns__mulResponse * SOAP_FMAC4 soap_in_ns__mulResponse(struct soap*, const char*, struct ns__mulResponse *, const char*);
SOAP_FMAC1 struct ns__mulResponse * SOAP_FMAC2 soap_instantiate_ns__mulResponse(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__mulResponse * soap_new_ns__mulResponse(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__mulResponse(soap, n, NULL, NULL, NULL);
}

inline struct ns__mulResponse * soap_new_req_ns__mulResponse(
	struct soap *soap)
{
	struct ns__mulResponse *_p = ::soap_new_ns__mulResponse(soap);
	if (_p)
	{	::soap_default_ns__mulResponse(soap, _p);
	}
	return _p;
}

inline struct ns__mulResponse * soap_new_set_ns__mulResponse(
	struct soap *soap,
	double *result)
{
	struct ns__mulResponse *_p = ::soap_new_ns__mulResponse(soap);
	if (_p)
	{	::soap_default_ns__mulResponse(soap, _p);
		_p->result = result;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__mulResponse(struct soap*, const struct ns__mulResponse *, const char*, const char*);

inline int soap_write_ns__mulResponse(struct soap *soap, struct ns__mulResponse const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__mulResponse(soap, p), 0) || ::soap_put_ns__mulResponse(soap, p, "ns:mulResponse", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__mulResponse(struct soap *soap, const char *URL, struct ns__mulResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mulResponse(soap, p), 0) || ::soap_put_ns__mulResponse(soap, p, "ns:mulResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__mulResponse(struct soap *soap, const char *URL, struct ns__mulResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mulResponse(soap, p), 0) || ::soap_put_ns__mulResponse(soap, p, "ns:mulResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__mulResponse(struct soap *soap, const char *URL, struct ns__mulResponse const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__mulResponse(soap, p), 0) || ::soap_put_ns__mulResponse(soap, p, "ns:mulResponse", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__mulResponse * SOAP_FMAC4 soap_get_ns__mulResponse(struct soap*, struct ns__mulResponse *, const char*, const char*);

inline int soap_read_ns__mulResponse(struct soap *soap, struct ns__mulResponse *p)
{
	if (p)
	{	::soap_default_ns__mulResponse(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__mulResponse(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__mulResponse(struct soap *soap, const char *URL, struct ns__mulResponse *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__mulResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__mulResponse(struct soap *soap, struct ns__mulResponse *p)
{
	if (::soap_read_ns__mulResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__sub_DEFINED
#define SOAP_TYPE_ns__sub_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__sub(struct soap*, struct ns__sub *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__sub(struct soap*, const struct ns__sub *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__sub(struct soap*, const char*, int, const struct ns__sub *, const char*);
SOAP_FMAC3 struct ns__sub * SOAP_FMAC4 soap_in_ns__sub(struct soap*, const char*, struct ns__sub *, const char*);
SOAP_FMAC1 struct ns__sub * SOAP_FMAC2 soap_instantiate_ns__sub(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__sub * soap_new_ns__sub(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__sub(soap, n, NULL, NULL, NULL);
}

inline struct ns__sub * soap_new_req_ns__sub(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__sub *_p = ::soap_new_ns__sub(soap);
	if (_p)
	{	::soap_default_ns__sub(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}

inline struct ns__sub * soap_new_set_ns__sub(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__sub *_p = ::soap_new_ns__sub(soap);
	if (_p)
	{	::soap_default_ns__sub(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__sub(struct soap*, const struct ns__sub *, const char*, const char*);

inline int soap_write_ns__sub(struct soap *soap, struct ns__sub const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__sub(soap, p), 0) || ::soap_put_ns__sub(soap, p, "ns:sub", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__sub(struct soap *soap, const char *URL, struct ns__sub const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__sub(soap, p), 0) || ::soap_put_ns__sub(soap, p, "ns:sub", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__sub(struct soap *soap, const char *URL, struct ns__sub const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__sub(soap, p), 0) || ::soap_put_ns__sub(soap, p, "ns:sub", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__sub(struct soap *soap, const char *URL, struct ns__sub const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__sub(soap, p), 0) || ::soap_put_ns__sub(soap, p, "ns:sub", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__sub * SOAP_FMAC4 soap_get_ns__sub(struct soap*, struct ns__sub *, const char*, const char*);

inline int soap_read_ns__sub(struct soap *soap, struct ns__sub *p)
{
	if (p)
	{	::soap_default_ns__sub(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__sub(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__sub(struct soap *soap, const char *URL, struct ns__sub *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__sub(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__sub(struct soap *soap, struct ns__sub *p)
{
	if (::soap_read_ns__sub(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__subResponse_DEFINED
#define SOAP_TYPE_ns__subResponse_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__subResponse(struct soap*, struct ns__subResponse *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__subResponse(struct soap*, const struct ns__subResponse *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__subResponse(struct soap*, const char*, int, const struct ns__subResponse *, const char*);
SOAP_FMAC3 struct ns__subResponse * SOAP_FMAC4 soap_in_ns__subResponse(struct soap*, const char*, struct ns__subResponse *, const char*);
SOAP_FMAC1 struct ns__subResponse * SOAP_FMAC2 soap_instantiate_ns__subResponse(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__subResponse * soap_new_ns__subResponse(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__subResponse(soap, n, NULL, NULL, NULL);
}

inline struct ns__subResponse * soap_new_req_ns__subResponse(
	struct soap *soap)
{
	struct ns__subResponse *_p = ::soap_new_ns__subResponse(soap);
	if (_p)
	{	::soap_default_ns__subResponse(soap, _p);
	}
	return _p;
}

inline struct ns__subResponse * soap_new_set_ns__subResponse(
	struct soap *soap,
	double *result)
{
	struct ns__subResponse *_p = ::soap_new_ns__subResponse(soap);
	if (_p)
	{	::soap_default_ns__subResponse(soap, _p);
		_p->result = result;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__subResponse(struct soap*, const struct ns__subResponse *, const char*, const char*);

inline int soap_write_ns__subResponse(struct soap *soap, struct ns__subResponse const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__subResponse(soap, p), 0) || ::soap_put_ns__subResponse(soap, p, "ns:subResponse", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__subResponse(struct soap *soap, const char *URL, struct ns__subResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__subResponse(soap, p), 0) || ::soap_put_ns__subResponse(soap, p, "ns:subResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__subResponse(struct soap *soap, const char *URL, struct ns__subResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__subResponse(soap, p), 0) || ::soap_put_ns__subResponse(soap, p, "ns:subResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__subResponse(struct soap *soap, const char *URL, struct ns__subResponse const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__subResponse(soap, p), 0) || ::soap_put_ns__subResponse(soap, p, "ns:subResponse", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__subResponse * SOAP_FMAC4 soap_get_ns__subResponse(struct soap*, struct ns__subResponse *, const char*, const char*);

inline int soap_read_ns__subResponse(struct soap *soap, struct ns__subResponse *p)
{
	if (p)
	{	::soap_default_ns__subResponse(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__subResponse(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__subResponse(struct soap *soap, const char *URL, struct ns__subResponse *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__subResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__subResponse(struct soap *soap, struct ns__subResponse *p)
{
	if (::soap_read_ns__subResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__add_DEFINED
#define SOAP_TYPE_ns__add_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__add(struct soap*, struct ns__add *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__add(struct soap*, const struct ns__add *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__add(struct soap*, const char*, int, const struct ns__add *, const char*);
SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_in_ns__add(struct soap*, const char*, struct ns__add *, const char*);
SOAP_FMAC1 struct ns__add * SOAP_FMAC2 soap_instantiate_ns__add(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__add * soap_new_ns__add(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__add(soap, n, NULL, NULL, NULL);
}

inline struct ns__add * soap_new_req_ns__add(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__add *_p = ::soap_new_ns__add(soap);
	if (_p)
	{	::soap_default_ns__add(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}

inline struct ns__add * soap_new_set_ns__add(
	struct soap *soap,
	double a,
	double b)
{
	struct ns__add *_p = ::soap_new_ns__add(soap);
	if (_p)
	{	::soap_default_ns__add(soap, _p);
		_p->a = a;
		_p->b = b;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__add(struct soap*, const struct ns__add *, const char*, const char*);

inline int soap_write_ns__add(struct soap *soap, struct ns__add const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__add(soap, p), 0) || ::soap_put_ns__add(soap, p, "ns:add", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__add(struct soap *soap, const char *URL, struct ns__add const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__add(soap, p), 0) || ::soap_put_ns__add(soap, p, "ns:add", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__add(struct soap *soap, const char *URL, struct ns__add const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__add(soap, p), 0) || ::soap_put_ns__add(soap, p, "ns:add", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__add(struct soap *soap, const char *URL, struct ns__add const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__add(soap, p), 0) || ::soap_put_ns__add(soap, p, "ns:add", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_get_ns__add(struct soap*, struct ns__add *, const char*, const char*);

inline int soap_read_ns__add(struct soap *soap, struct ns__add *p)
{
	if (p)
	{	::soap_default_ns__add(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__add(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__add(struct soap *soap, const char *URL, struct ns__add *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__add(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__add(struct soap *soap, struct ns__add *p)
{
	if (::soap_read_ns__add(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE_ns__addResponse_DEFINED
#define SOAP_TYPE_ns__addResponse_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__addResponse(struct soap*, struct ns__addResponse *);
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__addResponse(struct soap*, const struct ns__addResponse *);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__addResponse(struct soap*, const char*, int, const struct ns__addResponse *, const char*);
SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_in_ns__addResponse(struct soap*, const char*, struct ns__addResponse *, const char*);
SOAP_FMAC1 struct ns__addResponse * SOAP_FMAC2 soap_instantiate_ns__addResponse(struct soap*, int, const char*, const char*, size_t*);

inline struct ns__addResponse * soap_new_ns__addResponse(struct soap *soap, int n = -1)
{
	return soap_instantiate_ns__addResponse(soap, n, NULL, NULL, NULL);
}

inline struct ns__addResponse * soap_new_req_ns__addResponse(
	struct soap *soap)
{
	struct ns__addResponse *_p = ::soap_new_ns__addResponse(soap);
	if (_p)
	{	::soap_default_ns__addResponse(soap, _p);
	}
	return _p;
}

inline struct ns__addResponse * soap_new_set_ns__addResponse(
	struct soap *soap,
	double *result)
{
	struct ns__addResponse *_p = ::soap_new_ns__addResponse(soap);
	if (_p)
	{	::soap_default_ns__addResponse(soap, _p);
		_p->result = result;
	}
	return _p;
}
SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__addResponse(struct soap*, const struct ns__addResponse *, const char*, const char*);

inline int soap_write_ns__addResponse(struct soap *soap, struct ns__addResponse const*p)
{
	soap_free_temp(soap);
	if (soap_begin_send(soap) || (::soap_serialize_ns__addResponse(soap, p), 0) || ::soap_put_ns__addResponse(soap, p, "ns:addResponse", "") || soap_end_send(soap))
			return soap->error;
	return SOAP_OK;
}

inline int soap_PUT_ns__addResponse(struct soap *soap, const char *URL, struct ns__addResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__addResponse(soap, p), 0) || ::soap_put_ns__addResponse(soap, p, "ns:addResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_ns__addResponse(struct soap *soap, const char *URL, struct ns__addResponse const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__addResponse(soap, p), 0) || ::soap_put_ns__addResponse(soap, p, "ns:addResponse", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_ns__addResponse(struct soap *soap, const char *URL, struct ns__addResponse const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || (::soap_serialize_ns__addResponse(soap, p), 0) || ::soap_put_ns__addResponse(soap, p, "ns:addResponse", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_get_ns__addResponse(struct soap*, struct ns__addResponse *, const char*, const char*);

inline int soap_read_ns__addResponse(struct soap *soap, struct ns__addResponse *p)
{
	if (p)
	{	::soap_default_ns__addResponse(soap, p);
		if (soap_begin_recv(soap) || ::soap_get_ns__addResponse(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_ns__addResponse(struct soap *soap, const char *URL, struct ns__addResponse *p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_ns__addResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_ns__addResponse(struct soap *soap, struct ns__addResponse *p)
{
	if (::soap_read_ns__addResponse(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_PointerToSOAP_ENV__Reason_DEFINED
#define SOAP_TYPE_PointerToSOAP_ENV__Reason_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap*, struct SOAP_ENV__Reason *const*);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap*, const char *, int, struct SOAP_ENV__Reason *const*, const char *);
SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap*, const char*, struct SOAP_ENV__Reason **, const char*);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap*, struct SOAP_ENV__Reason *const*, const char*, const char*);
SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap*, struct SOAP_ENV__Reason **, const char*, const char*);
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_PointerToSOAP_ENV__Detail_DEFINED
#define SOAP_TYPE_PointerToSOAP_ENV__Detail_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap*, struct SOAP_ENV__Detail *const*);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap*, const char *, int, struct SOAP_ENV__Detail *const*, const char *);
SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap*, const char*, struct SOAP_ENV__Detail **, const char*);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap*, struct SOAP_ENV__Detail *const*, const char*, const char*);
SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap*, struct SOAP_ENV__Detail **, const char*, const char*);
#endif

#endif

#ifndef WITH_NOGLOBAL

#ifndef SOAP_TYPE_PointerToSOAP_ENV__Code_DEFINED
#define SOAP_TYPE_PointerToSOAP_ENV__Code_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap*, struct SOAP_ENV__Code *const*);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap*, const char *, int, struct SOAP_ENV__Code *const*, const char *);
SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap*, const char*, struct SOAP_ENV__Code **, const char*);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap*, struct SOAP_ENV__Code *const*, const char*, const char*);
SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap*, struct SOAP_ENV__Code **, const char*, const char*);
#endif

#endif

#ifndef SOAP_TYPE_PointerTodouble_DEFINED
#define SOAP_TYPE_PointerTodouble_DEFINED
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap*, double *const*);
SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap*, const char *, int, double *const*, const char *);
SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap*, const char*, double **, const char*);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap*, double *const*, const char*, const char*);
SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap*, double **, const char*, const char*);
#endif

#ifndef SOAP_TYPE__QName_DEFINED
#define SOAP_TYPE__QName_DEFINED

inline void soap_default__QName(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT__QName
	*a = SOAP_DEFAULT__QName;
#else
	*a = (char *)0;
#endif
}
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap*, char *const*);

#define soap__QName2s(soap, a) soap_QName2s(soap, (a))
SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap*, const char*, int, char*const*, const char*);

#define soap_s2_QName(soap, s, a) soap_s2QName((soap), (s), (char**)(a), 0, -1, NULL)
SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap*, const char*, char **, const char*);

#define soap_instantiate__QName soap_instantiate_string


#define soap_new__QName soap_new_string

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap*, char *const*, const char*, const char*);

inline int soap_write__QName(struct soap *soap, char *const*p)
{
	soap_free_temp(soap);
	if (p)
	{	if (soap_begin_send(soap) || ::soap_put__QName(soap, p, "QName", "") || soap_end_send(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_PUT__QName(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put__QName(soap, p, "QName", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH__QName(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put__QName(soap, p, "QName", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send__QName(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put__QName(soap, p, "QName", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap*, char **, const char*, const char*);

inline int soap_read__QName(struct soap *soap, char **p)
{
	if (p)
	{	if (soap_begin_recv(soap) || ::soap_get__QName(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET__QName(struct soap *soap, const char *URL, char **p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read__QName(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv__QName(struct soap *soap, char **p)
{
	if (::soap_read__QName(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#ifndef SOAP_TYPE__XML_DEFINED
#define SOAP_TYPE__XML_DEFINED
#endif

#ifndef SOAP_TYPE_string_DEFINED
#define SOAP_TYPE_string_DEFINED

inline void soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}
SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap*, char *const*);

#define soap_string2s(soap, a) (a)
SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap*, const char*, int, char*const*, const char*);

#define soap_s2string(soap, s, a) soap_s2char((soap), (s), (char**)(a), 1, 0, -1, NULL)
SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap*, const char*, char **, const char*);

SOAP_FMAC3 char * * SOAP_FMAC4 soap_new_string(struct soap *soap, int n = -1);
SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap*, char *const*, const char*, const char*);

inline int soap_write_string(struct soap *soap, char *const*p)
{
	soap_free_temp(soap);
	if (p)
	{	if (soap_begin_send(soap) || ::soap_put_string(soap, p, "string", "") || soap_end_send(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_PUT_string(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_PUT(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_string(soap, p, "string", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_PATCH_string(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_PATCH(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_string(soap, p, "string", "") || soap_end_send(soap) || soap_recv_empty_response(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}

inline int soap_POST_send_string(struct soap *soap, const char *URL, char *const*p)
{
	soap_free_temp(soap);
	if (soap_POST(soap, URL, NULL, "text/xml; charset=utf-8") || ::soap_put_string(soap, p, "string", "") || soap_end_send(soap))
		return soap_closesock(soap);
	return SOAP_OK;
}
SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap*, char **, const char*, const char*);

inline int soap_read_string(struct soap *soap, char **p)
{
	if (p)
	{	if (soap_begin_recv(soap) || ::soap_get_string(soap, p, NULL, NULL) == NULL || soap_end_recv(soap))
			return soap->error;
	}
	return SOAP_OK;
}

inline int soap_GET_string(struct soap *soap, const char *URL, char **p)
{
	if (soap_GET(soap, URL, NULL) || ::soap_read_string(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}

inline int soap_POST_recv_string(struct soap *soap, char **p)
{
	if (::soap_read_string(soap, p))
		return soap_closesock(soap);
	return soap_closesock(soap);
}
#endif

#endif

/* End of soapH.h */
