/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchReplica;
import org.eclipse.jgit.internal.ketch.LocalReplica;
import org.eclipse.jgit.internal.ketch.RemoteGitReplica;
import org.eclipse.jgit.internal.ketch.ReplicaConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KetchSystem {
    private static final Random RNG = new Random();
    private final ScheduledExecutorService executor;
    private final String txnNamespace;
    private final String txnAccepted;
    private final String txnCommitted;
    private final String txnStage;

    public static ScheduledExecutorService defaultExecutor() {
        return DefaultExecutorHolder.I;
    }

    public KetchSystem() {
        this(KetchSystem.defaultExecutor(), "refs/txn/");
    }

    public KetchSystem(ScheduledExecutorService executor, String txnNamespace) {
        this.executor = executor;
        this.txnNamespace = txnNamespace;
        this.txnAccepted = txnNamespace + "accepted";
        this.txnCommitted = txnNamespace + "committed";
        this.txnStage = txnNamespace + "stage/";
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public String getTxnNamespace() {
        return this.txnNamespace;
    }

    public String getTxnAccepted() {
        return this.txnAccepted;
    }

    public String getTxnCommitted() {
        return this.txnCommitted;
    }

    public String getTxnStage() {
        return this.txnStage;
    }

    public PersonIdent newCommitter() {
        String name = "ketch";
        String email = "ketch@system";
        return new PersonIdent(name, email);
    }

    @Nullable
    public String newLeaderTag() {
        int n = RNG.nextInt(0x1000000);
        return String.format("%06x", n);
    }

    public KetchLeader createLeader(final Repository repo) throws URISyntaxException {
        KetchLeader leader = new KetchLeader(this){

            @Override
            protected Repository openRepository() {
                repo.incrementOpen();
                return repo;
            }
        };
        leader.setReplicas(this.createReplicas(leader, repo));
        return leader;
    }

    protected List<KetchReplica> createReplicas(KetchLeader leader, Repository repo) throws URISyntaxException {
        ArrayList<KetchReplica> replicas = new ArrayList<KetchReplica>();
        StoredConfig cfg = repo.getConfig();
        String localName = KetchSystem.getLocalName(cfg);
        for (String name : cfg.getSubsections("remote")) {
            if (!KetchSystem.hasParticipation(cfg, name)) continue;
            ReplicaConfig kc = ReplicaConfig.newFromConfig(cfg, name);
            if (name.equals(localName)) {
                replicas.add(new LocalReplica(leader, name, kc));
                continue;
            }
            RemoteConfig rc = new RemoteConfig(cfg, name);
            List<URIish> uris = rc.getPushURIs();
            if (uris.isEmpty()) {
                uris = rc.getURIs();
            }
            for (URIish uri : uris) {
                String n = uris.size() == 1 ? name : uri.getHost();
                replicas.add(new RemoteGitReplica(leader, n, uri, kc, rc));
            }
        }
        return replicas;
    }

    private static boolean hasParticipation(Config cfg, String name) {
        return cfg.getString("remote", name, "ketch-type") != null;
    }

    private static String getLocalName(Config cfg) {
        return cfg.getString("ketch", null, "name");
    }

    static long delay(long last, long min2, long max) {
        long r = Math.max(0L, last * 3L - min2);
        if (r > 0L) {
            int c = (int)Math.min(r + 1L, Integer.MAX_VALUE);
            r = RNG.nextInt(c);
        }
        return Math.max(Math.min(min2 + r, max), min2);
    }

    static class DefaultExecutorHolder {
        private static final Logger log = LoggerFactory.getLogger(KetchSystem.class);
        static final ScheduledExecutorService I = DefaultExecutorHolder.create();

        private static ScheduledExecutorService create() {
            int cores = Runtime.getRuntime().availableProcessors();
            int threads = Math.max(5, cores);
            log.info("Using {} threads", (Object)threads);
            return Executors.newScheduledThreadPool(threads, new ThreadFactory(){
                private final AtomicInteger threadCnt = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    int id = this.threadCnt.incrementAndGet();
                    Thread thr = new Thread(r);
                    thr.setName("KetchExecutor-" + id);
                    return thr;
                }
            });
        }

        private DefaultExecutorHolder() {
        }
    }
}

