/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.helper.Aspect;
import pcgen.core.Ability;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class AspectToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    @Override
    public String getTokenName() {
        return "ASPECT";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " expecting '|', format is: " + "AspectName|Aspect value|Variable|... was: " + value, context);
        }
        String key = value.substring(0, pipeLoc);
        if (key.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty type, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        String val = value.substring(pipeLoc + 1);
        if (val.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        if (val.startsWith("|")) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + value, context);
        }
        Aspect a = this.parseAspect(key, val);
        MapChanges<AspectName, List<Aspect>> mc = context.getObjectContext().getMapChanges(ability, MapKey.ASPECT);
        Map<AspectName, List<Aspect>> fullMap = mc.getAdded();
        List<Aspect> aspects = fullMap.get(a.getKey());
        if (aspects == null) {
            aspects = new ArrayList<Aspect>();
        }
        aspects.add(a);
        context.getObjectContext().put(ability, MapKey.ASPECT, a.getKey(), aspects);
        return ParseResult.SUCCESS;
    }

    public Aspect parseAspect(String name, String aspectDef) {
        StringTokenizer tok = new StringTokenizer(aspectDef, "|");
        String firstToken = tok.nextToken();
        Aspect aspect = new Aspect(name, EntityEncoder.decode(firstToken));
        boolean isPre = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (PreParserFactory.isPreReqString(token)) {
                Prerequisite prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    Logging.errorPrint(this.getTokenName() + " had invalid prerequisite : " + token);
                    return null;
                }
                aspect.addPrerequisite(prereq);
                isPre = true;
                continue;
            }
            if (isPre) {
                Logging.errorPrint("Invalid " + this.getTokenName() + ": " + name);
                Logging.errorPrint("  PRExxx must be at the END of the Token");
                return null;
            }
            aspect.addVariable(token);
        }
        return aspect;
    }

    @Override
    public String[] unparse(LoadContext context, Ability ability) {
        MapChanges<AspectName, List<Aspect>> changes = context.getObjectContext().getMapChanges(ability, MapKey.ASPECT);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Set<AspectName> keys = changes.getAdded().keySet();
        for (AspectName an : keys) {
            List<Aspect> aspects = changes.getAdded().get(an);
            for (int i = 0; i < aspects.size(); ++i) {
                Aspect q = aspects.get(i);
                set.add(q.getName() + "|" + q.getPCCText());
            }
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

