/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.io.File;
import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class DirToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "DIR";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        String dirType = "";
        if (aTok.hasMoreTokens()) {
            dirType = aTok.nextToken();
        }
        if ("PCGEN".equals(dirType)) {
            retString = DirToken.getPCGenToken();
        } else if ("TEMPLATES".equals(dirType)) {
            retString = DirToken.getTemplatesToken();
        } else if ("PCG".equals(dirType)) {
            retString = DirToken.getPcgToken();
        } else if ("HTML".equals(dirType)) {
            retString = DirToken.getHtmlToken();
        } else if ("TEMP".equals(dirType)) {
            retString = DirToken.getTempToken();
        } else {
            Logging.errorPrint("DIR: Unknown Dir: " + dirType);
            retString = dirType;
        }
        return retString;
    }

    public static String getHtmlToken() {
        return SettingsHandler.getHTMLOutputSheetPath();
    }

    public static String getPCGenToken() {
        return new File(ConfigurationSettings.getSystemsDir()).getAbsolutePath();
    }

    public static String getPcgToken() {
        return new File(PCGenSettings.getPcgDir()).getAbsolutePath();
    }

    public static String getTempToken() {
        return SettingsHandler.getTempPath().getAbsolutePath();
    }

    public static String getTemplatesToken() {
        return new File(ConfigurationSettings.getOutputSheetsDir()).getAbsolutePath();
    }
}

