/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import org.apache.commons.lang.SystemUtils;
import pcgen.system.PropertyContext;

public final class ConfigurationSettings
extends PropertyContext {
    public static final String USER_LANGUAGE = "language";
    public static final String USER_COUNTRY = "country";
    public static final String SETTINGS_FILES_PATH = "settingsPath";
    public static final String SYSTEMS_DIR = "systemsPath";
    public static final String THEME_PACK_DIR = "themesPath";
    public static final String OUTPUT_SHEETS_DIR = "osPath";
    public static final String PLUGINS_DIR = "pluginsPath";
    public static final String PREVIEW_DIR = "previewPath";
    public static final String VENDOR_DATA_DIR = "vendordataPath";
    public static final String HOMEBREW_DATA_DIR = "homebrewdataPath";
    public static final String DOCS_DIR = "docsPath";
    public static final String PCC_FILES_DIR = "pccFilesPath";
    public static final String CUSTOM_DATA_DIR = "customPath";
    private static ConfigurationSettings instance = null;
    public static final String APPLICATION = "pcgen";

    private ConfigurationSettings(String configFileName) {
        super(configFileName);
        this.setProperty(USER_LANGUAGE, SystemUtils.USER_LANGUAGE);
        this.setProperty(USER_COUNTRY, SystemUtils.USER_COUNTRY);
        this.setProperty(THEME_PACK_DIR, "@lib/lnf/themes".replace('/', File.separatorChar));
        this.setProperty(SYSTEMS_DIR, "@system");
        this.setProperty(OUTPUT_SHEETS_DIR, "@outputsheets");
        this.setProperty(PLUGINS_DIR, "@plugins");
        this.setProperty(PREVIEW_DIR, "@preview");
        this.setProperty(DOCS_DIR, "@docs");
        this.setProperty(PCC_FILES_DIR, "@data");
    }

    @Override
    protected void beforePropertiesSaved() {
        ConfigurationSettings.relativize(THEME_PACK_DIR);
        ConfigurationSettings.relativize(SYSTEMS_DIR);
        ConfigurationSettings.relativize(OUTPUT_SHEETS_DIR);
        ConfigurationSettings.relativize(PLUGINS_DIR);
        ConfigurationSettings.relativize(PREVIEW_DIR);
        ConfigurationSettings.relativize(DOCS_DIR);
        ConfigurationSettings.relativize(PCC_FILES_DIR);
    }

    public static String getLanguage() {
        return ConfigurationSettings.getSystemProperty(USER_LANGUAGE);
    }

    public static void setLanguage(String language) {
        ConfigurationSettings.setSystemProperty(USER_LANGUAGE, language);
    }

    public static String getCountry() {
        return ConfigurationSettings.getSystemProperty(USER_COUNTRY);
    }

    public static void setCountry(String country) {
        ConfigurationSettings.setSystemProperty(USER_COUNTRY, country);
    }

    public static String getUserDir() {
        return SystemUtils.USER_DIR;
    }

    public static ConfigurationSettings getInstance() {
        return ConfigurationSettings.getInstance(null);
    }

    public static ConfigurationSettings getInstance(String configFileName) {
        if (instance == null) {
            instance = new ConfigurationSettings(configFileName == null ? "config.ini" : configFileName);
        }
        return instance;
    }

    public static String getThemePackDir() {
        return ConfigurationSettings.getDirectory(THEME_PACK_DIR);
    }

    public static String getSystemsDir() {
        return ConfigurationSettings.getDirectory(SYSTEMS_DIR);
    }

    public static String getOutputSheetsDir() {
        return ConfigurationSettings.getDirectory(OUTPUT_SHEETS_DIR);
    }

    public static String getPluginsDir() {
        return ConfigurationSettings.getDirectory(PLUGINS_DIR);
    }

    public static String getPreviewDir() {
        return ConfigurationSettings.getDirectory(PREVIEW_DIR);
    }

    public static String getDocsDir() {
        return ConfigurationSettings.getDirectory(DOCS_DIR);
    }

    public static String getPccFilesDir() {
        return ConfigurationSettings.getDirectory(PCC_FILES_DIR);
    }

    public static String getSettingsDir() {
        return ConfigurationSettings.getDirectory(SETTINGS_FILES_PATH);
    }

    public static String initSystemProperty(String key, String defaultValue) {
        return ConfigurationSettings.getInstance().initProperty(key, defaultValue);
    }

    public static String getSystemProperty(String key) {
        return ConfigurationSettings.getInstance().getProperty(key);
    }

    public static Object setSystemProperty(String key, String value) {
        return ConfigurationSettings.getInstance().setProperty(key, value);
    }

    private static String getDirectory(String key) {
        if (SETTINGS_FILES_PATH.equals(key)) {
            return ConfigurationSettings.getSettingsDirFromFilePath(ConfigurationSettings.getSystemProperty(key));
        }
        return ConfigurationSettings.expandRelativePath(ConfigurationSettings.getSystemProperty(key));
    }

    private static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = SystemUtils.USER_DIR + File.separator + path.substring(1);
        }
        return path;
    }

    private static String unexpandRelativePath(String path) {
        if (path.startsWith(SystemUtils.USER_DIR + File.separator)) {
            path = "@" + path.substring(SystemUtils.USER_DIR.length() + 1);
        }
        return path;
    }

    private static void relativize(String property) {
        ConfigurationSettings.setSystemProperty(property, ConfigurationSettings.unexpandRelativePath(ConfigurationSettings.getSystemProperty(property)));
    }

    public static String getSettingsDirFromFilePath(String fType) {
        String path;
        if (fType == null || fType.length() < 1) {
            fType = ConfigurationSettings.getDefaultSettingsFilesPath();
        }
        try {
            path = SettingsFilesPath.valueOf(fType).getSettingsDir();
        }
        catch (IllegalArgumentException ex) {
            path = fType;
        }
        return path;
    }

    public static String getDefaultSettingsFilesPath() {
        String fType = SystemUtils.IS_OS_MAC_OSX ? SettingsFilesPath.mac_user.name() : (SystemUtils.IS_OS_UNIX ? SettingsFilesPath.FD_USER.name() : SettingsFilesPath.user.name());
        return fType;
    }

    public static String getUserSettingsDirFromFilePath() {
        return ConfigurationSettings.getSettingsDirFromFilePath(ConfigurationSettings.getDefaultSettingsFilesPath());
    }

    public static enum SettingsFilesPath {
        user,
        pcgen,
        FD_USER,
        mac_user;


        public String getSettingsDir() {
            switch (this) {
                case user: {
                    return SystemUtils.USER_HOME + File.separator + "." + ConfigurationSettings.APPLICATION;
                }
                case pcgen: {
                    return SystemUtils.USER_DIR + File.separator + "settings";
                }
                case mac_user: {
                    return SystemUtils.USER_HOME + "/Library/Preferences/" + ConfigurationSettings.APPLICATION;
                }
                case FD_USER: {
                    String config = System.getenv("XDG_CONFIG_HOME");
                    if (config == null || config.isEmpty()) {
                        config = SystemUtils.USER_HOME + File.separator + ".config";
                    }
                    return config + File.separator + ConfigurationSettings.APPLICATION;
                }
            }
            throw new InternalError();
        }
    }
}

