/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import pcgen.gui2.tools.CommonMenuText;
import pcgen.gui2.tools.Icons;

public class PCGenAction
extends AbstractAction {
    public PCGenAction(String prop) {
        this(prop, null, null, null, new Object[0]);
    }

    public PCGenAction(String prop, Icons icon) {
        this(prop, null, null, icon, new Object[0]);
    }

    public PCGenAction(String prop, String command) {
        this(prop, command, null, null, new Object[0]);
    }

    public PCGenAction(String prop, String command, Icons icon) {
        this(prop, command, null, icon, new Object[0]);
    }

    public PCGenAction(String prop, String command, String accelerator) {
        this(prop, command, accelerator, null, new Object[0]);
    }

    public PCGenAction(String prop, String command, String accelerator, Icons icon, Object ... substitutes) {
        CommonMenuText.name(this, prop, substitutes);
        if (command != null) {
            this.putValue("ActionCommandKey", command);
        }
        if (accelerator != null) {
            KeyStroke aKey;
            int iShortCut = 2;
            int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            StringTokenizer aTok = new StringTokenizer(accelerator);
            String aString = aTok.nextToken();
            if (aString.equalsIgnoreCase("shortcut")) {
                iShortCut = menuShortcutKeyMask;
            } else if (aString.equalsIgnoreCase("alt")) {
                iShortCut = System.getProperty("mrj.version") != null ? menuShortcutKeyMask | 8 : 8;
            } else if (aString.equalsIgnoreCase("shift-shortcut")) {
                iShortCut = menuShortcutKeyMask | 1;
            } else if (aString.matches("F[0-9]+")) {
                iShortCut = 0;
            }
            if (aTok.hasMoreTokens()) {
                aString = aTok.nextToken();
            }
            if ((aKey = KeyStroke.getKeyStroke(aString)) != null) {
                int iKeyCode = aKey.getKeyCode();
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(iKeyCode, iShortCut));
            }
        }
        if (icon != null) {
            this.putValue("SmallIcon", icon.getImageIcon());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

