/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.Utility;
import pcgen.system.LoggingRecorder;
import pcgen.util.Logging;

public class DebugDialog
extends JDialog {
    private static MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private final LogPanel logPanel;
    private final MemoryPanel memoryPanel;

    public DebugDialog(PCGenFrame frame) {
        super(frame);
        this.setTitle("Log & Memory Use");
        this.logPanel = new LogPanel();
        this.memoryPanel = new MemoryPanel();
        this.initComponents();
        this.pack();
        this.setSize(700, 500);
        Utility.installEscapeCloseOperation(this);
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.logPanel, "Center");
        contentPane.add((Component)this.memoryPanel, "South");
        this.setDefaultCloseOperation(1);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.memoryPanel.dispose();
    }

    private static class MemoryTableModel
    extends AbstractTableModel {
        private static long megaByte = 0x100000L;

        private MemoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return 2;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Initial";
                }
                case 2: {
                    return "Used";
                }
                case 3: {
                    return "Committed";
                }
                case 4: {
                    return "Max";
                }
                case 5: {
                    return "% Used";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MemoryUsage usage = rowIndex == 0 ? memoryBean.getHeapMemoryUsage() : memoryBean.getNonHeapMemoryUsage();
            switch (columnIndex) {
                case 0: {
                    return rowIndex == 0 ? "Heap" : "Non-Heap";
                }
                case 1: {
                    return usage.getInit();
                }
                case 2: {
                    return usage.getUsed();
                }
                case 3: {
                    return usage.getCommitted();
                }
                case 4: {
                    return usage.getMax();
                }
                case 5: {
                    return 100L * usage.getUsed() / usage.getMax();
                }
            }
            return 0;
        }
    }

    private static class MemoryPanel
    extends JPanel
    implements ActionListener {
        private final Timer timer = new Timer(1000, this);
        private final JButton gcButton = new JButton("Run Garbage Collection");
        private final JTable memoryTable = new JTable(new MemoryTableModel());

        public MemoryPanel() {
            this.initComponents();
            this.timer.start();
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createTitledBorder("Memory Usage"));
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.memoryTable){

                @Override
                public Dimension getMaximumSize() {
                    return super.getPreferredSize();
                }
            }, "Center");
            this.memoryTable.setFocusable(false);
            this.memoryTable.setRowSelectionAllowed(false);
            this.memoryTable.setPreferredScrollableViewportSize(this.memoryTable.getPreferredSize());
            this.memoryTable.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){
                DecimalFormat format = new DecimalFormat("###,###,###");

                @Override
                protected void setValue(Object value) {
                    this.setHorizontalAlignment(4);
                    this.setText(this.format.format(value));
                }
            });
            this.gcButton.setActionCommand("COLLECT");
            this.gcButton.addActionListener(this);
            this.add((Component)this.gcButton, "South");
        }

        public void dispose() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("COLLECT".equals(e.getActionCommand())) {
                memoryBean.gc();
                Logging.log(Logging.INFO, MessageFormat.format("Memory used after manual GC, Heap: {0}, Non heap: {1}", memoryBean.getHeapMemoryUsage().getUsed(), memoryBean.getNonHeapMemoryUsage().getUsed()));
            } else {
                this.memoryTable.repaint();
            }
        }
    }

    private static class LogPanel
    extends JPanel
    implements ActionListener,
    MouseListener {
        private final JTextArea logText = new JTextArea();
        private final JButton clearButton = new JButton("Clear Log");

        public LogPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createTitledBorder("Debug Log"));
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.logText){

                @Override
                public Dimension getMaximumSize() {
                    return super.getPreferredSize();
                }
            }, "Center");
            this.add((Component)this.clearButton, "South");
            this.logText.setFocusable(true);
            this.logText.setEditable(false);
            this.logText.addMouseListener(this);
            this.clearButton.setActionCommand("CLEAR");
            this.clearButton.addActionListener(this);
            this.initDebugLog();
        }

        private void initDebugLog() {
            this.logText.setEditable(false);
            this.logText.setText(LoggingRecorder.getLogs());
            Logging.registerHandler(new LogHandler());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int caretPos = this.determineCaretPosition(e);
            String line = this.getCurrentIndexedLine(caretPos);
            File file = this.extractFileFromLine(line);
            if (file != null) {
                try {
                    this.openFile(file);
                }
                catch (IOException e1) {
                    Logging.log(Level.WARNING, "Unable to open the requested file: " + file.getName(), e1);
                }
            } else {
                Logging.log(Level.FINER, "No file in current line.");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("CLEAR".equals(e.getActionCommand())) {
                LoggingRecorder.clearLogs();
                this.initDebugLog();
            } else {
                this.logText.repaint();
            }
        }

        private void openFile(File file) throws IOException {
            if (Desktop.isDesktopSupported()) {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    String cmd = "rundll32 url.dll,FileProtocolHandler " + file.getCanonicalPath();
                    Runtime.getRuntime().exec(cmd);
                } else {
                    Desktop.getDesktop().open(file);
                }
            }
        }

        protected File extractFileFromLine(String line) {
            String[] parts;
            File file = null;
            for (String part : parts = line.split("\"")) {
                file = this.convertURItoFileIfPossible(part);
                if (file == null) {
                    String[] subParts;
                    for (String subPart : subParts = part.split(" ")) {
                        file = this.convertURItoFileIfPossible(subPart);
                        if (file == null) continue;
                        return file;
                    }
                    continue;
                }
                return file;
            }
            return file;
        }

        private File convertURItoFileIfPossible(String filePart) {
            File file = null;
            try {
                URI fileURI = this.extractFileURIFromLinePart(filePart);
                file = new File(fileURI);
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return file;
        }

        private URI extractFileURIFromLinePart(String part) throws URISyntaxException {
            String filePart = part;
            if (part.indexOf(58) < 0) {
                filePart = "file://" + part;
            }
            return new URI(filePart);
        }

        private String getCurrentIndexedLine(int index) {
            int startIndex = this.logText.getText().lastIndexOf("\n", index) + 1;
            int endIndex = this.logText.getText().indexOf("\n", index);
            String line = "";
            if (startIndex >= 0 && endIndex >= startIndex) {
                line = this.logText.getText().substring(startIndex, endIndex);
            }
            return line;
        }

        private int determineCaretPosition(MouseEvent e) {
            this.logText.setCaretPosition(this.logText.viewToModel(e.getPoint()));
            int caretPos = this.logText.getCaretPosition();
            return caretPos;
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        private class LogHandler
        extends Handler
        implements Runnable {
            public LogHandler() {
                this.setLevel(Logging.DEBUG);
            }

            @Override
            public void publish(LogRecord record) {
                SwingUtilities.invokeLater(this);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void run() {
                LogPanel.this.logText.setText(LoggingRecorder.getLogs());
            }
        }
    }
}

