/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;

public final class PrerequisiteUtilities {
    private PrerequisiteUtilities() {
    }

    public static String preReqHTMLStringsForList(PlayerCharacter aPC, CDOMObject aObj, Collection<Prerequisite> aList, boolean includeHeader) {
        if (aList == null || aList.isEmpty()) {
            return "";
        }
        StringBuilder pString = new StringBuilder(aList.size() * 20);
        ArrayList<Prerequisite> newList = new ArrayList<Prerequisite>();
        boolean first = true;
        for (Prerequisite prereq : aList) {
            newList.clear();
            newList.add(prereq);
            if (first) {
                first = false;
            } else {
                pString.append(" and ");
            }
            String bString = PrereqHandler.toHtmlString(newList);
            boolean passes = aObj instanceof Equipment ? PrereqHandler.passesAll(newList, (Equipment)aObj, aPC) : PrereqHandler.passesAll(newList, aPC, null);
            if (!passes) {
                pString.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                pString.append("<i>");
            }
            StringTokenizer aTok = new StringTokenizer(bString, "&<>", true);
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (aString.equals("<")) {
                    pString.append("&lt;");
                    continue;
                }
                if (aString.equals(">")) {
                    pString.append("&gt;");
                    continue;
                }
                if (aString.equals("&")) {
                    pString.append("&amp;");
                    continue;
                }
                pString.append(aString);
            }
            if (passes) continue;
            pString.append("</i>");
            pString.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
        }
        if (pString.toString().indexOf(60) >= 0) {
            pString.insert(0, "<font>");
            pString.append("</font>");
            if (includeHeader && pString.toString().indexOf(60) >= 0) {
                pString.insert(0, "<html>");
                pString.append("</html>");
            }
        }
        String result = pString.toString().replaceAll("##BR##", "<br>");
        return result;
    }

    public static int passesAbilityTest(Prerequisite prereq, PlayerCharacter character, int numMatches, String categoryName) {
        boolean countMults = prereq.isCountMultiples();
        boolean keyIsAny = prereq.getKey().equalsIgnoreCase("ANY");
        boolean keyIsType = PrerequisiteUtilities.isTypeTest(prereq.getKey());
        String strippedKey = keyIsType ? prereq.getKey().substring(5) : prereq.getKey();
        int runningTotal = 0;
        Set<Ability> abilityList = PrerequisiteUtilities.buildAbilityList(character, categoryName);
        if (!abilityList.isEmpty()) {
            for (Ability ability : abilityList) {
                String abilityKey = ability.getKeyName();
                if (keyIsAny || !keyIsType && abilityKey.equalsIgnoreCase(strippedKey) || keyIsType && ability.isType(strippedKey)) {
                    if (prereq.getSubKey() != null) {
                        runningTotal += PrerequisiteUtilities.dealWithSubKey(prereq, character, strippedKey, ability);
                        continue;
                    }
                    ++runningTotal;
                    if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || !countMults) continue;
                    List<String> assocs = character.getConsolidatedAssociationList(ability);
                    int select = ability.getSafe(FormulaKey.SELECT).resolve(character, "").intValue();
                    int num = assocs.size() / select - 1;
                    if (num <= 0) continue;
                    runningTotal += num;
                    continue;
                }
                if (prereq.getSubKey() == null) continue;
                int len = 5;
                boolean subKeyIsType = PrerequisiteUtilities.isTypeTest(prereq.getSubKey());
                String subKey = subKeyIsType ? prereq.getSubKey().substring(5) : prereq.getSubKey();
                String s1 = strippedKey + " (" + subKey + ")";
                String s2 = strippedKey + "(" + subKey + ")";
                if (!abilityKey.equalsIgnoreCase(s1) && !ability.getKeyName().equalsIgnoreCase(s2)) continue;
                ++runningTotal;
                if (countMults) continue;
                break;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, numMatches);
        return runningTotal;
    }

    private static int dealWithSubKey(Prerequisite prereq, PlayerCharacter character, String key, Ability ability) {
        boolean countMults = prereq.isCountMultiples();
        int runningTotal = 0;
        String subKey = prereq.getSubKey();
        boolean subKeyIsType = PrerequisiteUtilities.isTypeTest(subKey);
        int wildCardPos = subKey.indexOf(37);
        List<String> assocs = character.getConsolidatedAssociationList(ability);
        if (subKeyIsType) {
            String type = prereq.getSubKey().substring(5);
            runningTotal = PrerequisiteUtilities.countSubKeyType(character, ability, type, countMults);
        } else if (ability.getKeyName().equalsIgnoreCase(key) && PrerequisiteUtilities.hasAssoc(assocs, subKey)) {
            if (countMults && ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                int select = ability.getSafe(FormulaKey.SELECT).resolve(character, "").intValue();
                int countMatchingSubKey = PrerequisiteUtilities.countSubkeyMatches(assocs, subKey);
                runningTotal = countMatchingSubKey / select;
            } else {
                runningTotal = 1;
            }
        } else if (wildCardPos > -1) {
            String preWildcard = wildCardPos == 0 ? "" : subKey.substring(0, wildCardPos).toUpperCase();
            runningTotal = PrerequisiteUtilities.countSubKeyWildcardMatch(character, countMults, preWildcard, ability);
        }
        return runningTotal;
    }

    private static int countSubkeyMatches(List<String> assocs, String subKey) {
        int numMatches = 0;
        for (String s : assocs) {
            if (!subKey.equalsIgnoreCase(s)) continue;
            ++numMatches;
        }
        return numMatches;
    }

    private static boolean hasAssoc(List<String> assocs, String subKey) {
        for (String s : assocs) {
            if (!subKey.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeTest(String key) {
        return key.startsWith("TYPE=") || key.startsWith("TYPE.");
    }

    private static int countSubKeyWildcardMatch(PlayerCharacter character, boolean countMults, String preWilcard, Ability ability) {
        int runningTotal = 0;
        for (String assoc : character.getConsolidatedAssociationList(ability)) {
            String fString = assoc.toUpperCase();
            if (preWilcard.length() != 0 && !fString.startsWith(preWilcard)) continue;
            ++runningTotal;
            if (countMults) continue;
            break;
        }
        return runningTotal;
    }

    private static int countSubKeyType(PlayerCharacter aPC, Ability ability, String type, boolean countMults) {
        List<String> selectedList = aPC.getConsolidatedAssociationList(ability);
        ChooseInformation<?> chooseInformation = ability.getSafe(ObjectKey.CHOOSE_INFO);
        String aChoiceString = chooseInformation.getName();
        if (aChoiceString.startsWith("SKILL")) {
            return PrerequisiteUtilities.subKeySkill(countMults, type, selectedList);
        }
        if (aChoiceString.startsWith("WEAPONPROFICIENCY")) {
            return PrerequisiteUtilities.subKeyWeaponProf(countMults, type, selectedList);
        }
        if (aChoiceString.startsWith("DOMAIN")) {
            return PrerequisiteUtilities.subKeyDomain(countMults, type, selectedList);
        }
        if (aChoiceString.startsWith("SPELL")) {
            return PrerequisiteUtilities.subKeySpell(countMults, type, selectedList);
        }
        return 0;
    }

    private static Set<Ability> buildAbilityList(PlayerCharacter character, String categoryName) {
        WrappedMapSet abilityList = new WrappedMapSet(IdentityHashMap.class);
        if (character != null) {
            AbilityCategory cat = SettingsHandler.getGame().getAbilityCategory(categoryName);
            if (cat == null) {
                Logging.errorPrint("Invalid category " + categoryName + " in PREABILITY");
                return abilityList;
            }
            if (!cat.getParentCategory().equals(cat)) {
                Logging.errorPrint("Invalid use of child category in PREABILITY");
            }
            for (CNAbility cna : character.getCNAbilities(cat)) {
                abilityList.add(cna.getAbility());
            }
            Collection<AbilityCategory> allCats = SettingsHandler.getGame().getAllAbilityCategories();
            for (AbilityCategory aCat : allCats) {
                for (CNAbility cna : character.getPoolAbilities(aCat)) {
                    for (CDOMReference<Ability> ref : cna.getAbility().getSafeListFor(ListKey.SERVES_AS_ABILITY)) {
                        for (Ability ab : ref.getContainedObjects()) {
                            abilityList.add(ab);
                        }
                    }
                }
            }
        }
        return abilityList;
    }

    private static int subKeySpell(boolean countMults, String cType, List<String> selectedList) {
        int returnTotal = 0;
        for (String spell : selectedList) {
            Spell sp = Globals.getSpellKeyed(spell);
            if (sp == null || !sp.isType(cType)) continue;
            ++returnTotal;
            if (countMults) continue;
            break;
        }
        return returnTotal;
    }

    private static int subKeyDomain(boolean countMults, String cType, List<String> selectedList) {
        int returnTotal = 0;
        for (String domain : selectedList) {
            Domain dom = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, domain);
            if (dom == null || !dom.isType(cType)) continue;
            ++returnTotal;
            if (countMults) continue;
            break;
        }
        return returnTotal;
    }

    private static int subKeyWeaponProf(boolean countMults, String cType, List<String> selectedList) {
        int returnTotal = 0;
        for (String weaponprof : selectedList) {
            WeaponProf wp = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, weaponprof);
            if (wp == null) continue;
            if (wp.isType(cType)) {
                ++returnTotal;
                if (countMults) continue;
                break;
            }
            Equipment eq = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, wp.getKeyName());
            if (eq == null || !eq.isType(cType)) continue;
            ++returnTotal;
            if (countMults) continue;
            break;
        }
        return returnTotal;
    }

    private static int subKeySkill(boolean countMults, String cType, List<String> selectedList) {
        int returnTotal = 0;
        for (String skill : selectedList) {
            Skill sk = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, skill);
            if (sk == null || !sk.isType(cType)) continue;
            ++returnTotal;
            if (countMults) continue;
            break;
        }
        return returnTotal;
    }

    public static boolean hasPreReqKindOf(Prerequisite prereq, String matchKind) {
        if (prereq == null) {
            return false;
        }
        if (matchKind == prereq.getKind() || matchKind.equalsIgnoreCase(prereq.getKind())) {
            return true;
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            if (!PrerequisiteUtilities.hasPreReqKindOf(childPrereq, matchKind)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Prerequisite> getPreReqsOfKind(Prerequisite prereq, String matchKind) {
        HashSet<Prerequisite> matchingPrereqs = new HashSet<Prerequisite>();
        if (prereq == null) {
            return matchingPrereqs;
        }
        if (matchKind == prereq.getKind() || matchKind.equalsIgnoreCase(prereq.getKind())) {
            matchingPrereqs.add(prereq);
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            matchingPrereqs.addAll(PrerequisiteUtilities.getPreReqsOfKind(childPrereq, matchKind));
        }
        return matchingPrereqs;
    }

    public static boolean hasPreReqMatching(Prerequisite prereq, String matchKind, String matchKey) {
        if (prereq == null) {
            return false;
        }
        if ((matchKind == prereq.getKind() || matchKind.equalsIgnoreCase(prereq.getKind())) && (matchKey == prereq.getKey() || matchKey.equalsIgnoreCase(prereq.getKey()))) {
            return true;
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            if (!PrerequisiteUtilities.hasPreReqMatching(childPrereq, matchKind, matchKey)) continue;
            return true;
        }
        return false;
    }
}

