/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.facet.base.AbstractSubScopeFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.list.ClassSkillList;
import pcgen.core.Skill;

public class ListSkillCostFacet
extends AbstractSubScopeFacet<ClassSkillList, SkillCost, Skill>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private RaceFacet raceFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        for (CDOMReference<CDOMList<?>> ref : cdo.getModifiedLists()) {
            ArrayList<ClassSkillList> useList = new ArrayList<ClassSkillList>();
            for (CDOMList<?> list : ref.getContainedObjects()) {
                if (!(list instanceof ClassSkillList)) continue;
                useList.add((ClassSkillList)list);
            }
            if (useList.isEmpty()) continue;
            Collection mods = cdo.getListMods(ref);
            for (CDOMReference skRef : mods) {
                for (AssociatedPrereqObject apo : cdo.getListAssociations(ref, skRef)) {
                    SkillCost sc = apo.getAssociation(AssociationKey.SKILL_COST);
                    for (ClassSkillList csl : useList) {
                        for (Skill skill : skRef.getContainedObjects()) {
                            this.add(id, csl, sc, skill, cdo);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAllFromSource(dfce.getCharID(), dfce.getCDOMObject());
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
    }
}

