/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.base.Reducible;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;

public class CNAbility
extends ConcretePrereqObject
implements QualifyingObject,
Comparable<CNAbility>,
ChooseDriver,
Reducible {
    private final Category<Ability> category;
    private final Ability ability;
    private final Nature nature;

    CNAbility(Category<Ability> cat, Ability abil, Nature nat) {
        if (cat == null) {
            throw new IllegalArgumentException("Cannot build CNAbility with null Category");
        }
        if (abil == null) {
            throw new IllegalArgumentException("Cannot build CNAbility with null Ability");
        }
        if (nat == null) {
            throw new IllegalArgumentException("Cannot build CNAbility with null Nature");
        }
        if (abil.getKeyName() == null || abil.getKeyName().length() == 0) {
            throw new IllegalArgumentException("Cannot build CNAbility when Ability has no key");
        }
        Category<Ability> origCategory = abil.getCDOMCategory();
        if (origCategory == null) {
            throw new IllegalArgumentException("Cannot build CNAbility for " + abil + " when Ability has null original Category");
        }
        if (!cat.getParentCategory().equals(origCategory)) {
            throw new IllegalArgumentException("Cannot build CNAbility for " + abil + " with incompatible Category: " + cat + " is not compatible with Ability's Category: " + origCategory);
        }
        this.category = cat;
        this.ability = abil;
        this.nature = nat;
    }

    public String getAbilityKey() {
        return this.ability.getKeyName();
    }

    public Category<Ability> getAbilityCategory() {
        return this.category;
    }

    public String toString() {
        return this.ability.getDisplayName();
    }

    public Nature getNature() {
        return this.nature;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public int hashCode() {
        return this.ability.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CNAbility) {
            CNAbility other = (CNAbility)o;
            return this.category.equals(other.category) && this.ability.equals(other.ability) && this.nature.equals((Object)other.nature);
        }
        return false;
    }

    @Override
    public int compareTo(CNAbility other) {
        boolean equal = false;
        if (this == other) {
            return 0;
        }
        int compare = this.ability.compareTo(other.ability);
        if (compare != 0) {
            return compare;
        }
        compare = this.category.toString().compareTo(other.category.toString());
        if (compare != 0) {
            return compare;
        }
        compare = this.nature.compareTo(other.nature);
        return compare;
    }

    @Override
    public ChooseInformation<?> getChooseInfo() {
        return this.ability.get(ObjectKey.CHOOSE_INFO);
    }

    @Override
    public Formula getSelectFormula() {
        return this.ability.getSafe(FormulaKey.SELECT);
    }

    @Override
    public List<ChooseSelectionActor<?>> getActors() {
        return this.ability.getListFor(ListKey.NEW_CHOOSE_ACTOR);
    }

    @Override
    public String getFormulaSource() {
        return this.ability.getKeyName();
    }

    @Override
    public Formula getNumChoices() {
        return this.ability.getSafe(FormulaKey.NUMCHOICES);
    }

    @Override
    public String getDisplayName() {
        return this.ability.getDisplayName();
    }

    @Override
    public CDOMObject getCDOMObject() {
        return this.ability;
    }
}

