/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.startpack;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Kit;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<Kit>
implements CDOMPrimaryToken<Kit> {
    @Override
    public String getTokenName() {
        return "VISIBLE";
    }

    @Override
    public Class<Kit> getTokenClass() {
        return Kit.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Kit kit, String value) {
        Visibility vis;
        if (value.equals("QUALIFY")) {
            vis = Visibility.QUALIFY;
        } else if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else if (value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else {
            return new ParseResult.Fail("Can't understand Visibility: " + value, context);
        }
        kit.put(ObjectKey.VISIBILITY, vis);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Kit kit) {
        String visString;
        Visibility vis = kit.get(ObjectKey.VISIBILITY);
        if (vis == null) {
            return null;
        }
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.QUALIFY)) {
            visString = "QUALIFY";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + (Object)((Object)vis) + " is not a valid Visibility for a Kit");
            return null;
        }
        return new String[]{visString};
    }
}

