/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.EventObject;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.models.HtmlSheetSupport;
import pcgen.gui2.tabs.skill.SkillPointTableModel;
import pcgen.gui2.tabs.skill.SkillTreeViewModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.event.ListDataAdapter;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class SkillInfoTab
extends FlippingSplitPane
implements CharacterInfoTab,
TodoHandler {
    private final FilteredTreeViewTable<CharacterFacade, SkillFacade> skillTable = new FilteredTreeViewTable();
    private final JTable skillpointTable = new JTable();
    private final InfoPane infoPane = new InfoPane();
    private final TabTitle tabTitle;
    private final FilterButton<CharacterFacade, SkillFacade> cFilterButton = new FilterButton("SkillQualified");
    private final FilterButton<CharacterFacade, SkillFacade> trainedFilterButton = new FilterButton("SkillTrained");
    private final JEditorPane htmlPane;
    private final JComboBox skillFilterBox;

    public SkillInfoTab() {
        super("Skill");
        this.tabTitle = new TabTitle(Tab.SKILLS);
        this.htmlPane = new JEditorPane();
        this.skillFilterBox = new JComboBox();
        this.initComponents();
    }

    private void initComponents() {
        this.setOrientation(0);
        this.setResizeWeight(0.7);
        JSpinner spinner = new JSpinner();
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "#0.#"));
        this.skillTable.setDefaultRenderer(Float.class, new TableCellUtilities.SpinnerRenderer(spinner));
        this.skillTable.setDefaultRenderer(Integer.class, new TableCellUtilities.AlignRenderer(0));
        this.skillTable.setDefaultRenderer(String.class, new TableCellUtilities.AlignRenderer(0));
        this.skillTable.setRowHeight(26);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.cFilterButton.setText(LanguageBundle.getString("in_classString"));
        this.cFilterButton.setEnabled(false);
        filterBar.addDisplayableFilter(this.cFilterButton);
        this.trainedFilterButton.setText(LanguageBundle.getString("in_trained"));
        this.trainedFilterButton.setEnabled(false);
        filterBar.addDisplayableFilter(this.trainedFilterButton);
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.skillTable, filterBar);
        availPanel.setPreferredSize(new Dimension(650, 300));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.ipady = 0;
        constraints.weighty = 1.0;
        SkillPointTableModel.initializeTable(this.skillpointTable);
        JScrollPane tableScrollPane = new JScrollPane(this.skillpointTable);
        tablePanel.add((Component)tableScrollPane, constraints);
        this.htmlPane.setOpaque(false);
        this.htmlPane.setEditable(false);
        this.htmlPane.setFocusable(false);
        this.htmlPane.setContentType("text/html");
        this.skillFilterBox.setRenderer(new DefaultListCellRenderer());
        JScrollPane selScrollPane = new JScrollPane(this.htmlPane);
        JPanel skillPanel = new JPanel(new BorderLayout());
        skillPanel.add((Component)this.skillFilterBox, "North");
        skillPanel.add((Component)selScrollPane, "Center");
        selScrollPane.setPreferredSize(new Dimension(530, 300));
        FlippingSplitPane topPane = new FlippingSplitPane(1, true, availPanel, skillPanel, "SkillTop");
        this.setTopComponent(topPane);
        FlippingSplitPane bottomPane = new FlippingSplitPane(1, "SkillBottom");
        bottomPane.setLeftComponent(tablePanel);
        tablePanel.setPreferredSize(new Dimension(650, 100));
        bottomPane.setRightComponent(this.infoPane);
        this.infoPane.setPreferredSize(new Dimension(530, 100));
        this.setBottomComponent(bottomPane);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        DefaultListSelectionModel listModel = new DefaultListSelectionModel();
        listModel.setSelectionMode(0);
        models.put(ListSelectionModel.class, listModel);
        models.put(SkillPointTableModel.class, new SkillPointTableModel(character));
        models.put(SkillTreeViewModel.class, new SkillTreeViewModel(character, listModel));
        models.put(FilterHandler.class, new FilterHandler(character, listModel));
        models.put(InfoHandler.class, new InfoHandler(character));
        models.put(LevelSelectionHandler.class, new LevelSelectionHandler(character, listModel));
        models.put(SkillRankSpinnerEditor.class, new SkillRankSpinnerEditor(character, listModel));
        SkillSheetHandler skillSheetHandler = new SkillSheetHandler(character);
        models.put(SkillSheetHandler.class, skillSheetHandler);
        models.put(SkillFilterHandler.class, new SkillFilterHandler(character, skillSheetHandler));
        return models;
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(SkillTreeViewModel.class).uninstall();
        models.get(FilterHandler.class).uninstall();
        models.get(InfoHandler.class).uninstall();
        models.get(LevelSelectionHandler.class).uninstall();
        models.get(SkillSheetHandler.class).uninstall();
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(FilterHandler.class).install();
        models.get(SkillFilterHandler.class).install();
        this.skillpointTable.setModel(models.get(SkillPointTableModel.class));
        this.skillpointTable.setSelectionModel(models.get(ListSelectionModel.class));
        this.skillTable.setDefaultEditor(Float.class, models.get(SkillRankSpinnerEditor.class));
        models.get(SkillTreeViewModel.class).install(this.skillTable);
        models.get(InfoHandler.class).install();
        models.get(LevelSelectionHandler.class).install();
        models.get(SkillSheetHandler.class).install();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void adviseTodo(String fieldName) {
        this.skillTable.requestFocusInWindow();
    }

    private class SkillFilterHandler
    extends ListDataAdapter {
        private CharacterFacade character;
        private SkillSheetHandler skillSheetHandler;
        private ComboBoxModel model;

        public SkillFilterHandler(CharacterFacade character, SkillSheetHandler skillSheetHandler) {
            this.character = character;
            this.skillSheetHandler = skillSheetHandler;
            this.model = new DefaultComboBoxModel<SkillFilter>(new SkillFilter[]{SkillFilter.Ranks, SkillFilter.NonDefault, SkillFilter.Usable, SkillFilter.All});
            SkillFilter filter = character.getSkillFilterRef().getReference();
            this.model.setSelectedItem((Object)filter);
            this.model.addListDataListener(this);
        }

        public void install() {
            SkillInfoTab.this.skillFilterBox.setModel(this.model);
        }

        @Override
        public void listDataChanged(ListDataEvent e) {
            if (e.getIndex0() == -1 && e.getIndex1() == -1) {
                SkillFilter filter = (SkillFilter)((Object)SkillInfoTab.this.skillFilterBox.getSelectedItem());
                this.character.setSkillFilter(filter);
                this.skillSheetHandler.support.refresh();
            }
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            SkillInfoTab.this.skillTable.getSelectionModel().addListSelectionListener(this);
            SkillInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            SkillInfoTab.this.skillTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object data = SkillInfoTab.this.skillTable.getSelectedObject();
                this.text = data != null && data instanceof SkillFacade ? this.character.getInfoFactory().getHTMLInfo((SkillFacade)data) : "";
                SkillInfoTab.this.infoPane.setText(this.text);
            }
        }
    }

    private class SkillRankSpinnerModel
    extends AbstractSpinnerModel {
        private final CharacterFacade character;
        private CharacterLevelFacade level;
        private SkillFacade skill;

        public SkillRankSpinnerModel(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.character.getCharacterLevelsFacade().getSkillRanks(this.level, this.skill));
        }

        public void configureModel(SkillFacade sk, CharacterLevelFacade charLevel) {
            this.skill = sk;
            this.level = charLevel;
            this.fireStateChanged();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Float) {
                this.setValue((Float)value);
            }
        }

        public void setValue(Float value) {
            int points;
            if (value == null) {
                return;
            }
            CharacterLevelsFacade levels = this.character.getCharacterLevelsFacade();
            CharacterLevelFacade targetLevel = levels.findNextLevelForSkill(this.skill, this.level, value.floatValue());
            if (targetLevel == null) {
                return;
            }
            SkillCost cost = levels.getSkillCost(targetLevel, this.skill);
            if (value.floatValue() < 0.0f) {
                value = Float.valueOf(0.0f);
            }
            float max = levels.getMaxRanks(targetLevel, cost, levels.isClassSkillForMaxRanks(targetLevel, this.skill));
            if (value.floatValue() > max) {
                value = Float.valueOf(max);
            }
            if ((points = (int)((value.floatValue() - this.getValue().floatValue()) * (float)levels.getSkillCost(targetLevel, this.skill).getCost())) == 0) {
                return;
            }
            if (levels.investSkillPoints(targetLevel, this.skill, points)) {
                this.fireStateChanged();
                SkillInfoTab.this.skillTable.refreshModelData();
            } else {
                SkillInfoTab.this.skillTable.getCellEditor().cancelCellEditing();
            }
        }

        @Override
        public Float getNextValue() {
            float value = this.getValue().floatValue();
            if (this.level == null) {
                return null;
            }
            CharacterLevelsFacade levels = this.character.getCharacterLevelsFacade();
            CharacterLevelFacade targetLevel = levels.findNextLevelForSkill(this.skill, this.level, value);
            if (targetLevel == null) {
                return null;
            }
            SkillCost cost = levels.getSkillCost(targetLevel, this.skill);
            CharacterLevelFacade highestLevel = (CharacterLevelFacade)levels.getElementAt(levels.getSize() - 1);
            if (value == levels.getMaxRanks(highestLevel, cost, levels.isClassSkillForMaxRanks(highestLevel, this.skill))) {
                return null;
            }
            return Float.valueOf(value + 1.0f / (float)cost.getCost());
        }

        @Override
        public Float getPreviousValue() {
            float value = this.getValue().floatValue();
            if (this.level == null || value == 0.0f) {
                return null;
            }
            CharacterLevelsFacade levels = this.character.getCharacterLevelsFacade();
            SkillCost cost = levels.getSkillCost(this.level, this.skill);
            return Float.valueOf(value - 1.0f / (float)cost.getCost());
        }
    }

    private class SkillRankSpinnerEditor
    extends TableCellUtilities.SpinnerEditor {
        private final SkillRankSpinnerModel model;
        private ListSelectionModel listModel;
        private CharacterFacade character;

        public SkillRankSpinnerEditor(CharacterFacade character, ListSelectionModel listModel) {
            this(skillInfoTab.new SkillRankSpinnerModel(character));
            this.listModel = listModel;
            this.character = character;
        }

        private SkillRankSpinnerEditor(SkillRankSpinnerModel model) {
            super(model);
            this.model = model;
            JSpinner.DefaultEditor editor = new JSpinner.DefaultEditor(this.spinner);
            NumberFormatter formatter = new NumberFormatter(new DecimalFormat("#0.#"));
            formatter.setValueClass(Float.class);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            JFormattedTextField ftf = editor.getTextField();
            ftf.setEditable(true);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            this.spinner.setEditor(editor);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            SkillFacade skill = (SkillFacade)table.getModel().getValueAt(row, 0);
            int index = this.listModel.getMinSelectionIndex();
            this.model.configureModel(skill, (CharacterLevelFacade)this.character.getCharacterLevelsFacade().getElementAt(index));
            return this.spinner;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return this.listModel.getMinSelectionIndex() != -1;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.releaseMouse(this.spinner);
            super.stateChanged(e);
        }

        private void releaseMouse(JSpinner jSpinner) {
            for (int i = 0; i < jSpinner.getComponentCount(); ++i) {
                Component comp = jSpinner.getComponent(i);
                if (!(comp instanceof JButton)) continue;
                this.releaseMouse(comp);
            }
        }

        private void releaseMouse(Component component) {
            MouseListener[] listeners = component.getMouseListeners();
            for (int i = 0; i < listeners.length; ++i) {
                MouseListener listener = listeners[i];
                listener.mouseReleased(new MouseEvent(component, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            }
        }
    }

    private class FilterHandler
    implements ListSelectionListener {
        private final Filter<CharacterFacade, SkillFacade> cFilter = new Filter<CharacterFacade, SkillFacade>(){

            @Override
            public boolean accept(CharacterFacade context, SkillFacade element) {
                CharacterLevelFacade level;
                if (context == null) {
                    return false;
                }
                CharacterLevelsFacade levels = context.getCharacterLevelsFacade();
                return levels.getSkillCost(level = (CharacterLevelFacade)levels.getElementAt(FilterHandler.this.model.getMinSelectionIndex()), element) == SkillCost.CLASS;
            }
        };
        private final Filter<CharacterFacade, SkillFacade> gainedFilter = new Filter<CharacterFacade, SkillFacade>(){

            @Override
            public boolean accept(CharacterFacade context, SkillFacade element) {
                if (context == null) {
                    return false;
                }
                CharacterLevelsFacade levels = context.getCharacterLevelsFacade();
                return levels.getSkillRanks(null, element) > 0.0f;
            }
        };
        private final ListSelectionModel model;
        private final CharacterFacade character;
        private boolean installed = false;

        public FilterHandler(CharacterFacade character, ListSelectionModel model) {
            this.character = character;
            this.model = model;
            model.addListSelectionListener(this);
        }

        public void install() {
            this.installed = true;
            SkillInfoTab.this.cFilterButton.setFilter(this.cFilter);
            SkillInfoTab.this.trainedFilterButton.setFilter(this.gainedFilter);
            SkillInfoTab.this.skillTable.setContext(this.character);
        }

        public void uninstall() {
            this.installed = false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.installed && !e.getValueIsAdjusting()) {
                SkillInfoTab.this.cFilterButton.setEnabled(this.model.getMinSelectionIndex() != -1);
                SkillInfoTab.this.trainedFilterButton.setEnabled(this.model.getMinSelectionIndex() != -1);
            }
        }
    }

    private class LevelSelectionHandler
    implements ListListener<CharacterLevelFacade>,
    CharacterLevelsFacade.SkillPointListener,
    Runnable,
    ListSelectionListener {
        private final CharacterLevelsFacade levels;
        private final ListSelectionModel model;

        public LevelSelectionHandler(CharacterFacade character, ListSelectionModel model) {
            this.levels = character.getCharacterLevelsFacade();
            this.model = model;
        }

        public void install() {
            this.levels.addSkillPointListener(this);
            this.levels.addListListener(this);
            this.model.addListSelectionListener(this);
            this.updateSelectedIndex(false);
        }

        public void uninstall() {
            this.levels.removeSkillPointListener(this);
            this.levels.removeListListener(this);
            this.model.removeListSelectionListener(this);
        }

        @Override
        public void run() {
            int[] arr$ = new int[]{this.model.getMinSelectionIndex(), 0};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int startIndex;
                for (int i = startIndex = arr$[i$]; i < this.levels.getSize(); ++i) {
                    CharacterLevelFacade level = (CharacterLevelFacade)this.levels.getElementAt(i);
                    if (this.levels.getSpentSkillPoints(level) >= this.levels.getGainedSkillPoints(level)) continue;
                    if (i != this.model.getMinSelectionIndex()) {
                        this.model.setSelectionInterval(i, i);
                        SkillInfoTab.this.skillpointTable.scrollRectToVisible(SkillInfoTab.this.skillpointTable.getCellRect(i, 0, true));
                    }
                    return;
                }
            }
            if (this.levels.getSize() > 0) {
                this.model.setSelectionInterval(this.levels.getSize() - 1, this.levels.getSize() - 1);
                SkillInfoTab.this.skillpointTable.scrollRectToVisible(SkillInfoTab.this.skillpointTable.getCellRect(this.levels.getSize() - 1, 0, true));
            }
        }

        private void updateSelectedIndex(boolean forceChange) {
            int index;
            CharacterLevelFacade level;
            if (this.levels.isEmpty()) {
                return;
            }
            if (!this.model.isSelectionEmpty() && !forceChange && this.levels.getSpentSkillPoints(level = (CharacterLevelFacade)this.levels.getElementAt(index = this.model.getMinSelectionIndex())) < this.levels.getGainedSkillPoints(level)) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void skillPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
            int firstRow = e.getBaseLevelIndex();
            boolean force = firstRow < this.model.getMinSelectionIndex();
            this.updateSelectedIndex(force);
        }

        @Override
        public void elementAdded(ListEvent<CharacterLevelFacade> e) {
            this.updateSelectedIndex(false);
        }

        @Override
        public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
            this.updateSelectedIndex(false);
        }

        @Override
        public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
            this.updateSelectedIndex(false);
        }

        @Override
        public void elementModified(ListEvent<CharacterLevelFacade> e) {
            this.updateSelectedIndex(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SkillInfoTab.this.skillTable.refreshModelData();
        }
    }

    private class SkillSheetHandler
    implements CharacterLevelsFacade.SkillBonusListener {
        private final HtmlSheetSupport support;

        public SkillSheetHandler(CharacterFacade character) {
            String sheet = character.getDataSet().getGameMode().getInfoSheetSkill();
            this.support = new HtmlSheetSupport(character, SkillInfoTab.this.htmlPane, sheet);
            character.getCharacterLevelsFacade().addSkillBonusListener(this);
        }

        public void install() {
            this.support.install();
        }

        public void uninstall() {
            this.support.uninstall();
        }

        @Override
        public void skillBonusChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
            this.support.refresh();
        }
    }
}

