/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.DomainFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterHandler;
import pcgen.gui2.filter.FilteredListFacadeTableModel;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.tools.PrefTableColumnModel;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.JDynamicTable;
import pcgen.gui2.util.table.DynamicTableColumnModel;
import pcgen.gui2.util.table.TableUtils;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class DomainInfoTab
extends FlippingSplitPane
implements CharacterInfoTab,
TodoHandler {
    private final FilteredTreeViewTable<Object, DeityFacade> deityTable = new FilteredTreeViewTable();
    private final JDynamicTable domainTable = new JDynamicTable();
    private final JTable domainRowHeaderTable = TableUtils.createDefaultTable();
    private final JLabel selectedDeity = new JLabel();
    private final JButton selectDeity = new JButton();
    private final JLabel selectedDomain = new JLabel();
    private final InfoPane deityInfo = new InfoPane("in_deityInfo");
    private final InfoPane domainInfo = new InfoPane("in_domainInfo");
    private DisplayableFilter<CharacterFacade, DomainFacade> domainFilter;
    private static final Object COLUMN_ID = new Object();
    private final FilterButton<Object, DeityFacade> qDeityButton = new FilterButton("DeityQualified");
    private final FilterButton<Object, DomainFacade> qDomainButton = new FilterButton("DomainQualified");
    private final QualifiedTreeCellRenderer qualifiedRenderer = new QualifiedTreeCellRenderer();

    public DomainInfoTab() {
        super("Domain");
        this.initComponents();
    }

    private void initComponents() {
        this.setOrientation(0);
        this.deityTable.setTreeCellRenderer(this.qualifiedRenderer);
        JPanel panel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        this.qDeityButton.setText(LanguageBundle.getString("in_igQualFilter"));
        bar.addDisplayableFilter(this.qDeityButton);
        this.deityTable.setDisplayableFilter(bar);
        panel.add(bar, "North");
        ListSelectionModel selectionModel = this.deityTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        panel.add((Component)new JScrollPane(this.deityTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(LanguageBundle.getString("in_domDeityLabel")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.selectedDeity);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.selectDeity);
        box.add(Box.createHorizontalGlue());
        panel.add((Component)box, "South");
        FlippingSplitPane splitPane = new FlippingSplitPane("DomainTop");
        splitPane.setLeftComponent(panel);
        panel = new JPanel(new BorderLayout());
        FilterBar<CharacterFacade, DomainFacade> dbar = new FilterBar<CharacterFacade, DomainFacade>();
        dbar.addDisplayableFilter(new SearchFilterPanel());
        this.qDomainButton.setText(LanguageBundle.getString("in_igQualFilter"));
        dbar.addDisplayableFilter(this.qDomainButton);
        this.domainFilter = dbar;
        panel.add(dbar, "North");
        selectionModel = this.domainTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        this.domainTable.setAutoCreateColumnsFromModel(false);
        this.domainTable.setColumnModel(this.createDomainColumnModel());
        JScrollPane scrollPane = TableUtils.createCheckBoxSelectionPane(this.domainTable, this.domainRowHeaderTable);
        panel.add((Component)scrollPane, "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(LanguageBundle.getString("in_domRemainDomLabel")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.selectedDomain);
        box.add(Box.createHorizontalGlue());
        panel.add((Component)box, "South");
        splitPane.setRightComponent(panel);
        this.setTopComponent(splitPane);
        splitPane = new FlippingSplitPane("DomainBottom");
        splitPane.setLeftComponent(this.deityInfo);
        splitPane.setRightComponent(this.domainInfo);
        this.setBottomComponent(splitPane);
        this.setResizeWeight(0.65);
    }

    public DynamicTableColumnModel createDomainColumnModel() {
        PrefTableColumnModel model = new PrefTableColumnModel("DomainList", 1);
        TableColumn column = new TableColumn(0);
        column.setHeaderValue(LanguageBundle.getString("in_domains"));
        model.addColumn(column, true, 150);
        column = new TableColumn(1);
        column.setHeaderValue(LanguageBundle.getString("in_descrip"));
        model.addColumn(column, false, 150);
        column = new TableColumn(2);
        column.setHeaderValue(LanguageBundle.getString("in_source"));
        model.addColumn(column, true, 150);
        return model;
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(DeityTreeViewModel.class, new DeityTreeViewModel(character));
        models.put(DomainTableHandler.class, new DomainTableHandler(character));
        models.put(SelectDeityAction.class, new SelectDeityAction(character));
        models.put(DeityLabelHandler.class, new DeityLabelHandler(character, this.selectedDeity));
        models.put(DomainLabelHandler.class, new DomainLabelHandler(character, this.selectedDomain));
        models.put(DeityInfoHandler.class, new DeityInfoHandler(character));
        models.put(DomainInfoHandler.class, new DomainInfoHandler(character));
        models.put(DomainRenderer.class, new DomainRenderer(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.qualifiedRenderer.createHandler(character));
        models.put(QualifiedFilterHandler.class, new QualifiedFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(DomainLabelHandler.class).install();
        models.get(DeityLabelHandler.class).install();
        models.get(QualifiedFilterHandler.class).install();
        models.get(DomainTableHandler.class).install();
        models.get(DomainInfoHandler.class).install();
        models.get(DeityInfoHandler.class).install();
        models.get(DomainRenderer.class).install();
        models.get(SelectDeityAction.class).install();
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        this.deityTable.setTreeViewModel(models.get(DeityTreeViewModel.class));
        this.selectDeity.setAction(models.get(SelectDeityAction.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(DomainLabelHandler.class).uninstall();
        models.get(DeityLabelHandler.class).uninstall();
        models.get(DomainTableHandler.class).uninstall();
        models.get(DomainInfoHandler.class).uninstall();
        models.get(DeityInfoHandler.class).uninstall();
        models.get(SelectDeityAction.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return new TabTitle(Tab.DOMAINS);
    }

    @Override
    public void adviseTodo(String fieldName) {
        if ("Domains".equals(fieldName)) {
            if (this.domainTable.getRowCount() > 0) {
                this.domainTable.requestFocusInWindow();
                this.domainTable.getSelectionModel().setSelectionInterval(0, 0);
                this.deityTable.getSelectionModel().clearSelection();
            } else if (this.deityTable.getRowCount() > 0) {
                this.deityTable.requestFocusInWindow();
                this.deityTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    private static enum DeityTreeView implements TreeView<DeityFacade>
    {
        NAME("in_deity"),
        ALIGNMENT_NAME("in_alignmentDeity"),
        DOMAIN_NAME("in_domainDeity"),
        PANTHEON_NAME("in_pantheonDeity"),
        SOURCE_NAME("in_sourceDeity");

        private String name;

        private DeityTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<DeityFacade>> getPaths(DeityFacade pobj) {
            ArrayList<TreeViewPath<DeityFacade>> paths = new ArrayList<TreeViewPath<DeityFacade>>();
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<DeityFacade>(pobj));
                }
                case DOMAIN_NAME: {
                    for (String domain : pobj.getDomainNames()) {
                        paths.add(new TreeViewPath<DeityFacade>(pobj, (Object)domain));
                    }
                    return paths;
                }
                case ALIGNMENT_NAME: {
                    return Collections.singletonList(new TreeViewPath<DeityFacade>(pobj, (Object)pobj.getAlignment()));
                }
                case PANTHEON_NAME: {
                    for (String pantheon : pobj.getPantheons()) {
                        paths.add(new TreeViewPath<DeityFacade>(pobj, (Object)pantheon));
                    }
                    return paths;
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<DeityFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }
    }

    private static class DeityTreeViewModel
    implements TreeViewModel<DeityFacade>,
    DataView<DeityFacade> {
        private static final ListFacade<TreeView<DeityFacade>> views = new DefaultListFacade<DeityTreeView>(Arrays.asList(DeityTreeView.values()));
        private final List<DefaultDataViewColumn> columns = Arrays.asList(new DefaultDataViewColumn("in_alignLabel", Object.class), new DefaultDataViewColumn("in_domains", String.class), new DefaultDataViewColumn("in_descrip", String.class), new DefaultDataViewColumn("in_pantheon", String.class), new DefaultDataViewColumn("in_favoredWeapon", String.class), new DefaultDataViewColumn("in_sourceLabel", String.class));
        private final CharacterFacade character;
        private InfoFactory infoFactory;

        public DeityTreeViewModel(CharacterFacade character) {
            this.character = character;
            this.infoFactory = character.getInfoFactory();
        }

        @Override
        public ListFacade<? extends TreeView<DeityFacade>> getTreeViews() {
            return views;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<DeityFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<DeityFacade> getDataModel() {
            return this.character.getDataSet().getDeities();
        }

        @Override
        public List<?> getData(DeityFacade obj) {
            return Arrays.asList(obj.getAlignment(), this.infoFactory.getDomains(obj), this.infoFactory.getDescription(obj), this.infoFactory.getPantheons(obj), this.infoFactory.getFavoredWeapons(obj), obj.getSource());
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public String getPrefsKey() {
            return "DeityTree";
        }
    }

    private static class DomainTableModel
    extends FilteredListFacadeTableModel<DomainFacade> {
        private final ListListener<DomainFacade> listListener = new ListListener<DomainFacade>(){

            @Override
            public void elementAdded(ListEvent<DomainFacade> e) {
                this.elementsChanged(e);
            }

            @Override
            public void elementRemoved(ListEvent<DomainFacade> e) {
                this.elementsChanged(e);
            }

            @Override
            public void elementsChanged(ListEvent<DomainFacade> e) {
                DomainTableModel.this.fireTableRowsUpdated(0, DomainTableModel.this.sortedList.getSize() - 1);
            }

            @Override
            public void elementModified(ListEvent<DomainFacade> e) {
            }
        };

        public DomainTableModel(CharacterFacade character) {
            super(character);
            this.setDelegate(character.getAvailableDomains());
            character.getDomains().addListListener(this.listListener);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == -1) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        protected Object getValueAt(DomainFacade element, int column) {
            switch (column) {
                case -1: {
                    return this.character.getDomains().containsElement(element);
                }
                case 0: {
                    return element;
                }
                case 1: {
                    return this.character.getInfoFactory().getDescription(element);
                }
                case 2: {
                    return element.getSource();
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex >= 0) {
                return false;
            }
            if (this.character.getRemainingDomainSelectionsRef().getReference() > 0) {
                return true;
            }
            DomainFacade domain = (DomainFacade)this.sortedList.getElementAt(rowIndex);
            return this.character.getDomains().containsElement(domain);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DomainFacade domain = (DomainFacade)this.sortedList.getElementAt(rowIndex);
            Boolean bool = (Boolean)aValue;
            if (bool.booleanValue()) {
                this.character.addDomain(domain);
            } else {
                this.character.removeDomain(domain);
            }
        }
    }

    private static class DeityLabelHandler
    implements ReferenceListener<DeityFacade> {
        private JLabel label;
        private ReferenceFacade<DeityFacade> ref;

        public DeityLabelHandler(CharacterFacade character, JLabel label) {
            this.ref = character.getDeityRef();
            this.label = label;
        }

        public void install() {
            this.label.setFont(FontManipulation.plain(this.label.getFont()));
            if (this.ref.getReference() != null) {
                this.label.setText(this.ref.getReference().toString());
                if (this.ref.getReference().isNamePI()) {
                    this.label.setFont(FontManipulation.bold_italic(this.label.getFont()));
                }
            } else {
                this.label.setText("");
            }
            this.ref.addReferenceListener(this);
        }

        public void uninstall() {
            this.ref.removeReferenceListener(this);
        }

        @Override
        public void referenceChanged(ReferenceEvent<DeityFacade> e) {
            this.label.setText(e.getNewReference().toString());
        }
    }

    private static class DomainLabelHandler
    implements ReferenceListener<Integer> {
        private JLabel label;
        private ReferenceFacade<Integer> ref;

        public DomainLabelHandler(CharacterFacade character, JLabel label) {
            this.ref = character.getRemainingDomainSelectionsRef();
            this.label = label;
        }

        public void install() {
            if (this.ref.getReference() != null) {
                this.label.setText(this.ref.getReference().toString());
            }
            this.ref.addReferenceListener(this);
        }

        public void uninstall() {
            this.ref.removeReferenceListener(this);
        }

        @Override
        public void referenceChanged(ReferenceEvent<Integer> e) {
            this.label.setText(e.getNewReference().toString());
        }
    }

    private class DomainTableHandler
    implements FilterHandler {
        private DomainTableModel tableModel;

        public DomainTableHandler(CharacterFacade character) {
            this.tableModel = new DomainTableModel(character);
        }

        public void install() {
            DomainInfoTab.this.domainFilter.setFilterHandler(this);
            this.tableModel.setFilter(DomainInfoTab.this.domainFilter);
            DomainInfoTab.this.domainTable.setModel(this.tableModel);
            DomainInfoTab.this.domainRowHeaderTable.setModel(this.tableModel);
        }

        public void uninstall() {
            this.tableModel.setFilter(null);
        }

        @Override
        public void refilter() {
            this.tableModel.refilter();
        }

        @Override
        public void scrollToTop() {
        }

        @Override
        public void setSearchEnabled(boolean enable) {
        }
    }

    private class QualifiedFilterHandler {
        private final Filter<Object, DomainFacade> domainFilter = new Filter<Object, DomainFacade>(){

            @Override
            public boolean accept(Object context, DomainFacade element) {
                return QualifiedFilterHandler.this.character.isQualifiedFor(element);
            }
        };
        private final Filter<Object, DeityFacade> deityFilter = new Filter<Object, DeityFacade>(){

            @Override
            public boolean accept(Object context, DeityFacade element) {
                return QualifiedFilterHandler.this.character.isQualifiedFor(element);
            }
        };
        private final CharacterFacade character;

        public QualifiedFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            DomainInfoTab.this.qDomainButton.setFilter(this.domainFilter);
            DomainInfoTab.this.qDeityButton.setFilter(this.deityFilter);
        }
    }

    private class SelectDeityAction
    extends AbstractAction {
        private CharacterFacade character;

        public SelectDeityAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_select"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object rowObj;
            int selectedRow = DomainInfoTab.this.deityTable.getSelectedRow();
            if (selectedRow != -1 && (rowObj = DomainInfoTab.this.deityTable.getModel().getValueAt(selectedRow, 0)) instanceof DeityFacade) {
                DeityFacade deity = (DeityFacade)rowObj;
                this.character.setDeity(deity);
            }
        }

        public void install() {
            DomainInfoTab.this.deityTable.addActionListener(this);
        }

        public void uninstall() {
            DomainInfoTab.this.deityTable.removeActionListener(this);
        }
    }

    private class DomainInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public DomainInfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            DomainInfoTab.this.domainTable.getSelectionModel().addListSelectionListener(this);
            DomainInfoTab.this.domainInfo.setText(this.text);
        }

        public void uninstall() {
            DomainInfoTab.this.domainTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DomainInfoTab.this.domainRowHeaderTable.isEditing()) {
                    DomainInfoTab.this.domainRowHeaderTable.getCellEditor().cancelCellEditing();
                }
                int selectedRow = DomainInfoTab.this.domainTable.getSelectedRow();
                DomainFacade domain = null;
                if (selectedRow != -1) {
                    domain = (DomainFacade)DomainInfoTab.this.domainTable.getModel().getValueAt(selectedRow, 0);
                }
                if (domain != null) {
                    this.text = this.character.getInfoFactory().getHTMLInfo(domain);
                    DomainInfoTab.this.domainInfo.setText(this.text);
                }
            }
        }
    }

    private class DeityInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public DeityInfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            DomainInfoTab.this.deityTable.getSelectionModel().addListSelectionListener(this);
            DomainInfoTab.this.deityInfo.setText(this.text);
        }

        public void uninstall() {
            DomainInfoTab.this.deityTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object obj;
            int selectedRow;
            if (!e.getValueIsAdjusting() && (selectedRow = DomainInfoTab.this.deityTable.getSelectedRow()) != -1 && (obj = DomainInfoTab.this.deityTable.getModel().getValueAt(selectedRow, 0)) instanceof DeityFacade) {
                this.text = this.character.getInfoFactory().getHTMLInfo((DeityFacade)obj);
                DomainInfoTab.this.deityInfo.setText(this.text);
            }
        }
    }

    private class DomainRenderer
    extends DefaultTableCellRenderer {
        private CharacterFacade character;

        public DomainRenderer(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            DomainInfoTab.this.domainTable.setDefaultRenderer(Object.class, this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DomainFacade && !this.character.isQualifiedFor((DomainFacade)value)) {
                this.setForeground(UIPropertyContext.getNotQualifiedColor());
            } else if (!isSelected) {
                this.setForeground(UIPropertyContext.getQualifiedColor());
            }
            if (value instanceof InfoFacade && ((InfoFacade)value).isNamePI()) {
                this.setFont(FontManipulation.bold_italic(this.getFont()));
            } else {
                this.setFont(FontManipulation.plain(this.getFont()));
            }
            return this;
        }
    }
}

