/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.plaf.LookAndFeelManager;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;

public class LookAndFeelPanel
extends PCGenPrefsPanel {
    private static String in_lookAndFeel = LanguageBundle.getString("in_Prefs_lookAndFeel");
    private static String in_skinnedLAF = LanguageBundle.getString("in_Prefs_skinnedLAF");
    private static String in_choose = "...";
    private JRadioButton[] laf;
    private JRadioButton skinnedLookFeel = new JRadioButton();
    private JButton themepack;
    private JTextField themepackLabel;
    private Dialog parent;
    private PrefsButtonListener prefsButtonHandler = new PrefsButtonListener();
    private String oldLAF;
    private String oldThemePack;

    public LookAndFeelPanel(Dialog parent) {
        this.parent = parent;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_lookAndFeel);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        ButtonGroup exclusiveGroup = new ButtonGroup();
        Action[] actions = LookAndFeelManager.getActions();
        this.laf = new JRadioButton[actions.length - 1];
        for (int i = 0; i < this.laf.length; ++i) {
            this.laf[i] = new JRadioButton(actions[i]);
            if (this.laf[i].getText().charAt(0) != 'C') {
                this.laf[i].setMnemonic(this.laf[i].getText().charAt(0));
            } else {
                this.laf[i].setMnemonic(this.laf[i].getText().charAt(1));
            }
            Utility.buildConstraints(c, 0, i, 3, 1, 0.0, 0.0);
            gridbag.setConstraints(this.laf[i], c);
            this.add(this.laf[i]);
            exclusiveGroup.add(this.laf[i]);
        }
        this.skinnedLookFeel.addActionListener(actions[actions.length - 1]);
        this.skinnedLookFeel.setText(in_skinnedLAF + ": ");
        this.skinnedLookFeel.setToolTipText(LanguageBundle.getString("in_Prefs_skinnedLAFTooltip"));
        this.skinnedLookFeel.setMnemonic(LanguageBundle.getMnemonic("in_mn_Prefs_skinnedLAF"));
        Utility.buildConstraints(c, 0, this.laf.length, 3, 1, 0.0, 0.0);
        gridbag.setConstraints(this.skinnedLookFeel, c);
        this.add(this.skinnedLookFeel);
        exclusiveGroup.add(this.skinnedLookFeel);
        Utility.buildConstraints(c, 3, this.laf.length, 1, 1, 1.0, 0.0);
        this.themepackLabel = new JTextField(LookAndFeelManager.getCurrentThemePack());
        this.themepackLabel.setEditable(false);
        gridbag.setConstraints(this.themepackLabel, c);
        this.add(this.themepackLabel);
        Utility.buildConstraints(c, 4, this.laf.length, 1, 1, 0.0, 0.0);
        this.themepack = new JButton(in_choose);
        this.themepack.setToolTipText(LanguageBundle.getString("in_Prefs_chooseSkinTooltip"));
        gridbag.setConstraints(this.themepack, c);
        this.add(this.themepack);
        this.themepack.addActionListener(this.prefsButtonHandler);
        Utility.buildConstraints(c, 0, this.laf.length + 1, 5, 1, 0.0, 0.0);
        JLabel label = new JLabel("");
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, this.laf.length + 2, 5, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_restartInfo"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, 20, 5, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    private void selectThemePack() {
        JFileChooser fc = new JFileChooser(ConfigurationSettings.getThemePackDir());
        fc.setDialogTitle(LanguageBundle.getString("in_Prefs_chooseSkinDialogTitle"));
        String theme = LookAndFeelManager.getCurrentThemePack();
        if (StringUtils.isNotEmpty(theme)) {
            fc.setCurrentDirectory(new File(LookAndFeelManager.getCurrentThemePack()));
            fc.setSelectedFile(new File(LookAndFeelManager.getCurrentThemePack()));
        }
        fc.addChoosableFileFilter(new ThemePackFilter());
        if (fc.showOpenDialog(this.getParent().getParent()) == 0) {
            File newTheme = fc.getSelectedFile();
            if (newTheme.isDirectory() || !newTheme.getName().endsWith("themepack.zip")) {
                ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_notAThemeErrorItem"), "PCGen", MessageType.ERROR);
            } else {
                LookAndFeelManager.setSelectedThemePack(newTheme.getAbsolutePath());
            }
        }
    }

    @Override
    public String getTitle() {
        return in_lookAndFeel;
    }

    @Override
    public void setOptionsBasedOnControls() {
    }

    @Override
    public void resetOptionValues() {
        LookAndFeelManager.setSelectedThemePack(this.oldThemePack);
        LookAndFeelManager.setLookAndFeel(this.oldLAF);
    }

    @Override
    public boolean needsRestart() {
        boolean needsRestart = false;
        needsRestart |= this.oldLAF != LookAndFeelManager.getCurrentLAF();
        return needsRestart |= this.oldThemePack != LookAndFeelManager.getCurrentThemePack();
    }

    @Override
    public void applyOptionValuesToControls() {
        this.oldLAF = LookAndFeelManager.getCurrentLAF();
        this.oldThemePack = LookAndFeelManager.getCurrentThemePack();
        for (int i = 0; i < this.laf.length; ++i) {
            this.laf[i].setSelected(this.oldLAF.equals(this.laf[i].getText()));
        }
        this.skinnedLookFeel.setSelected(this.oldLAF.equals("Skinned"));
    }

    private final class PrefsButtonListener
    implements ActionListener {
        private PrefsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton source = (JButton)actionEvent.getSource();
            if (source != null && source == LookAndFeelPanel.this.themepack) {
                LookAndFeelPanel.this.selectThemePack();
                LookAndFeelPanel.this.themepackLabel.setText(LookAndFeelManager.getCurrentThemePack());
            }
        }
    }

    static final class ThemePackFilter
    extends FileFilter {
        ThemePackFilter() {
        }

        @Override
        public String getDescription() {
            return "Themepacks (*themepack.zip)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith("themepack.zip");
        }
    }
}

