/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterHandler;

public class FilterButtonGroupPanel<C, E>
extends JPanel
implements DisplayableFilter<C, E>,
ItemListener {
    private List<FilterButton<C, E>> buttons = new ArrayList<FilterButton<C, E>>();
    private FilterHandler filterHandler;

    public FilterButtonGroupPanel() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public void addFilterButton(FilterButton<C, E> button) {
        this.add(button);
        this.buttons.add(button);
        button.addItemListener(this);
        button.setFilterHandler(this.filterHandler);
    }

    public void removeFilterButton(FilterButton<C, E> button) {
        this.remove(button);
        this.buttons.remove(button);
        button.removeItemListener(this);
        button.setFilterHandler(null);
    }

    @Override
    public Component getFilterComponent() {
        return this;
    }

    @Override
    public void setFilterHandler(FilterHandler handler) {
        this.filterHandler = handler;
        for (FilterButton<C, E> filterButton : this.buttons) {
            filterButton.setFilterHandler(handler);
        }
    }

    @Override
    public boolean accept(C context, E element) {
        for (FilterButton<C, E> filterButton : this.buttons) {
            if (filterButton.accept(context, element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            for (FilterButton<C, E> filterButton : this.buttons) {
                if (filterButton == e.getItemSelectable()) continue;
                filterButton.setSelected(false);
            }
        }
    }
}

