/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.UIResource;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.TipOfTheDayHandler;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.system.LanguageBundle;

public class InfoGuidePane
extends JComponent
implements UIResource {
    private final PCGenFrame frame;
    private final JEditorPane gameModeLabel;
    private final JEditorPane campaignList;
    private final JEditorPane tipPane;
    private JPanel mainPanel;

    public InfoGuidePane(PCGenFrame frame) {
        this.frame = frame;
        this.gameModeLabel = InfoGuidePane.createHtmlPane();
        this.campaignList = InfoGuidePane.createHtmlPane();
        this.tipPane = InfoGuidePane.createHtmlPane();
        TipOfTheDayHandler.getInstance().loadTips();
        this.initComponents();
        this.initListeners();
    }

    private static JEditorPane createHtmlPane() {
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.setOpaque(false);
        htmlPane.setContentType("text/html");
        htmlPane.setEditable(false);
        htmlPane.setFocusable(true);
        return htmlPane;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "", 2, 0, null));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setPreferredSize(new Dimension(650, 450));
        this.setOpaque(false);
        JPanel sourcesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = 13;
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridwidth = 0;
        gbc2.fill = 1;
        sourcesPanel.add((Component)new JLabel(LanguageBundle.getString("in_si_intro")), gbc2);
        sourcesPanel.add((Component)new JLabel(LanguageBundle.getString("in_si_gamemode")), gbc1);
        sourcesPanel.add((Component)this.gameModeLabel, gbc2);
        sourcesPanel.add((Component)new JLabel(LanguageBundle.getString("in_si_sources")), gbc1);
        sourcesPanel.add((Component)this.campaignList, gbc2);
        JEditorPane guidePane = InfoGuidePane.createHtmlPane();
        guidePane.setText(LanguageBundle.getFormattedString("in_si_whatnext", Icons.New16.getImageIcon(), Icons.Open16.getImageIcon()));
        this.mainPanel.add(sourcesPanel);
        this.mainPanel.add(guidePane);
        this.mainPanel.add(this.tipPane);
        this.refreshDisplayedSources(null);
        JPanel outerPanel = new JPanel(new FlowLayout());
        outerPanel.add(this.mainPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)outerPanel, "Center");
        this.tipPane.setText(LanguageBundle.getFormattedString("in_si_tip", TipOfTheDayHandler.getInstance().getNextTip()));
    }

    private void initListeners() {
        this.frame.getSelectedCharacterRef().addReferenceListener(new ReferenceListener<CharacterFacade>(){

            @Override
            public void referenceChanged(ReferenceEvent<CharacterFacade> e) {
                boolean show;
                boolean bl = show = e.getNewReference() == null;
                if (show) {
                    InfoGuidePane.this.tipPane.setText(LanguageBundle.getFormattedString("in_si_tip", TipOfTheDayHandler.getInstance().getNextTip()));
                }
                InfoGuidePane.this.setVisible(show);
            }
        });
        this.frame.getCurrentSourceSelectionRef().addReferenceListener(new ReferenceListener<SourceSelectionFacade>(){

            @Override
            public void referenceChanged(ReferenceEvent<SourceSelectionFacade> e) {
                InfoGuidePane.this.refreshDisplayedSources(e.getNewReference());
            }
        });
    }

    private void refreshDisplayedSources(SourceSelectionFacade sources) {
        if (sources == null) {
            this.gameModeLabel.setText("<html>none selected</html>");
        } else {
            this.gameModeLabel.setText(sources.getGameMode().getReference().getDisplayName());
        }
        if (sources == null || sources.getCampaigns().isEmpty()) {
            this.campaignList.setText(LanguageBundle.getString("in_si_nosources"));
        } else {
            HtmlInfoBuilder builder = new HtmlInfoBuilder();
            for (CampaignFacade campaign : sources.getCampaigns()) {
                builder.append(campaign.getName()).appendLineBreak();
            }
            this.campaignList.setText(builder.toString());
        }
    }
}

