/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.character.CharacterSpell;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSpellBookEntry;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;

public final class KitSpells
extends BaseKit {
    private String spellBook;
    private CDOMSingleRef<PCClass> castingClass;
    DoubleKeyMap<KnownSpellIdentifier, List<CDOMSingleRef<Ability>>, Integer> spells = new DoubleKeyMap();
    private Formula countFormula;
    private transient List<KitSpellBookEntry> theSpells = null;

    public void setCount(Formula formula) {
        this.countFormula = formula;
    }

    public Formula getCount() {
        return this.countFormula;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.castingClass != null) {
            sb.append(this.castingClass.getLSTformat(false));
        }
        sb.append(' ').append(this.spellBook).append(": ");
        boolean needComma = false;
        for (KnownSpellIdentifier ksi : this.spells.getKeySet()) {
            if (needComma) {
                sb.append(',');
            }
            needComma = true;
            sb.append(ksi.getLSTformat());
            Set abilities = this.spells.getSecondaryKeySet((Object)ksi);
            for (List list : abilities) {
                Integer count;
                if (list != null) {
                    sb.append(" [");
                    sb.append(ReferenceUtilities.joinLstFormat(list, ","));
                    sb.append(']');
                }
                if ((count = (Integer)this.spells.get((Object)ksi, (Object)list)) <= 1) continue;
                sb.append(" (").append(count).append(")");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        List xs;
        this.theSpells = null;
        PCClass aClass = this.findDefaultSpellClass(this.castingClass, aPC);
        if (aClass == null) {
            warnings.add("SPELLS: Character does not have " + this.castingClass + " spellcasting class.");
            return false;
        }
        String workingBook = this.spellBook == null ? Globals.getDefaultSpellBook() : this.spellBook;
        ArrayList<KitSpellBookEntry> aSpellList = new ArrayList<KitSpellBookEntry>();
        if (!aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !workingBook.equals(Globals.getDefaultSpellBook())) {
            warnings.add("SPELLS: " + aClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook());
            return false;
        }
        for (KnownSpellIdentifier ksi : this.spells.getKeySet()) {
            Collection<Spell> allSpells = ksi.getContainedSpells(aPC, Collections.singletonList(aClass.get(ObjectKey.CLASS_SPELLLIST)));
            Set feats = this.spells.getSecondaryKeySet((Object)ksi);
            for (Spell sp : allSpells) {
                for (List list : feats) {
                    Integer count = (Integer)this.spells.get((Object)ksi, (Object)list);
                    aSpellList.add(new KitSpellBookEntry(this.spellBook, sp, list, count));
                }
            }
        }
        Formula choiceFormula = this.getCount();
        int numberOfChoices = choiceFormula == null ? aSpellList.size() : choiceFormula.resolve(aPC, "").intValue();
        if (numberOfChoices > aSpellList.size()) {
            numberOfChoices = aSpellList.size();
        }
        if (numberOfChoices == 0) {
            return false;
        }
        if (numberOfChoices == aSpellList.size()) {
            xs = aSpellList;
        } else {
            while ((xs = Globals.getChoiceFromList("Choose " + aClass.getKeyName() + " spell(s) for " + workingBook, aSpellList, new ArrayList(), numberOfChoices, aPC)).size() == 0) {
            }
        }
        for (KitSpellBookEntry obj : xs) {
            if (obj != null) {
                obj.setPCClass(aClass);
                if (this.theSpells == null) {
                    this.theSpells = new ArrayList<KitSpellBookEntry>();
                }
                this.theSpells.add(obj);
                continue;
            }
            warnings.add("SPELLS: Non-existant spell chosen");
        }
        return this.theSpells != null && this.theSpells.size() > 0;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        for (KitSpellBookEntry sbe : this.theSpells) {
            this.updatePCSpells(aPC, sbe, aPC.getClassKeyed(sbe.getPCClass().getKeyName()));
        }
    }

    private PCClass findDefaultSpellClass(CDOMSingleRef<PCClass> ref, PlayerCharacter aPC) {
        if (this.castingClass == null) {
            List<? extends PObject> spellcastingClasses = aPC.getSpellClassList();
            for (PObject pObject : spellcastingClasses) {
                if (!(pObject instanceof PCClass)) continue;
                return (PCClass)pObject;
            }
            return null;
        }
        return aPC.getClassKeyed(ref.resolvesTo().getKeyName());
    }

    private void updatePCSpells(PlayerCharacter pc, KitSpellBookEntry aSpell, PCClass pcClass) {
        Spell spell = aSpell.getSpell();
        int spLevel = 99;
        PObject owner = null;
        if (pc.hasDomains()) {
            for (Domain domain : pc.getDomainSet()) {
                List<? extends CDOMList<Spell>> lists = pc.getSpellLists(domain);
                int newLevel = SpellLevel.getFirstLevelForKey(spell, lists, pc);
                if (newLevel <= 0 || newLevel >= spLevel) continue;
                spLevel = newLevel;
                owner = domain;
            }
        }
        if (spLevel == 99) {
            spLevel = SpellLevel.getFirstLevelForKey(spell, pc.getSpellLists(pcClass), pc);
            owner = pcClass;
        }
        if (spLevel < 0) {
            Logging.errorPrint("SPELLS: " + pcClass.getDisplayName() + " cannot cast spell \"" + spell.getKeyName() + "\"");
            return;
        }
        CharacterSpell cs = new CharacterSpell(owner, spell);
        List<CDOMSingleRef<Ability>> modifierList = aSpell.getModifiers();
        int adjustedLevel = spLevel;
        ArrayList<Ability> metamagicFeatList = new ArrayList<Ability>();
        for (CDOMSingleRef<Ability> feat : modifierList) {
            Ability anAbility = feat.resolvesTo();
            adjustedLevel += anAbility.getSafe(IntegerKey.ADD_SPELL_LEVEL);
            metamagicFeatList.add(anAbility);
        }
        if (metamagicFeatList.size() <= 0) {
            metamagicFeatList = null;
        }
        if (!pc.hasSpellBook(aSpell.getBookName())) {
            pc.addSpellBook(aSpell.getBookName());
        }
        for (int numTimes = 0; numTimes < aSpell.getCopies(); ++numTimes) {
            String aString = pc.addSpell(cs, metamagicFeatList, pcClass.getKeyName(), aSpell.getBookName(), adjustedLevel, spLevel);
            if (aString.length() == 0) continue;
            Logging.errorPrint("Add spell failed:" + aString);
            return;
        }
    }

    @Override
    public String getObjectName() {
        return "Spells";
    }

    public void setSpellBook(String string) {
        this.spellBook = string;
    }

    public String getSpellBook() {
        return this.spellBook;
    }

    public void setCastingClass(CDOMSingleRef<PCClass> reference) {
        this.castingClass = reference;
    }

    public CDOMSingleRef<PCClass> getCastingClass() {
        return this.castingClass;
    }

    public void addSpell(KnownSpellIdentifier ksi, ArrayList<CDOMSingleRef<Ability>> featList, int count) {
        this.spells.put((Object)ksi, featList, (Object)count);
    }

    public Collection<KnownSpellIdentifier> getSpells() {
        return this.spells.getKeySet();
    }

    public Collection<List<CDOMSingleRef<Ability>>> getAbilities(KnownSpellIdentifier ksi) {
        return this.spells.getSecondaryKeySet((Object)ksi);
    }

    public Integer getSpellCount(KnownSpellIdentifier ksi, List<CDOMSingleRef<Ability>> abils) {
        return (Integer)this.spells.get((Object)ksi, abils);
    }
}

