/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.helper.ArmorProfProvider;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.helper.ShieldProfProvider;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.DomainList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.ClassType;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.Vision;
import pcgen.core.analysis.AddObjectActions;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.ExchangeLevelApplication;
import pcgen.core.analysis.SizeUtilities;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.StatApplication;
import pcgen.core.analysis.SubClassApplication;
import pcgen.core.analysis.SubstitutionClassApplication;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.ClassFacade;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.util.Logging;
import pcgen.util.enumeration.AttackType;

public class PCClass
extends PObject
implements ClassFacade {
    public static final CDOMReference<DomainList> ALLOWED_DOMAINS;
    private String classKey = null;
    private SortedMap<Integer, PCClassLevel> levelMap = new TreeMap<Integer, PCClassLevel>();

    @Override
    public final String getAbbrev() {
        FactKey fk = FactKey.valueOf("Abb");
        String abb = (String)this.getResolved(fk);
        if (abb == null) {
            String name = this.getDisplayName();
            abb = name.substring(0, Math.min(3, name.length()));
        }
        return abb;
    }

    @Override
    public String getQualifiedKey() {
        if (this.classKey == null) {
            this.classKey = "CLASS:" + this.getKeyName();
        }
        return this.classKey;
    }

    public double getBonusTo(String argType, String argMname, int asLevel, PlayerCharacter aPC) {
        double i = 0.0;
        List<BonusObj> rawBonusList = this.getRawBonusList(aPC);
        for (int lvl = 1; lvl < asLevel; ++lvl) {
            rawBonusList.addAll(aPC.getActiveClassLevel(this, lvl).getRawBonusList(aPC));
        }
        if (asLevel == 0 || rawBonusList.isEmpty()) {
            return 0.0;
        }
        String type = argType.toUpperCase();
        String mname = argMname.toUpperCase();
        for (BonusObj bonus : rawBonusList) {
            StringTokenizer breakOnPipes = new StringTokenizer(bonus.toString().toUpperCase(), "|", false);
            String theType = breakOnPipes.nextToken();
            if (!theType.equals(type)) continue;
            String str = breakOnPipes.nextToken();
            StringTokenizer breakOnCommas = new StringTokenizer(str, ",", false);
            while (breakOnCommas.hasMoreTokens()) {
                String theName = breakOnCommas.nextToken();
                if (!theName.equals(mname)) continue;
                String aString = breakOnPipes.nextToken();
                ArrayList<Prerequisite> localPreReqList = new ArrayList<Prerequisite>();
                if (bonus.hasPrerequisites()) {
                    localPreReqList.addAll(bonus.getPrerequisiteList());
                }
                while (breakOnPipes.hasMoreTokens()) {
                    String bString = breakOnPipes.nextToken();
                    if (!PreParserFactory.isPreReqString(bString)) continue;
                    Logging.debugPrint("Why is this prerequisite '" + bString + "' parsed in '" + this.getClass().getName() + ".getBonusTo(String,String,int)' rather than in the persistence layer?");
                    try {
                        PreParserFactory factory = PreParserFactory.getInstance();
                        localPreReqList.add(factory.parse(bString));
                    }
                    catch (PersistenceLayerException ple) {
                        Logging.errorPrint(ple.getMessage(), ple);
                    }
                }
                if (!PrereqHandler.passesAll(localPreReqList, aPC, null)) continue;
                double j = aPC.getVariableValue(aString, this.getQualifiedKey()).doubleValue();
                i += j;
            }
        }
        return i;
    }

    public final boolean hasMaxLevel() {
        Integer ll = this.get(IntegerKey.LEVEL_LIMIT);
        return ll != null && ll != -1;
    }

    public final int getSkillPool(PlayerCharacter aPC) {
        int returnValue = 0;
        for (PCLevelInfo pcl : aPC.getLevelInfo()) {
            if (!pcl.getClassKeyName().equals(this.getKeyName())) continue;
            returnValue += pcl.getSkillPointsRemaining();
        }
        return returnValue;
    }

    public final String getSpellBaseStat() {
        Boolean useStat = this.get(ObjectKey.USE_SPELL_SPELL_STAT);
        if (useStat == null) {
            return "None";
        }
        if (useStat.booleanValue()) {
            return "SPELL";
        }
        Boolean otherCaster = this.get(ObjectKey.CASTER_WITHOUT_SPELL_STAT);
        if (otherCaster.booleanValue()) {
            return "OTHER";
        }
        CDOMSingleRef<PCStat> ss = this.get(ObjectKey.SPELL_STAT);
        return ss.resolvesTo().getKeyName();
    }

    @Override
    public final String getSpellType() {
        FactKey fk = FactKey.valueOf("SpellType");
        String castInfo = (String)this.getResolved(fk);
        return StringUtils.isEmpty(castInfo) ? "None" : castInfo;
    }

    public final SubClass getSubClassKeyed(String aKey) {
        List<SubClass> subClassList = this.getListFor(ListKey.SUB_CLASS);
        if (subClassList == null) {
            return null;
        }
        for (SubClass subClass : subClassList) {
            if (!subClass.getKeyName().equals(aKey)) continue;
            return subClass;
        }
        return null;
    }

    public final SubstitutionClass getSubstitutionClassKeyed(String aKey) {
        List<SubstitutionClass> substitutionClassList = this.getListFor(ListKey.SUBSTITUTION_CLASS);
        if (substitutionClassList == null) {
            return null;
        }
        for (SubstitutionClass sc : substitutionClassList) {
            if (!sc.getKeyName().equals(aKey)) continue;
            return sc;
        }
        return null;
    }

    public void setLevel(int newLevel, PlayerCharacter aPC) {
        int curLevel = aPC.getLevel(this);
        if (newLevel >= 0) {
            aPC.setLevelWithoutConsequence(this, newLevel);
        }
        if (newLevel == 1 && (newLevel > curLevel || aPC.isImporting())) {
            this.addFeatPoolBonus(aPC);
        }
        if (!aPC.isImporting()) {
            aPC.calcActiveBonuses();
        }
        if (newLevel == 1 && !aPC.isImporting() && curLevel == 0) {
            SubClassApplication.checkForSubClass(aPC, this);
            aPC.setSpellLists(this);
        }
        if (!aPC.isImporting() && curLevel < newLevel) {
            SubstitutionClassApplication.checkForSubstitutionClass(this, newLevel, aPC);
        }
        for (PCClass pcClass : aPC.getClassSet()) {
            aPC.calculateKnownSpellsForClassLevel(this);
        }
        if (curLevel > newLevel) {
            aPC.resetEpicCache();
        }
    }

    void addFeatPoolBonus(PlayerCharacter aPC) {
        Integer mLevPerFeat = this.get(IntegerKey.LEVELS_PER_FEAT);
        if (mLevPerFeat == null) {
            String aString = Globals.getBonusFeatString();
            StringTokenizer aTok = new StringTokenizer(aString, "|", false);
            int startLevel = Integer.parseInt(aTok.nextToken());
            int rangeLevel = Integer.parseInt(aTok.nextToken());
            int divisor = rangeLevel;
            if (divisor > 0) {
                StringBuilder aBuf = new StringBuilder("FEAT|PCPOOL|").append("max(CL");
                if (this == aPC.getClassKeyed(aPC.getLevelInfoClassKeyName(0))) {
                    aBuf.append("-").append(startLevel);
                    aBuf.append("+").append(rangeLevel);
                }
                aBuf.append(",0)/").append(divisor);
                BonusObj bon = Bonus.newBonus(Globals.getContext(), aBuf.toString());
                aPC.addBonus(bon, this);
            }
        }
    }

    public boolean isMonster() {
        Boolean mon = this.get(ObjectKey.IS_MONSTER);
        if (mon != null) {
            return mon;
        }
        ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(this.getClassType());
        if (aClassType != null && aClassType.isMonster()) {
            return true;
        }
        for (Type type : this.getTrueTypeList(false)) {
            aClassType = SettingsHandler.getGame().getClassTypeByName(type.toString());
            if (aClassType == null || !aClassType.isMonster()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPCCText() {
        StringBuilder pccTxt = new StringBuilder(200);
        pccTxt.append("CLASS:").append(this.getDisplayName());
        pccTxt.append("\t");
        pccTxt.append(PrerequisiteWriter.prereqsToString(this));
        pccTxt.append("\t");
        pccTxt.append((CharSequence)StringUtil.joinToStringBuilder(Globals.getContext().unparse(this), (String)"\t"));
        String lineSep = System.getProperty("line.separator");
        for (Map.Entry<Integer, PCClassLevel> me : this.levelMap.entrySet()) {
            pccTxt.append(lineSep).append(me.getKey()).append('\t');
            pccTxt.append(PrerequisiteWriter.prereqsToString(me.getValue()));
            pccTxt.append("\t");
            pccTxt.append((CharSequence)StringUtil.joinToStringBuilder(Globals.getContext().unparse(me.getValue()), (String)"\t"));
        }
        return pccTxt.toString();
    }

    public final void addSubClass(SubClass sClass) {
        sClass.put(ObjectKey.LEVEL_HITDIE, this.get(ObjectKey.LEVEL_HITDIE));
        this.addToListFor(ListKey.SUB_CLASS, sClass);
    }

    public final void addSubstitutionClass(SubstitutionClass sClass) {
        sClass.put(ObjectKey.LEVEL_HITDIE, this.get(ObjectKey.LEVEL_HITDIE));
        this.addToListFor(ListKey.SUBSTITUTION_CLASS, sClass);
    }

    public int attackCycle(AttackType at) {
        for (Map.Entry<AttackType, Integer> me : this.getMapFor(MapKey.ATTACK_CYCLE).entrySet()) {
            if (!at.equals((Object)me.getKey())) continue;
            return me.getValue();
        }
        return SettingsHandler.getGame().getBabAttCyc();
    }

    public int baseAttackBonus(PlayerCharacter aPC) {
        if (aPC.getLevel(this) == 0) {
            return 0;
        }
        int i = (int)this.getBonusTo("COMBAT", "BAB", aPC.getLevel(this), aPC);
        return i += (int)this.getBonusTo("COMBAT", "BASEAB", aPC.getLevel(this), aPC);
    }

    public PCStat baseSpellStat() {
        if (this.getSafe(ObjectKey.USE_SPELL_SPELL_STAT).booleanValue()) {
            return null;
        }
        if (this.getSafe(ObjectKey.CASTER_WITHOUT_SPELL_STAT).booleanValue()) {
            return null;
        }
        CDOMSingleRef<PCStat> ss = this.get(ObjectKey.SPELL_STAT);
        if (ss != null) {
            return ss.resolvesTo();
        }
        if (Logging.isDebugMode()) {
            Logging.debugPrint("Found Class: " + this.getDisplayName() + " that did not have any SPELLSTAT defined");
        }
        return null;
    }

    public PCStat bonusSpellStat() {
        CDOMSingleRef<PCStat> bssref;
        Boolean hbss = this.get(ObjectKey.HAS_BONUS_SPELL_STAT);
        if (hbss == null) {
            return this.baseSpellStat();
        }
        if (hbss.booleanValue() && (bssref = this.get(ObjectKey.BONUS_SPELL_STAT)) != null) {
            return bssref.resolvesTo();
        }
        return null;
    }

    @Override
    public PCClass clone() {
        PCClass aClass = null;
        try {
            Map<AttackType, Integer> acmap;
            aClass = (PCClass)super.clone();
            List<KnownSpellIdentifier> ksl = this.getListFor(ListKey.KNOWN_SPELLS);
            if (ksl != null) {
                aClass.removeListFor(ListKey.KNOWN_SPELLS);
                for (KnownSpellIdentifier ksi : ksl) {
                    aClass.addToListFor(ListKey.KNOWN_SPELLS, ksi);
                }
            }
            if ((acmap = this.getMapFor(MapKey.ATTACK_CYCLE)) != null && !acmap.isEmpty()) {
                aClass.removeMapFor(MapKey.ATTACK_CYCLE);
                for (Map.Entry<Object, Object> entry : acmap.entrySet()) {
                    aClass.addToMapFor(MapKey.ATTACK_CYCLE, entry.getKey(), entry.getValue());
                }
            }
            aClass.levelMap = new TreeMap<Integer, PCClassLevel>();
            for (Map.Entry<Object, Object> entry : this.levelMap.entrySet()) {
                aClass.levelMap.put((Integer)entry.getKey(), ((PCClassLevel)entry.getValue()).clone());
            }
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aClass;
    }

    public boolean hasXPPenalty() {
        for (Type type : this.getTrueTypeList(false)) {
            ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(type.toString());
            if (aClassType == null || aClassType.getXPPenalty()) continue;
            return false;
        }
        return true;
    }

    public String getUdamForLevel(int aLevel, PlayerCharacter aPC, boolean adjustForPCSize) {
        return this.getUDamForEffLevel(aLevel += (int)aPC.getTotalBonusTo("UDAM", "CLASS." + this.getKeyName()), aPC, adjustForPCSize);
    }

    String getUDamForEffLevel(int aLevel, PlayerCharacter aPC, boolean adjustForPCSize) {
        int pcSize = adjustForPCSize ? aPC.sizeInt() : aPC.getDisplay().racialSizeInt();
        AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
        Equipment eq = ref.silentlyGetConstructedCDOMObject(Equipment.class, "KEY_Unarmed Strike");
        String aDamage = eq != null ? eq.getDamage(aPC) : "1d3";
        if (adjustForPCSize) {
            int defSize = SizeUtilities.getDefaultSizeAdjustment().get(IntegerKey.SIZEORDER);
            aDamage = Globals.adjustDamage(aDamage, defSize, pcSize);
        }
        ArrayList<CDOMObject> classObjects = new ArrayList<CDOMObject>();
        for (int i = aLevel; i >= 1; --i) {
            classObjects.add(aPC.getActiveClassLevel(this, i));
        }
        classObjects.add(this);
        for (CDOMObject cdo : classObjects) {
            List<String> udam = cdo.getListFor(ListKey.UNARMED_DAMAGE);
            if (udam == null) continue;
            if (udam.size() == 1) {
                aDamage = udam.get(0);
                break;
            }
            aDamage = udam.get(pcSize);
            break;
        }
        return aDamage;
    }

    public boolean addLevel(boolean argLevelMax, boolean bSilent, PlayerCharacter aPC, boolean ignorePrereqs) {
        Integer currentPool;
        PCLevelInfo pcl;
        int newLevel = aPC.getLevel(this) + 1;
        boolean levelMax = argLevelMax;
        aPC.setAllowInteraction(false);
        aPC.setLevelWithoutConsequence(this, newLevel);
        if (!ignorePrereqs) {
            boolean doReturn = false;
            if (!this.qualifies(aPC, this)) {
                doReturn = true;
                if (!bSilent) {
                    ShowMessageDelegate.showMessageDialog("This character does not qualify for level " + newLevel, "PCGen", MessageType.ERROR);
                }
            }
            aPC.setLevelWithoutConsequence(this, newLevel - 1);
            if (doReturn) {
                return false;
            }
        }
        aPC.setAllowInteraction(true);
        if (this.isMonster()) {
            levelMax = false;
        }
        if (this.hasMaxLevel() && newLevel > this.getSafe(IntegerKey.LEVEL_LIMIT) && levelMax) {
            if (!bSilent) {
                ShowMessageDelegate.showMessageDialog("This class cannot be raised above level " + Integer.toString(this.getSafe(IntegerKey.LEVEL_LIMIT)), "PCGen", MessageType.ERROR);
            }
            return false;
        }
        int total = aPC.getTotalLevels();
        this.setLevel(newLevel, aPC);
        PCClassLevel classLevel = aPC.getActiveClassLevel(this, newLevel);
        int dnum = aPC.getMaxCharacterDomains(this, aPC) - aPC.getDomainCount();
        if (dnum > 0 && !aPC.hasDefaultDomainSource()) {
            aPC.setDefaultDomainSource(new ClassSource(this, newLevel));
        }
        if (Globals.getUseGUI()) {
            int levels = SettingsHandler.isHPMaxAtFirstClassLevel() ? aPC.totalNonMonsterLevels() : aPC.getTotalLevels();
            boolean isFirst = levels == 1;
            aPC.rollHP(this, aPC.getLevel(this), isFirst);
        }
        if (!aPC.isImporting()) {
            DomainApplication.addDomainsUpToLevel(this, newLevel, aPC);
        }
        int levelUpStats = 0;
        if (aPC.getTotalLevels() > total) {
            int bonusStats;
            boolean processBonusStats = true;
            total = aPC.getTotalLevels();
            if (this.isMonster()) {
                LevelCommandFactory lcf = aPC.getRace().get(ObjectKey.MONSTER_CLASS);
                int monLevels = 0;
                if (lcf != null) {
                    monLevels = lcf.getLevelCount().resolve(aPC, "").intValue();
                }
                if (total <= monLevels) {
                    processBonusStats = false;
                }
            }
            if (!aPC.isImporting() && processBonusStats && (bonusStats = Globals.getBonusStatsForLevel(total, aPC)) > 0) {
                aPC.setPoolAmount(aPC.getPoolAmount() + bonusStats);
                if (!bSilent && SettingsHandler.getShowStatDialogAtLevelUp()) {
                    levelUpStats = StatApplication.askForStatIncrease(aPC, bonusStats, true);
                }
            }
        }
        int spMod = this.getSkillPointsForLevel(aPC, classLevel, total);
        if (aPC.getLevelInfoSize() > 0 && (pcl = aPC.getLevelInfo(aPC.getLevelInfoSize() - 1)) != null) {
            pcl.setClassLevel(aPC.getLevel(this));
            pcl.setSkillPointsGained(aPC, spMod);
            pcl.setSkillPointsRemaining(pcl.getSkillPointsGained(aPC));
        }
        int newSkillPool = spMod + ((currentPool = aPC.getSkillPool(this)) == null ? 0 : currentPool);
        aPC.setSkillPool(this, newSkillPool);
        if (!aPC.isImporting()) {
            if (levelUpStats > 0) {
                StatApplication.askForStatIncrease(aPC, levelUpStats, false);
            }
            if (newLevel == 1) {
                AddObjectActions.doBaseChecks(this, aPC);
                CDOMObjectUtilities.addAdds(this, aPC);
                CDOMObjectUtilities.checkRemovals(this, aPC);
            }
            for (TransitionChoice<Kit> kit : classLevel.getSafeListFor(ListKey.KIT_CHOICE)) {
                kit.act(kit.driveChoice(aPC), classLevel, aPC);
            }
            TransitionChoice<Region> region = classLevel.get(ObjectKey.REGION_CHOICE);
            if (region != null) {
                region.act(region.driveChoice(aPC), classLevel, aPC);
            }
        }
        if (this.isMonster()) {
            return true;
        }
        if (!aPC.isImporting()) {
            CDOMObjectUtilities.checkRemovals(this, aPC);
            int minxp = aPC.minXPForECL();
            if (aPC.getXP() < minxp) {
                aPC.setXP(minxp);
            } else if (aPC.getXP() >= aPC.minXPForNextECL() && !bSilent) {
                ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
            }
        }
        if (this.containsKey(ObjectKey.EXCHANGE_LEVEL) && aPC.getLevel(this) == 1 && !aPC.isImporting()) {
            ExchangeLevelApplication.exchangeLevels(aPC, this);
        }
        return true;
    }

    public int getSkillPointsForLevel(PlayerCharacter aPC, PCClassLevel classLevel, int characterLevel) {
        int spMod = aPC.recalcSkillPointMod(this, characterLevel);
        if (classLevel.get(ObjectKey.DONTADD_SKILLPOINTS) != null) {
            spMod = 0;
        }
        return spMod;
    }

    void doMinusLevelMods(PlayerCharacter aPC, int oldLevel) {
        PCClassLevel pcl = aPC.getActiveClassLevel(this, oldLevel);
        CDOMObjectUtilities.removeAdds(pcl, aPC);
        CDOMObjectUtilities.restoreRemovals(pcl, aPC);
    }

    void subLevel(PlayerCharacter aPC) {
        if (aPC != null) {
            Integer currentPool;
            int total = aPC.getTotalLevels();
            int oldLevel = aPC.getLevel(this);
            int spMod = 0;
            PCLevelInfo pcl = aPC.getLevelInfoFor(this.getKeyName(), oldLevel);
            if (pcl != null) {
                spMod = pcl.getSkillPointsGained(aPC);
            } else {
                Logging.errorPrint("ERROR: could not find class/level info for " + this.getDisplayName() + "/" + oldLevel);
            }
            int newLevel = oldLevel - 1;
            if (oldLevel > 0) {
                PCClassLevel classLevel = aPC.getActiveClassLevel(this, oldLevel - 1);
                aPC.removeHP(classLevel);
            }
            this.setLevel(newLevel, aPC);
            aPC.removeKnownSpellsForClassLevel(this);
            this.doMinusLevelMods(aPC, newLevel + 1);
            DomainApplication.removeDomainsForLevel(this, newLevel + 1, aPC);
            if (newLevel == 0) {
                SubClassApplication.setSubClassKey(aPC, this, "None");
                for (Skill skill : aPC.getSkillSet()) {
                    SkillRankControl.setZeroRanks(this, aPC, skill);
                }
                currentPool = aPC.getSkillPool(this);
                int n = spMod = currentPool == null ? 0 : currentPool;
            }
            if (!this.isMonster() && total > aPC.getTotalLevels()) {
                total = aPC.getTotalLevels();
                ArrayList<PCLevelInfoStat> moddedStats = new ArrayList<PCLevelInfoStat>();
                if (pcl.getModifiedStats(true) != null) {
                    moddedStats.addAll(pcl.getModifiedStats(true));
                }
                if (pcl.getModifiedStats(false) != null) {
                    moddedStats.addAll(pcl.getModifiedStats(false));
                }
                if (!moddedStats.isEmpty()) {
                    block1: for (PCLevelInfoStat statToRollback : moddedStats) {
                        for (PCStat aStat : aPC.getStatSet()) {
                            if (!aStat.equals(statToRollback.getStat())) continue;
                            aPC.setStat(aStat, aPC.getStat(aStat) - statToRollback.getStatMod());
                            continue block1;
                        }
                    }
                }
            }
            aPC.setLevelWithoutConsequence(this, newLevel);
            if (this.isMonster() || total != 0) {
                currentPool = aPC.getSkillPool(this);
                int newSkillPool = (currentPool == null ? 0 : currentPool) - spMod;
                aPC.setSkillPool(this, newSkillPool);
                aPC.setDirty(true);
            }
            if (aPC.getLevel(this) == 0) {
                aPC.removeClass(this);
            }
            aPC.validateCharacterDomains();
            if (!aPC.isImporting()) {
                int maxxp = aPC.minXPForNextECL();
                if (aPC.getXP() >= maxxp) {
                    aPC.setXP(Math.max(maxxp - 1, 0));
                }
            }
        } else {
            Logging.errorPrint("No current pc in subLevel()? How did this happen?");
            return;
        }
    }

    public void inheritAttributesFrom(PCClass otherClass) {
        List<BonusObj> bonusList;
        List<ShieldProfProvider> sp;
        List<ArmorProfProvider> ap;
        QualifiedObject<Boolean> otherWP;
        List<WeaponProfProvider> wp;
        List<QualifiedObject<CDOMReference<Equipment>>> e;
        TransitionChoice<CDOMListObject<Spell>> slc;
        CDOMSingleRef<PCStat> ss;
        Boolean cwss;
        Boolean usbs;
        Boolean hbss = otherClass.get(ObjectKey.HAS_BONUS_SPELL_STAT);
        if (hbss != null) {
            this.put(ObjectKey.HAS_BONUS_SPELL_STAT, hbss);
            CDOMSingleRef<PCStat> bss = otherClass.get(ObjectKey.BONUS_SPELL_STAT);
            if (bss != null) {
                this.put(ObjectKey.BONUS_SPELL_STAT, bss);
            }
        }
        if ((usbs = otherClass.get(ObjectKey.USE_SPELL_SPELL_STAT)) != null) {
            this.put(ObjectKey.USE_SPELL_SPELL_STAT, usbs);
        }
        if ((cwss = otherClass.get(ObjectKey.CASTER_WITHOUT_SPELL_STAT)) != null) {
            this.put(ObjectKey.CASTER_WITHOUT_SPELL_STAT, cwss);
        }
        if ((ss = otherClass.get(ObjectKey.SPELL_STAT)) != null) {
            this.put(ObjectKey.SPELL_STAT, ss);
        }
        if ((slc = otherClass.get(ObjectKey.SPELLLIST_CHOICE)) != null) {
            this.put(ObjectKey.SPELLLIST_CHOICE, slc);
        }
        if ((e = otherClass.getListFor(ListKey.EQUIPMENT)) != null) {
            this.addAllToListFor(ListKey.EQUIPMENT, e);
        }
        if ((wp = otherClass.getListFor(ListKey.WEAPONPROF)) != null) {
            this.addAllToListFor(ListKey.WEAPONPROF, wp);
        }
        if ((otherWP = otherClass.get(ObjectKey.HAS_DEITY_WEAPONPROF)) != null) {
            this.put(ObjectKey.HAS_DEITY_WEAPONPROF, otherWP);
        }
        if ((ap = otherClass.getListFor(ListKey.AUTO_ARMORPROF)) != null) {
            this.addAllToListFor(ListKey.AUTO_ARMORPROF, ap);
        }
        if ((sp = otherClass.getListFor(ListKey.AUTO_SHIELDPROF)) != null) {
            this.addAllToListFor(ListKey.AUTO_SHIELDPROF, sp);
        }
        if ((bonusList = otherClass.getListFor(ListKey.BONUS)) != null) {
            this.addAllToListFor(ListKey.BONUS, bonusList);
        }
        try {
            this.ownBonuses(this);
        }
        catch (CloneNotSupportedException ce) {
            ce.printStackTrace();
        }
        for (VariableKey variableKey : otherClass.getVariableKeys()) {
            this.put(variableKey, otherClass.get(variableKey));
        }
        if (otherClass.containsListFor(ListKey.CSKILL)) {
            this.removeListFor(ListKey.CSKILL);
            this.addAllToListFor(ListKey.CSKILL, otherClass.getListFor(ListKey.CSKILL));
        }
        if (otherClass.containsListFor(ListKey.LOCALCCSKILL)) {
            this.removeListFor(ListKey.LOCALCCSKILL);
            this.addAllToListFor(ListKey.LOCALCCSKILL, otherClass.getListFor(ListKey.LOCALCCSKILL));
        }
        this.removeListFor(ListKey.KIT_CHOICE);
        this.addAllToListFor(ListKey.KIT_CHOICE, otherClass.getSafeListFor(ListKey.KIT_CHOICE));
        this.remove(ObjectKey.REGION_CHOICE);
        if (otherClass.containsKey(ObjectKey.REGION_CHOICE)) {
            this.put(ObjectKey.REGION_CHOICE, otherClass.get(ObjectKey.REGION_CHOICE));
        }
        this.removeListFor(ListKey.SAB);
        this.addAllToListFor(ListKey.SAB, otherClass.getSafeListFor(ListKey.SAB));
        this.addAllToListFor(ListKey.DAMAGE_REDUCTION, otherClass.getListFor(ListKey.DAMAGE_REDUCTION));
        for (CDOMReference cDOMReference : otherClass.getSafeListMods(Vision.VISIONLIST)) {
            for (AssociatedPrereqObject apo : otherClass.getListAssociations(Vision.VISIONLIST, cDOMReference)) {
                this.putToList(Vision.VISIONLIST, cDOMReference, apo);
            }
        }
        if (otherClass instanceof SubClass) {
            this.levelMap.clear();
            this.copyLevelsFrom(otherClass);
        }
        this.addAllToListFor(ListKey.NATURAL_WEAPON, otherClass.getListFor(ListKey.NATURAL_WEAPON));
        this.put(ObjectKey.LEVEL_HITDIE, otherClass.get(ObjectKey.LEVEL_HITDIE));
    }

    public PCClassLevel getOriginalClassLevel(int lvl) {
        if (!this.levelMap.containsKey(lvl)) {
            PCClassLevel classLevel = new PCClassLevel();
            classLevel.put(IntegerKey.LEVEL, lvl);
            classLevel.setName(this.getDisplayName() + "(" + lvl + ")");
            classLevel.put(StringKey.QUALIFIED_KEY, this.getQualifiedKey());
            classLevel.put(ObjectKey.SOURCE_CAMPAIGN, this.get(ObjectKey.SOURCE_CAMPAIGN));
            classLevel.put(StringKey.SOURCE_PAGE, this.get(StringKey.SOURCE_PAGE));
            classLevel.put(StringKey.SOURCE_LONG, this.get(StringKey.SOURCE_LONG));
            classLevel.put(StringKey.SOURCE_SHORT, this.get(StringKey.SOURCE_SHORT));
            classLevel.put(StringKey.SOURCE_WEB, this.get(StringKey.SOURCE_WEB));
            classLevel.put(ObjectKey.SOURCE_DATE, this.get(ObjectKey.SOURCE_DATE));
            classLevel.put(ObjectKey.TOKEN_PARENT, this);
            this.levelMap.put(lvl, classLevel);
        }
        return (PCClassLevel)this.levelMap.get(lvl);
    }

    public boolean hasOriginalClassLevel(int lvl) {
        return this.levelMap.containsKey(lvl);
    }

    public Collection<PCClassLevel> getOriginalClassLevelCollection() {
        return Collections.unmodifiableCollection(this.levelMap.values());
    }

    public void copyLevelsFrom(PCClass cl) {
        for (Map.Entry<Integer, PCClassLevel> me : cl.levelMap.entrySet()) {
            try {
                PCClassLevel lvl = me.getValue().clone();
                lvl.put(StringKey.QUALIFIED_KEY, this.getQualifiedKey());
                lvl.put(ObjectKey.SOURCE_CAMPAIGN, this.get(ObjectKey.SOURCE_CAMPAIGN));
                lvl.put(StringKey.SOURCE_PAGE, this.get(StringKey.SOURCE_PAGE));
                lvl.put(StringKey.SOURCE_LONG, this.get(StringKey.SOURCE_LONG));
                lvl.put(StringKey.SOURCE_SHORT, this.get(StringKey.SOURCE_SHORT));
                lvl.put(StringKey.SOURCE_WEB, this.get(StringKey.SOURCE_WEB));
                lvl.put(ObjectKey.SOURCE_DATE, this.get(ObjectKey.SOURCE_DATE));
                lvl.put(ObjectKey.TOKEN_PARENT, this);
                lvl.setName(this.getDisplayName() + "(" + lvl.get(IntegerKey.LEVEL) + ")");
                lvl.ownBonuses(this);
                this.levelMap.put(me.getKey(), lvl);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearClassLevels() {
        this.levelMap.clear();
    }

    public String getFullKey() {
        return this.getKeyName();
    }

    @Override
    public void ownBonuses(Object owner) throws CloneNotSupportedException {
        super.ownBonuses(owner);
        for (PCClassLevel pcl : this.getOriginalClassLevelCollection()) {
            pcl.ownBonuses(owner);
        }
    }

    @Override
    public boolean qualifies(PlayerCharacter aPC, Object owner) {
        if (Globals.checkRule("CLASSPRE")) {
            return true;
        }
        return super.qualifies(aPC, owner);
    }

    @Override
    public String getBaseStat() {
        return this.getSpellBaseStat();
    }

    @Override
    public String getHD() {
        HitDie hd = this.getSafe(ObjectKey.LEVEL_HITDIE);
        return String.valueOf(hd.getDie());
    }

    @Override
    public String[] getTypes() {
        String type = this.getType();
        return type.split("\\.");
    }

    static {
        DomainList dl = new DomainList();
        dl.setName("*Allowed");
        ALLOWED_DOMAINS = CDOMDirectSingleRef.getRef(dl);
    }
}

