/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import pcgen.base.util.ListSet;
import pcgen.base.util.RandomUtil;

public class WeightedCollection<E>
extends AbstractCollection<E> {
    private Collection<WeightedItem<E>> theData;

    public WeightedCollection() {
        this.theData = new ListSet();
    }

    public WeightedCollection(int initialSize) {
        this.theData = new ListSet(initialSize);
    }

    public WeightedCollection(Collection<? extends E> collection) {
        this();
        this.addAll(collection, 1);
    }

    public WeightedCollection(Comparator<? super E> comp) {
        this.theData = comp == null ? new ListSet() : new TreeSet<WeightedItem<E>>(new WeightedItemComparator<E>(comp));
    }

    @Override
    public int size() {
        int total = 0;
        for (WeightedItem<E> item : this.theData) {
            total += item.getWeight();
        }
        return total;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(collection, 1);
    }

    public final boolean add(E element, int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("Cannot items with weight < 0");
        }
        if (weight == 0) {
            return false;
        }
        for (WeightedItem<E> item : this.theData) {
            E wiElement = item.getElement();
            if ((wiElement != null || element != null) && (wiElement == null || !wiElement.equals(element))) continue;
            item.addWeight(weight);
            return true;
        }
        return this.theData.add(new WeightedItem<E>(element, weight));
    }

    @Override
    public boolean add(E element) {
        return this.add(element, 1);
    }

    public E getRandomValue() {
        int index = RandomUtil.getRandomInt(this.size());
        int total = 0;
        for (WeightedItem<E> item : this.theData) {
            if ((total += item.getWeight()) <= index) continue;
            return item.getElement();
        }
        throw new IndexOutOfBoundsException(index + " >= " + total);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeightedIterator();
    }

    public Iterator<E> unweightedIterator() {
        return new UnweightedIterator();
    }

    @Override
    public boolean contains(Object element) {
        for (WeightedItem<E> item : this.theData) {
            E wiElement = item.getElement();
            if ((wiElement != null || element != null) && (wiElement == null || !wiElement.equals(element))) continue;
            return true;
        }
        return false;
    }

    public int getWeight(Object element) {
        for (WeightedItem<E> item : this.theData) {
            E wiElement = item.getElement();
            if ((wiElement != null || element != null) && (wiElement == null || !wiElement.equals(element))) continue;
            return ((WeightedItem)item).theWeight;
        }
        return 0;
    }

    @Override
    public boolean remove(Object element) {
        Iterator<WeightedItem<E>> it = this.theData.iterator();
        while (it.hasNext()) {
            WeightedItem<E> item = it.next();
            E wiElement = item.getElement();
            if ((wiElement != null || element != null) && (wiElement == null || !wiElement.equals(element))) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.theData.isEmpty();
    }

    @Override
    public void clear() {
        this.theData.clear();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof WeightedCollection && this.theData.equals(((WeightedCollection)obj).theData);
    }

    @Override
    public int hashCode() {
        return this.theData.hashCode();
    }

    @Override
    public String toString() {
        return "WeightedCollection: " + this.theData.toString();
    }

    public final boolean addAll(Collection<? extends E> collection, int weight) {
        boolean modified = false;
        for (E element : collection) {
            modified |= this.add(element, weight);
        }
        return modified;
    }

    private static class WeightedItemComparator<WICT>
    implements Comparator<WeightedItem<WICT>> {
        private final Comparator<? super WICT> delegate;

        public WeightedItemComparator(Comparator<? super WICT> comp) {
            this.delegate = comp;
        }

        @Override
        public int compare(WeightedItem<WICT> item1, WeightedItem<WICT> item2) {
            return this.delegate.compare(item1.getElement(), item2.getElement());
        }
    }

    private class UnweightedIterator
    implements Iterator<E> {
        private final Iterator<WeightedItem<E>> realIterator;

        private UnweightedIterator() {
            this.realIterator = WeightedCollection.this.theData.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public E next() {
            return this.realIterator.next().getElement();
        }

        @Override
        public void remove() {
            this.realIterator.remove();
        }
    }

    private class WeightedIterator
    implements Iterator<E> {
        private final Iterator<WeightedItem<E>> iter;
        private WeightedItem<E> currentEntry;
        private int currentReturned;

        private WeightedIterator() {
            this.iter = WeightedCollection.this.theData.iterator();
            this.currentReturned = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry == null) {
                if (!this.iter.hasNext()) {
                    return false;
                }
                this.currentEntry = this.iter.next();
                this.currentReturned = 0;
            }
            if (this.currentReturned < this.currentEntry.theWeight) {
                return true;
            }
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            if (this.currentEntry == null || this.currentReturned >= this.currentEntry.theWeight) {
                this.currentEntry = this.iter.next();
                this.currentReturned = 0;
            }
            ++this.currentReturned;
            return this.currentEntry.theElement;
        }

        @Override
        public void remove() {
            this.iter.remove();
            this.currentEntry = null;
        }
    }

    static class WeightedItem<T> {
        private final T theElement;
        private int theWeight;

        public WeightedItem(T element, int weight) {
            this.theElement = element;
            this.theWeight = weight;
        }

        public final T getElement() {
            return this.theElement;
        }

        public final int getWeight() {
            return this.theWeight;
        }

        public void addWeight(int weight) {
            this.theWeight += weight;
        }

        public int hashCode() {
            return this.theWeight * 29 + (this.theElement == null ? 0 : this.theElement.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeightedItem) {
                WeightedItem item = (WeightedItem)obj;
                return this.theWeight == item.theWeight && (this.theElement == null && item.theElement == null || this.theElement != null && this.theElement.equals(item.theElement));
            }
            return false;
        }

        public String toString() {
            return this.theElement + " (" + this.theWeight + ")";
        }
    }
}

