/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.State;
import gmgen.plugin.SystemAttribute;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;

public class SystemHP {
    private State state = State.Nothing;
    private SystemAttribute attribute;
    private boolean firstround;
    private int current;
    private int max;
    private int subdual;

    public SystemHP(SystemAttribute attribute, int hpmax, int current) {
        this.attribute = attribute;
        this.max = hpmax;
        this.current = current;
    }

    public SystemHP(SystemAttribute attribute, int hpmax) {
        this(attribute, hpmax, hpmax);
    }

    public SystemHP(int hpmax) {
        this(new SystemAttribute("Attribute", 10), hpmax, hpmax);
    }

    public void setAttribute(SystemAttribute attribute) {
        this.attribute = attribute;
    }

    public SystemAttribute getAttribute() {
        return this.attribute;
    }

    public void setCurrent(int current) {
        int currentHP = current;
        if (currentHP > this.max) {
            currentHP = this.max;
        }
        if (currentHP > this.current) {
            this.heal(currentHP - this.current);
        } else if (currentHP < this.current) {
            this.damage(this.current - currentHP);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public static boolean isD20ModernMassive(Combatant cbt, int damage) {
        PCStat stat;
        PcgCombatant pcgcbt;
        PlayerCharacter pc;
        return cbt instanceof PcgCombatant ? damage > (pc = (pcgcbt = (PcgCombatant)cbt).getPC()).getTotalStatFor(stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "CON")) : damage > cbt.getHP().getAttribute().getValue();
    }

    public static boolean isDndMassive(Combatant cbt, int damage) {
        int damageThreshold = 50;
        if (SettingsHandler.getGMGenOption("Initiative.Damage.Massive.SizeMod", true) && cbt instanceof PcgCombatant) {
            PcgCombatant pcgcbt = (PcgCombatant)cbt;
            PlayerCharacter pc = pcgcbt.getPC();
            String size = pc.getDisplay().getSize();
            if (size.equals("Fine")) {
                damageThreshold = 10;
            }
            if (size.equals("Diminutive")) {
                damageThreshold = 20;
            }
            if (size.equals("Tiny")) {
                damageThreshold = 30;
            }
            if (size.equals("Small")) {
                damageThreshold = 40;
            }
            if (size.equals("Large")) {
                damageThreshold = 60;
            }
            if (size.equals("Huge")) {
                damageThreshold = 70;
            }
            if (size.equals("Gargantuan")) {
                damageThreshold = 80;
            }
            if (size.equals("Colossal")) {
                damageThreshold = 90;
            }
        }
        return damage >= damageThreshold;
    }

    public static boolean isHouseHalfMassive(Combatant cbt, int damage) {
        SystemHP hp = cbt.getHP();
        return damage > hp.getMax();
    }

    public void setMax(int hpmax) {
        this.max = hpmax;
        if (this.max > this.current) {
            this.current = this.max;
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public void setSubdual(int subdual) {
        this.subdualDamage(subdual - this.getSubdual());
    }

    public int getSubdual() {
        return this.subdual;
    }

    public State bleed() {
        if (this.state == State.Bleeding && !this.firstround) {
            this.damage(1);
        }
        return this.state;
    }

    public State damage(int damage) {
        boolean dyingStart;
        if (this.current > -1 && this.current - damage < 0 && !(dyingStart = SettingsHandler.getGMGenOption("Initiative.Damage.Dying.Start", true))) {
            this.firstround = true;
        }
        this.current -= damage;
        int disabledType = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int disabledLowRange = 0;
        if (disabledType == 2) {
            disabledLowRange = -1 * Math.max(0, this.attribute.getModifier());
        }
        if (this.current <= 0 && this.current >= disabledLowRange) {
            this.state = State.Disabled;
        } else if (this.current < disabledLowRange) {
            this.state = State.Bleeding;
        }
        int deathType = SettingsHandler.getGMGenOption("Initiative.Damage.Death", 1);
        if (deathType == 1) {
            if (this.current <= -10) {
                this.state = State.Dead;
                this.current = 0;
            }
        } else if (deathType == 2 && this.current <= -1 * this.attribute.getValue()) {
            this.state = State.Dead;
            this.current = 0;
        }
        this.checkSubdual();
        return this.state;
    }

    public State endDurationedStatus() {
        if (this.state == State.Unconsious || this.state == State.Dazed) {
            this.state = State.Nothing;
        }
        return this.state;
    }

    public void endRound() {
        this.firstround = false;
    }

    public State heal(int heal) {
        if (this.state != State.Dead) {
            this.current += heal;
            this.subdual -= heal;
            if (this.current > this.max) {
                this.current = this.max;
            }
            if (this.subdual < 0) {
                this.subdual = 0;
            }
            if (this.state == State.Bleeding) {
                this.state = State.Stable;
            }
            if (this.current > 0) {
                this.state = State.Nothing;
            }
            this.checkSubdual();
        }
        return this.state;
    }

    public State kill() {
        this.state = State.Dead;
        this.current = 0;
        return this.state;
    }

    public State nonLethalDamage(boolean type) {
        if (this.state == State.Nothing) {
            this.state = type ? State.Unconsious : State.Dazed;
        }
        return this.state;
    }

    public State raise() {
        if (this.state == State.Dead) {
            this.state = State.Nothing;
            this.current = 1;
        }
        return this.state;
    }

    public State stabilize() {
        if (this.state == State.Bleeding) {
            this.state = State.Stable;
        }
        return this.state;
    }

    public State subdualDamage(int damage) {
        this.subdual += damage;
        return this.checkSubdual();
    }

    private State checkSubdual() {
        int disabledType = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int disabledBonus = 0;
        if (disabledType == 2) {
            disabledBonus = Math.max(0, this.attribute.getModifier());
        }
        if ((this.state == State.Nothing || this.state == State.Staggered || this.state == State.Unconsious) && this.subdual > 0) {
            if (this.subdual >= this.current && this.subdual <= this.current + disabledBonus) {
                this.state = State.Staggered;
            } else if (this.subdual > this.current + disabledBonus) {
                this.state = State.Unconsious;
            }
        }
        return this.state;
    }
}

