/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class LevelToken
extends Token {
    public static final String TOKENNAME = "LEVEL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int level = 1;
        if (aTok.hasMoreTokens()) {
            level = Integer.parseInt(aTok.nextToken());
        }
        if (level < 1 || level > pc.getDisplay().getLevelInfoSize()) {
            return "";
        }
        PCLevelInfo pcl = pc.getDisplay().getLevelInfo(level - 1);
        if (aTok.hasMoreTokens()) {
            String tokName = aTok.nextToken();
            if (tokName.equals("CLASSNAME")) {
                retString = pcl.getClassKeyName();
            }
            if (tokName.equals("CLASSLEVEL")) {
                retString = Integer.toString(pcl.getClassLevel());
            }
            if (tokName.equals("FEATLIST")) {
                retString = "";
            }
            if (tokName.equals("HP")) {
                retString = LevelToken.getLevelHP(pc, pcl);
            }
            if (tokName.equals("SKILLPOINTS")) {
                retString = Integer.toString(pcl.getSkillPointsGained(pc));
            }
        }
        return retString;
    }

    public static String getLevelHP(PlayerCharacter pc, PCLevelInfo pcl) {
        String classKeyName = pcl.getClassKeyName();
        PCClass aClass = pc.getClassKeyed(classKeyName);
        if (aClass == null && (aClass = (PCClass)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKeyName)) != null) {
            CDOMSingleRef exc = (CDOMSingleRef)aClass.get(ObjectKey.EX_CLASS);
            aClass = pc.getClassKeyed(((PCClass)exc.resolvesTo()).getKeyName());
        }
        if (aClass != null) {
            PCClassLevel classLevel = pc.getDisplay().getActiveClassLevel(aClass, pcl.getClassLevel() - 1);
            Integer hp = pc.getDisplay().getHP(classLevel);
            return hp == null ? "0" : hp.toString();
        }
        return "";
    }
}

