/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.Description;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.PatternChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class BenefitToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    public String getTokenName() {
        return "BENEFIT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList((CDOMObject)ability, ListKey.BENEFIT);
            return ParseResult.SUCCESS;
        }
        if (value.startsWith(".CLEAR.")) {
            context.getObjectContext().removePatternFromList((CDOMObject)ability, ListKey.BENEFIT, value.substring(7));
            return ParseResult.SUCCESS;
        }
        Description ben = this.parseBenefit(value);
        if (ben == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().addToList((CDOMObject)ability, ListKey.BENEFIT, (Object)ben);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Ability ability) {
        PatternChanges changes = context.getObjectContext().getListPatternChanges((CDOMObject)ability, ListKey.BENEFIT);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            for (String d : removedItems) {
                list.add(".CLEAR." + d);
            }
        }
        Collection added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            for (Description d : added) {
                list.add(d.getPCCText());
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Description parseBenefit(String aDesc) {
        if (this.isEmpty(aDesc) || this.hasIllegalSeparator('|', aDesc)) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(aDesc, "|");
        String firstToken = tok.nextToken();
        if (PreParserFactory.isPreReqString((String)firstToken)) {
            Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + aDesc));
            Logging.errorPrint((String)"  PRExxx can not be only value");
            return null;
        }
        String ds = EntityEncoder.decode((String)firstToken);
        if (!StringUtil.hasBalancedParens((String)ds)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " encountered imbalanced Parenthesis: " + aDesc));
            return null;
        }
        Description desc = new Description(ds);
        boolean isPre = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (PreParserFactory.isPreReqString((String)token)) {
                Prerequisite prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    Logging.errorPrint((String)(this.getTokenName() + " had invalid prerequisite : " + token));
                    return null;
                }
                desc.addPrerequisite(prereq);
                isPre = true;
                continue;
            }
            if (isPre) {
                Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + aDesc));
                Logging.errorPrint((String)"  PRExxx must be at the END of the Token");
                return null;
            }
            desc.addVariable(token);
        }
        return desc;
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

