/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;

public class CskillToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass>,
PostDeferredToken<PCClass> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "CSKILL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass obj, String value) {
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList((CDOMObject)obj, ListKey.CLASS_SKILL);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    context.getObjectContext().removeFromList((CDOMObject)obj, ListKey.CLASS_SKILL, (Object)context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
                } else {
                    CDOMReference ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)clearText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().removeFromList((CDOMObject)obj, ListKey.CLASS_SKILL, (Object)ref);
                }
            } else if ("ALL".equals(tokText)) {
                foundAny = true;
                context.getObjectContext().addToList((CDOMObject)obj, ListKey.CLASS_SKILL, (Object)context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
            } else {
                foundOther = true;
                CDOMReference<Skill> ref = this.getSkillReference(context, tokText);
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getObjectContext().addToList((CDOMObject)obj, ListKey.CLASS_SKILL, ref);
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)tokText);
    }

    public String[] unparse(LoadContext context, PCClass obj) {
        Collection added;
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)obj, ListKey.CLASS_SKILL);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)"|.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat((Collection)added, (String)"|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }

    public Class<PCClass> getDeferredTokenClass() {
        return PCClass.class;
    }

    public boolean process(LoadContext context, PCClass obj) {
        List list = obj.getListFor(ListKey.CLASS_SKILL);
        if (list != null) {
            ClassSkillList csl = (ClassSkillList)obj.get(ObjectKey.CLASS_SKILLLIST);
            CDOMDirectSingleRef listref = new CDOMDirectSingleRef((Loadable)csl);
            for (CDOMReference ref : list) {
                for (Skill sk : ref.getContainedObjects()) {
                    context.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)obj, (CDOMReference)listref, (CDOMObject)sk);
                    context.commit();
                }
            }
        }
        return true;
    }

    public int getPriority() {
        return 0;
    }
}

