/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.identifier.SpellSchool;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SchoolToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "SCHOOL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        boolean first = true;
        while (aTok.hasMoreTokens()) {
            String tokString = aTok.nextToken();
            if (".CLEAR".equals(tokString)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getObjectContext().removeList((CDOMObject)spell, ListKey.SPELL_SCHOOL);
            } else {
                if ("ALL".equals(tokString)) {
                    return new ParseResult.Fail(this.getTokenName() + "used reserved word ALL: " + value, context);
                }
                if ("ANY".equals(tokString)) {
                    return new ParseResult.Fail(this.getTokenName() + "used reserved word ANY: " + value, context);
                }
                SpellSchool ss = (SpellSchool)context.getReferenceContext().constructNowIfNecessary(SpellSchool.class, tokString);
                context.getObjectContext().addToList((CDOMObject)spell, ListKey.SPELL_SCHOOL, (Object)ss);
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)spell, ListKey.SPELL_SCHOOL);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (changes.includesGlobalClear()) {
            sb.append(".CLEAR");
        }
        if (changes.hasAddedItems()) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append((CharSequence)StringUtil.joinToStringBuilder((Collection)changes.getAdded(), (String)"|"));
        }
        return new String[]{sb.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

