/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.List;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Reducible;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.output.publish.OutputDB;
import pcgen.system.LanguageBundle;

public class PreFactSetTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter aPC, CDOMObject source) throws PrerequisiteException {
        int number;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreFactSet.error", (Object[])new Object[]{prereq.toString()}));
        }
        String location = prereq.getCategoryName();
        String[] locationElements = location.split("\\.");
        Iterable objModel = OutputDB.getIterable((CharID)aPC.getCharID(), (String[])locationElements);
        if (objModel == null) {
            throw new PrerequisiteException("Output System does not have model for: " + location);
        }
        String test = prereq.getKey();
        String[] factinfo = test.split("=");
        String factid = factinfo[0];
        String factval = factinfo[1];
        FactSetKey fk = FactSetKey.valueOf((String)factid);
        int runningTotal = this.getRunningTotal(prereq, number, objModel, factval, fk);
        return this.countedTotal(prereq, runningTotal);
    }

    private <T> int getRunningTotal(Prerequisite prereq, int number, Iterable<Reducible> objModel, String factval, FactSetKey<T> fk) {
        Object targetVal = fk.getFormatManager().convert(factval);
        int runningTotal = 0;
        block0: for (Reducible r : objModel) {
            List sets = r.getCDOMObject().getSetFor(fk);
            for (ObjectContainer container : sets) {
                if (!container.contains(targetVal)) continue;
                ++runningTotal;
                continue block0;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return runningTotal;
    }

    public String kindHandled() {
        return "FACTSET";
    }

    public String toHtmlString(Prerequisite prereq) {
        if (prereq.getOperator() == PrerequisiteOperator.GTEQ && "1".equals(prereq.getOperand())) {
            return prereq.getKey();
        }
        String foo = LanguageBundle.getFormattedString((String)"PreFactSet.toHtml", (Object[])new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey()});
        return foo;
    }
}

