/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.EquipmentModifier;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BonusToken
implements CDOMPrimaryToken<EquipmentModifier> {
    public String getTokenName() {
        return "BONUS";
    }

    public ParseResult parseToken(LoadContext context, EquipmentModifier mod, String value) {
        BonusObj bon = Bonus.newBonus((LoadContext)context, (String)value);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList((CDOMObject)mod, ListKey.BONUS, (Object)bon);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, EquipmentModifier mod) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)mod, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection added = changes.getAdded();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            String bonusString = bonus.getLSTformat();
            bonusSet.add(bonusString);
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

