/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.swtgui.JSmoothApplication;
import net.charabia.jsmoothgen.application.swtgui.JSmoothPage;
import net.charabia.jsmoothgen.application.swtgui.resources.JSmoothResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class JavaAppPage
extends JSmoothPage {
    protected SelectionListener LISTENER_USEJAR = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            JavaAppPage.this.setModelUsejar(JavaAppPage.this.usejar.getSelection());
            JavaAppPage.this.updateUsejarWidgets();
        }
    };
    private Text jar;
    private Text mainclass;
    private Text args;
    private List classpath;
    private Button usejar;
    private Button setjar;
    private Button addjar;
    private Button addfolder;
    private Button remove;

    public JavaAppPage(JSmoothApplication js) {
        super(js);
    }

    public Control createPageArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(top, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.usejar = new Button(composite, 32);
        this.usejar.setText("Use embedded JAR");
        this.usejar.addSelectionListener(this.LISTENER_USEJAR);
        GridData grid = new GridData(4);
        grid.horizontalSpan = 3;
        this.usejar.setLayoutData((Object)grid);
        Label label = new Label(composite, 0);
        label.setText("JAR location:");
        grid = new GridData(4);
        label.setLayoutData((Object)grid);
        this.jar = new Text(composite, 2048);
        grid = new GridData(768);
        grid.widthHint = 250;
        this.jar.setLayoutData((Object)grid);
        this.jar.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaAppPage.this.setModelJar(JavaAppPage.this.jar.getText());
            }
        });
        this.setjar = new Button(composite, 0);
        this.setjar.setText("Browse...");
        this.setjar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JavaAppPage.this.getShell(), 8192);
                dialog.setText("JAR Location");
                String file = dialog.open();
                if (file != null) {
                    JavaAppPage.this.jar.setText(file);
                }
                JavaAppPage.this.setModelJar(file);
            }
        });
        grid = new GridData(4);
        grid.widthHint = 100;
        this.setjar.setLayoutData((Object)grid);
        label = new Label(composite, 258);
        grid = new GridData(768);
        grid.horizontalSpan = 3;
        label.setLayoutData((Object)grid);
        label = new Label(composite, 0);
        label.setText("Main class:");
        grid = new GridData(4);
        label.setLayoutData((Object)grid);
        this.mainclass = new Text(composite, 2048);
        grid = new GridData(768);
        grid.widthHint = 250;
        this.mainclass.setLayoutData((Object)grid);
        this.mainclass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaAppPage.this.setModelMainclass(JavaAppPage.this.mainclass.getText());
            }
        });
        new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText("Arguments:");
        grid = new GridData(4);
        label.setLayoutData((Object)grid);
        this.args = new Text(composite, 2048);
        grid = new GridData(768);
        grid.widthHint = 250;
        this.args.setLayoutData((Object)grid);
        this.args.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaAppPage.this.setModelArguments(JavaAppPage.this.args.getText());
            }
        });
        new Label(composite, 0);
        Group group = new Group(top, 0);
        group.setText("Classpath");
        group.setLayout((Layout)new GridLayout());
        grid = new GridData(768);
        grid.horizontalSpan = 3;
        group.setLayoutData((Object)grid);
        group.setLayout((Layout)new GridLayout(2, false));
        this.classpath = new List((Composite)group, 2818);
        grid = new GridData(1808);
        grid.widthHint = 250;
        grid.heightHint = this.classpath.getItemHeight() * 10;
        this.classpath.setLayoutData((Object)grid);
        this.classpath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAppPage.this.updateRemoveButton();
            }
        });
        composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(1040));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        composite.setLayout((Layout)layout);
        this.addjar = new Button(composite, 0);
        this.addjar.setText("Add JAR File...");
        this.addjar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JavaAppPage.this.getShell(), 4098);
                dialog.setText("JAR File");
                String choice = dialog.open();
                if (choice != null) {
                    String path = dialog.getFilterPath();
                    String[] filenames = dialog.getFileNames();
                    ArrayList<String> files = new ArrayList<String>();
                    for (int i = 0; i < filenames.length; ++i) {
                        files.add(path + File.separator + filenames[i]);
                    }
                    JavaAppPage.this.addClasspathItems(files.toArray(new String[0]));
                }
            }
        });
        grid = new GridData(768);
        grid.widthHint = 130;
        this.addjar.setLayoutData((Object)grid);
        this.addfolder = new Button(composite, 0);
        this.addfolder.setText("Add Class Folder...");
        this.addfolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(JavaAppPage.this.getShell(), 8192);
                dialog.setText("Class Folder");
                String folder = dialog.open();
                if (folder != null) {
                    JavaAppPage.this.addClasspathItems(new String[]{folder});
                }
            }
        });
        grid = new GridData(768);
        grid.widthHint = 130;
        this.addfolder.setLayoutData((Object)grid);
        this.remove = new Button(composite, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAppPage.this.removeItem();
            }
        });
        grid = new GridData(768);
        grid.widthHint = 130;
        this.remove.setLayoutData((Object)grid);
        this.updateRemoveButton();
        this.updateUsejarWidgets();
        return top;
    }

    private void setModelMainclass(String mainclass) {
        System.out.println("[DEBUG] Setting mainclass to: " + mainclass);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setMainClassName(mainclass);
    }

    private void removeItem() {
        this.classpath.remove(this.classpath.getSelectionIndices());
        this.updateRemoveButton();
        this.setModelClasspath(this.classpath.getItems());
    }

    private void setModelClasspath(String[] classpath) {
        String classpathString = Arrays.asList(classpath).toString();
        System.out.println("[DEBUG] Setting classpath to: " + classpathString);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setClassPath(classpath);
    }

    private void updateRemoveButton() {
        int i = this.classpath.getItemCount();
        boolean enable = true;
        if (i == 0) {
            enable = false;
        } else {
            int s = this.classpath.getSelectionCount();
            if (s == 0) {
                enable = false;
            }
        }
        this.remove.setEnabled(enable);
    }

    private void addClasspathItems(String[] items) {
        Object[] olditems = this.classpath.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (Arrays.binarySearch(olditems, items[i]) >= 0) continue;
            this.classpath.add(items[i]);
        }
        this.setModelClasspath(this.classpath.getItems());
    }

    private void updateUsejarWidgets() {
        boolean b = this.usejar.getSelection();
        this.setjar.setEnabled(b);
        this.jar.setEnabled(b);
    }

    private void setModelJar(String jarfile) {
        System.out.println("[DEBUG] Setting jarfile to: " + jarfile);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setJarLocation(jarfile);
    }

    private void setModelUsejar(boolean b) {
        System.out.println("[DEBUG] Setting use embedded jar to: " + b);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setEmbeddedJar(b);
    }

    private void setModelArguments(String args) {
        System.out.println("[DEBUG] Setting argument to: " + args);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setArguments(args);
    }

    protected void configureResources() {
        this.setImage(JSmoothResources.IMG_SWITCHER_APPLICATION);
        this.setToolTip("Java Application");
    }

    public void load() {
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        String[] classpath = jsmodel.getClassPath();
        if (classpath == null) {
            classpath = new String[]{};
        }
        this.classpath.setItems(classpath);
        boolean usejar = jsmodel.getEmbeddedJar();
        this.usejar.setSelection(usejar);
        this.LISTENER_USEJAR.widgetSelected(null);
        String mainclass = jsmodel.getMainClassName();
        if (mainclass == null) {
            mainclass = "";
        }
        this.mainclass.setText(mainclass);
        String jar = jsmodel.getJarLocation();
        if (jar == null) {
            jar = "";
        }
        this.jar.setText(jar);
        String args = jsmodel.getArguments();
        if (args == null) {
            args = "";
        }
        this.args.setText(args);
    }
}

