/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;

public class TaskPathProjectEvaluator
implements ProjectConfigurer {
    private final BuildCancellationToken cancellationToken;
    private final BuildOperationExecutor buildOperationExecutor;

    public TaskPathProjectEvaluator(BuildCancellationToken cancellationToken, BuildOperationExecutor buildOperationExecutor) {
        this.cancellationToken = cancellationToken;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void configure(ProjectInternal project) {
        project.getOwner().ensureConfigured();
    }

    @Override
    public void configureFully(ProjectState projectState) {
        projectState.ensureConfigured();
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        projectState.ensureTasksDiscovered();
    }

    @Override
    public void configureHierarchy(ProjectInternal project) {
        this.configure(project);
        for (Project sub : project.getSubprojects()) {
            this.configure((ProjectInternal)sub);
        }
    }

    @Override
    public void configureHierarchyInParallel(ProjectInternal project) {
        try {
            this.buildOperationExecutor.runAllWithAccessToProjectState(queue -> {
                for (final Project p : project.getAllprojects()) {
                    queue.add((BuildOperation)new RunnableBuildOperation(){

                        public void run(BuildOperationContext context) {
                            TaskPathProjectEvaluator.this.configure((ProjectInternal)p);
                        }

                        public BuildOperationDescriptor.Builder description() {
                            return BuildOperationDescriptor.displayName((String)("Configure project " + p.getName()));
                        }
                    });
                }
            });
        }
        catch (MultipleBuildOperationFailures e) {
            if (e.getCauses().size() == 1) {
                throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)e.getCauses().get(0)));
            }
            throw e;
        }
    }
}

