/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackFile
implements Serializable {
    static final long serialVersionUID = -834377078706854909L;
    public static final int OVERRIDE_FALSE = 0;
    public static final int OVERRIDE_TRUE = 1;
    public static final int OVERRIDE_ASK_FALSE = 2;
    public static final int OVERRIDE_ASK_TRUE = 3;
    public static final int OVERRIDE_UPDATE = 4;
    public transient String sourcePath = null;
    protected String relativePath = null;
    private String targetPath = null;
    private List<OsConstraint> osConstraints = null;
    private long length = 0L;
    private transient long size = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private int override = 0;
    private Map additionals = null;
    public String previousPackId = null;
    public long offsetInPreviousPack = -1L;
    private boolean pack200Jar = false;
    private String condition = null;

    public PackFile(File file, File file2, String string, List<OsConstraint> list, int n) throws FileNotFoundException {
        this(file2, PackFile.computeRelativePathFrom(file, file2), string, list, n, null);
    }

    public PackFile(File file, String string, String string2, List<OsConstraint> list, int n, Map map) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("No such file: " + file);
        }
        if ('/' != File.separatorChar) {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.sourcePath = file.getPath().replace(File.separatorChar, '/');
        this.relativePath = string != null ? string.replace(File.separatorChar, '/') : string;
        this.targetPath = string2 != null ? string2.replace(File.separatorChar, '/') : string2;
        this.osConstraints = list;
        this.override = n;
        this.size = this.length = file.length();
        this.mtime = file.lastModified();
        this.isDirectory = file.isDirectory();
        this.additionals = map;
        if (this.isDirectory) {
            this.length = 0L;
        }
    }

    public PackFile(File file, File file2, String string, List<OsConstraint> list, int n, Map map) throws FileNotFoundException {
        this(file2, PackFile.computeRelativePathFrom(file, file2), string, list, n, map);
    }

    public static String computeRelativePathFrom(File file, File file2) {
        if (file == null || file2 == null) {
            return null;
        }
        try {
            if (file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                return file2.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void setPreviousPackFileRef(String string, Long l) {
        this.previousPackId = string;
        this.offsetInPreviousPack = l;
    }

    public final List<OsConstraint> osConstraints() {
        return this.osConstraints;
    }

    public final long length() {
        return this.length;
    }

    public final long size() {
        return this.size;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final int override() {
        return this.override;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.previousPackId != null;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public String getRelativeSourcePath() {
        return this.relativePath;
    }

    public Map getAdditionals() {
        return this.additionals;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean isPack200Jar() {
        return this.pack200Jar;
    }

    public void setPack200Jar(boolean bl) {
        this.pack200Jar = bl;
    }

    public void setLoosePackInfo(boolean bl) {
        if (bl) {
            this.length = 0L;
        }
    }
}

