/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.LazyVariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSource;

public abstract class AbstractLazyModuleComponentResolveMetadata
extends AbstractModuleComponentResolveMetadata {
    private final VariantMetadataRules variantMetadataRules;
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private Optional<ImmutableList<? extends ConfigurationMetadata>> graphVariants;
    private final Map<String, ConfigurationMetadata> configurations = Maps.newHashMap();

    protected AbstractLazyModuleComponentResolveMetadata(AbstractMutableModuleComponentResolveMetadata metadata) {
        super(metadata);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.variantMetadataRules = metadata.getVariantMetadataRules();
    }

    protected AbstractLazyModuleComponentResolveMetadata(AbstractLazyModuleComponentResolveMetadata metadata, @Nullable ModuleSource source) {
        super((AbstractModuleComponentResolveMetadata)metadata, source);
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.variantMetadataRules = metadata.variantMetadataRules;
    }

    protected void copyCachedState(AbstractLazyModuleComponentResolveMetadata metadata) {
        this.configurations.putAll(metadata.configurations);
        this.graphVariants = metadata.graphVariants;
    }

    protected VariantMetadataRules getVariantMetadataRules() {
        return this.variantMetadataRules;
    }

    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    private Optional<ImmutableList<? extends ConfigurationMetadata>> buildVariantsForGraphTraversal(List<? extends ComponentVariant> variants) {
        if (variants.isEmpty()) {
            return this.maybeDeriveVariants();
        }
        ImmutableList.Builder configurations = new ImmutableList.Builder();
        for (ComponentVariant componentVariant : variants) {
            configurations.add((Object)new LazyVariantBackedConfigurationMetadata(this.getId(), componentVariant, this.getAttributes(), this.getAttributesFactory(), this.variantMetadataRules));
        }
        return Optional.of((Object)configurations.build());
    }

    @Override
    public synchronized Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.graphVariants == null) {
            this.graphVariants = this.buildVariantsForGraphTraversal((List<? extends ComponentVariant>)this.getVariants());
        }
        return this.graphVariants;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurationDefinitions.keySet();
    }

    @Override
    public synchronized ConfigurationMetadata getConfiguration(String name) {
        return this.populateConfigurationFromDescriptor(name, (Map<String, Configuration>)this.configurationDefinitions, this.configurations);
    }

    private ConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions, Map<String, ConfigurationMetadata> configurations) {
        ConfigurationMetadata populated = configurations.get(name);
        if (populated != null) {
            return populated;
        }
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        if (descriptorConfiguration == null) {
            return null;
        }
        ImmutableList<String> hierarchy = this.constructHierarchy(descriptorConfiguration);
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        populated = this.createConfiguration(this.getId(), name, transitive, visible, hierarchy, this.variantMetadataRules);
        configurations.put(name, populated);
        return populated;
    }

    private ImmutableList<String> constructHierarchy(Configuration descriptorConfiguration) {
        if (descriptorConfiguration.getExtendsFrom().isEmpty()) {
            return ImmutableList.of((Object)descriptorConfiguration.getName());
        }
        LinkedHashSet<String> accumulator = new LinkedHashSet<String>();
        this.populateHierarchy(descriptorConfiguration, accumulator);
        return ImmutableList.copyOf(accumulator);
    }

    private void populateHierarchy(Configuration metadata, Set<String> accumulator) {
        accumulator.add(metadata.getName());
        for (String parentName : metadata.getExtendsFrom()) {
            Configuration parent = (Configuration)this.configurationDefinitions.get((Object)parentName);
            this.populateHierarchy(parent, accumulator);
        }
    }

    protected abstract DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier var1, String var2, boolean var3, boolean var4, ImmutableList<String> var5, VariantMetadataRules var6);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractLazyModuleComponentResolveMetadata that = (AbstractLazyModuleComponentResolveMetadata)o;
        return Objects.equal(this.configurationDefinitions, that.configurationDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.configurationDefinitions});
    }
}

