/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;

class InputPropertyValueTaskStateChanges
implements TaskStateChanges {
    private final TaskInternal task;
    private final ImmutableMap<String, String> changed;

    public InputPropertyValueTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        ImmutableSortedMap<String, ValueSnapshot> previousInputProperties = previousExecution.getInputProperties();
        ImmutableMap.Builder changedBuilder = ImmutableMap.builder();
        ImmutableSortedMap<String, ValueSnapshot> currentInputProperties = currentExecution.getInputProperties();
        for (Map.Entry entry : currentInputProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            ValueSnapshot currentSnapshot = (ValueSnapshot)entry.getValue();
            ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
            if (previousSnapshot == null || currentSnapshot.equals(previousSnapshot)) continue;
            changedBuilder.put((Object)propertyName, (Object)(currentSnapshot instanceof ImplementationSnapshot ? "Implementation" : "Value"));
        }
        this.changed = changedBuilder.build();
        this.task = task;
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor) {
        for (Map.Entry entry : this.changed.entrySet()) {
            String propertyName = (String)entry.getKey();
            String changeType = (String)entry.getValue();
            if (visitor.visitChange(new DescriptiveChange("%s of input property '%s' has changed for %s", changeType, propertyName, this.task))) continue;
            return false;
        }
        return true;
    }
}

