/*
 * arch/arm/mach-dmw/include/mach/coma-alsa.h - css alsa kernel interface
 *
 * Using interface to Linux kernel is implemented that
 * allows sending TDM messages
 *
 * Copyright (C) 2007 NXP Semiconductors
 * Copyright (C) 2008 - 2011 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __COMA_ALSA_H
#define __COMA_ALSA_H

enum coma_alsa_restart {
	coma_alsa_NORESTART = -1,	/* Timer is not restarted */
	coma_alsa_RESTART = 0,	/* Timer must be restarted */
};

int coma_alsa_open(uint8_t id ,
                        uint32_t rate,
	                uint32_t sample_size,    /* size of a sample in bits */
	                uint32_t period_size,    /* number of frames in a period, 0 if no elapsed message required */
	                uint32_t channels,       /* all channels are one frame */
	                void    *rx_buffer_addr, /* physical address of rx sample buffer */
	                uint32_t rx_buffer_size, /*
	                                          * size of rx buffer in bytes (should be a multiple of
	                                          * channels * sample_size (sample_size in bytes))
	                                          * including the 4 bytes for the progress index
	                                          */
	                void    *tx_buffer_addr, /* physical address of tx sample buffer */
	                uint32_t tx_buffer_size /*
	                                          * size of tx buffer in bytes (should be a multiple of
	                                          * channels * sample_size (sample_size in bytes))
	                                          * including the 4 bytes for the progress index
	                                          */
	                );
int coma_alsa_start(unsigned int id, uint16_t flags);
int coma_alsa_stop(unsigned int id, uint16_t flags);
int coma_alsa_pause(unsigned int id);
int coma_alsa_reset(unsigned int id, uint16_t flags);
int coma_alsa_close(unsigned int id);
int coma_alsa_register_elapsed_cb(unsigned int id ,enum coma_alsa_restart (* function)(unsigned long int) ,unsigned long int data);
int coma_alsa_deregister_elapsed_cb(unsigned int id );

#endif
