/*
 *  linux/include/asm-arm/arch-dmw/uncompress.h
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *  Copyright (C) 2003 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define DMW_CMU_SWCLKENR1 (*(volatile unsigned char *)0x05300058)
#define UART1_EN		(1<<6)
#define UART2_EN		(1<<7)
#define UART3_EN		(1<<8)

#define DMW_UART1_BASE		0x05A00000
#define DMW_UART2_BASE		0x05B00000
#define DMW_UART3_BASE		0x05C00000

#define DMW_UART_CTL		0x00
#define DMW_UART_TX_FIFO_LEVEL	0x24
#define DMW_UART_TX_DATA	0x2C

#define DMW_UART_CTL_EN		0x01

#define dmw_writeb(v,a)	(*(volatile unsigned char *)(a) = (v))
#define dmw_readb(a)	(*(volatile unsigned char *)(a))

/*
 * This does not append a newline
 */
static inline unsigned int get_base( void )
{
	unsigned int base = 0;

	if ((DMW_CMU_SWCLKENR1 & UART1_EN) &&
	    ((dmw_readb(DMW_UART1_BASE + DMW_UART_CTL)) & DMW_UART_CTL_EN))
		base = DMW_UART1_BASE;
	else if ((DMW_CMU_SWCLKENR1 & UART2_EN) &&
	    ((dmw_readb(DMW_UART2_BASE + DMW_UART_CTL)) & DMW_UART_CTL_EN))
		base = DMW_UART2_BASE;
	else if ((DMW_CMU_SWCLKENR1 & UART3_EN) &&
	    ((dmw_readb(DMW_UART3_BASE + DMW_UART_CTL)) & DMW_UART_CTL_EN))
		base = DMW_UART3_BASE;

	return base;
}

static inline void putc(int c)
{
	unsigned int base = get_base();

	if (!base)
		return;

	/* wait until there is space in TX FIFO */
	while (dmw_readb(base + DMW_UART_TX_FIFO_LEVEL) == 0x80)
		barrier();

	dmw_writeb(c, base + DMW_UART_TX_DATA);
}

static inline void flush(void)
{
	unsigned int base = get_base();

	if (!base)
		return;

	while (dmw_readb(base + DMW_UART_TX_FIFO_LEVEL))
		barrier();
}

/*
 * nothing to do
 */
#define arch_decomp_setup()
#define arch_decomp_wdog()
