/*
 *  arch/arm/mach-dmw/include/mach/entry-macro.S
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <mach/hardware.h>

#define PLICU_BASE IO_ADDRESS(DMW_PLICU_BASE)

		.macro	disable_fiq
		.endm

		.macro	get_irqnr_preamble, base, tmp
		.endm

		.macro	arch_ret_to_user, tmp1, tmp2
		.endm

/**
 * get_irqnr_and_base - determine number of the highest priority IRQ
 * @irqnr: get the IRQ number (output register)
 * @irqstat: not used
 * @base: get the base address of PLICU (output register)
 * @tmp: will be overwritten
 *
 * Only the above registers will be used.  On return, the Z-flag shows if there
 * is an IRQ pending: Z=1: no IRQ, Z=0 IRQ \irqnr is pending.
 */
		.macro	get_irqnr_and_base, irqnr, irqstat, base, tmp

		ldr	\base, =PLICU_BASE
		ldr	\tmp, [\base, #DMW_PLICU_CAUSE1]	@ load first cause register

		clz	\irqnr, \tmp
		rsbs	\irqnr, \irqnr, #32

		ldreq	\tmp, [\base, #DMW_PLICU_CAUSE2]	@ load second cause register
		subne	\irqnr, \irqnr, #1
		bne	1001f

		clz	\irqnr, \tmp
		teq	\irqnr, #32
		rsb	\irqnr, \irqnr, #63

1001:		/* EQ will be set if no irqs pending */
		.endm

		.macro	irq_prio_table
		.endm

