// qertypes.h
//
// common types
// merged from brush.h, etc. for plugin support
//
#ifndef _QERTYPE_H
#define _QERTYPE_H

#ifndef __BYTEBOOL__
#define __BYTEBOOL__
typedef boolean qboolean;
//typedef unsigned char byte;
#endif

#define	MAX_FLAGS	12
#define	MAXPOINTS	16

typedef float vec_t;
typedef vec_t vec3_t[3];

typedef struct
{
    vec3_t	normal;
    double	dist;
    int		type;
} plane_t;

typedef struct texdef_s
{
	char	name[32];
	float	shift[2];
	float	rotate;
	float	scale[2];
	int		contents;
	int		flags;
	int		value;
} texdef_t;

typedef struct
{
	int			width, height;
	int			originy;
	texdef_t	texdef;
  int     m_nTotalHeight;
} texturewin_t;

typedef struct qtexture_s
{
	struct	qtexture_s *next;
	char	name[64];		// includes partial directory and extension
  int		width,  height;
	int		contents;
	int		flags;
	int		value;
	int		texture_number;	// gl bind number
	vec3_t	color;			// for flat shade mode
	qboolean	inuse;		// true = is present on the level
} qtexture_t;


typedef struct
{
	int		numpoints;
	int		maxpoints;
	float 	points[8][5];			// variable sized
} winding_t;


typedef struct face_s
{
	struct face_s	*next;
	vec3_t		planepts[3];
  texdef_t	texdef;
  plane_t		plane;

	winding_t  *face_winding;

	vec3_t		d_color;
	qtexture_t *d_texture;

} face_t;


typedef struct brush_s
{
	struct brush_s	*prev, *next;	// links in active/selected
	struct brush_s	*oprev, *onext;	// links in entity
	struct entity_s	*owner;
	vec3_t	mins, maxs;
	face_t     *brush_faces;
  qboolean alphaBrush;
} brush_t;


typedef struct trimodel_t
{
  vec3_t v[3];
  float  st[3][2];
} trimodel;


typedef struct eclass_s
{
	struct eclass_s *next;
	char	*name;
	qboolean	fixedsize;
	qboolean	unknown;		// wasn't found in source
	vec3_t	mins, maxs;
	vec3_t	color;
	texdef_t	texdef;
	char	*comments;
	char	flagnames[MAX_FLAGS][32];

  int nTriCount;
  trimodel *pTriList;
  int nTextureBind;
  int nSkinWidth, nSkinHeight;
  char *modelpath;
} eclass_t;

typedef struct epair_s
{
	struct epair_s	*next;
	char	*key;
	char	*value;
} epair_t;

typedef struct entity_s
{
	struct	entity_s	*prev, *next;
	brush_t		brushes;	// head/tail of list
	vec3_t		origin;
	eclass_t	*eclass;
	epair_t		*epairs;
} entity_t;

#endif