/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.EnumValueArgumentInfo;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.utils.KotlinToJavaAnnotationTargetsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "reportIncompatibleTargets", "kotlinTarget", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "javaTarget", "extractArguments", "", "", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirIncompatibleAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIncompatibleAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1491#2:61\n1516#2,3:62\n1519#2,3:72\n1869#2,2:75\n1625#2:77\n1869#2:78\n1870#2:80\n1626#2:81\n382#3,7:65\n1#4:79\n*S KotlinDebug\n*F\n+ 1 FirIncompatibleAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker\n*L\n38#1:61\n38#1:62,3\n38#1:72,3\n41#1:75,2\n57#1:77\n57#1:78\n57#1:80\n57#1:81\n38#1:65,7\n57#1:79\n*E\n"})
public final class FirIncompatibleAnnotationsChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirIncompatibleAnnotationsChecker INSTANCE = new FirIncompatibleAnnotationsChecker();

    private FirIncompatibleAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), context2.getSession());
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation javaTarget = firAnnotation;
        FirAnnotation kotlinTarget = FirAnnotationHelpersKt.getTargetAnnotation(declaration, context2.getSession());
        if (kotlinTarget == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)javaTarget.getSource(), FirJvmErrors.INSTANCE.getANNOTATION_TARGETS_ONLY_IN_JAVA(), null, 8, null);
        } else {
            this.reportIncompatibleTargets(kotlinTarget, javaTarget, context2, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reportIncompatibleTargets(@NotNull FirAnnotation kotlinTarget, @NotNull FirAnnotation javaTarget, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinTarget, (String)"kotlinTarget");
        Intrinsics.checkNotNullParameter((Object)javaTarget, (String)"javaTarget");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable iterable = this.extractArguments(kotlinTarget, StandardClassIds.Annotations.ParameterNames.INSTANCE.getTargetAllowedTargets());
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = KotlinToJavaAnnotationTargetsKt.getKOTLIN_TO_JAVA_ANNOTATION_TARGETS().get(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map correspondingJavaTargets = MapsKt.toMutableMap((Map)destination$iv$iv);
        correspondingJavaTargets.remove(null);
        Iterable $this$forEach$iv = this.extractArguments(javaTarget, StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            correspondingJavaTargets.remove(it);
        }
        if (!correspondingJavaTargets.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)javaTarget.getSource(), FirJvmErrors.INSTANCE.getINCOMPATIBLE_ANNOTATION_TARGETS(), (Object)CollectionsKt.filterNotNull((Iterable)correspondingJavaTargets.keySet()), (Object)CollectionsKt.flatten((Iterable)correspondingJavaTargets.values()), (DiagnosticContext)context2, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> extractArguments(FirAnnotation $this$extractArguments, Name argumentName) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default($this$extractArguments, argumentName, false, 2, null);
        List list = firExpression != null ? FirExpressionUtilKt.unwrapAndFlattenArgument(firExpression, true) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression argument = (FirExpression)element$iv;
            boolean bl2 = false;
            Object object = FirAnnotationUtilsKt.extractEnumValueArgumentInfo(argument);
            if ((object != null && (object = ((EnumValueArgumentInfo)object).getEnumEntryName()) != null ? ((Name)object).asString() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }
}

