/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

class InstanceOrderingMethodInterceptor
implements IMethodInterceptor {
    InstanceOrderingMethodInterceptor() {
    }

    @Override
    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        return this.groupMethodsByInstance(methods);
    }

    private List<IMethodInstance> groupMethodsByInstance(List<IMethodInstance> methods) {
        List<Object> instanceList = Lists.newArrayList();
        Map<Object, List> map = Maps.newLinkedHashMap();
        for (IMethodInstance mi : methods) {
            Object instance = mi.getInstance();
            if (!instanceList.contains(instance)) {
                instanceList.add(instance);
            }
            List l = map.computeIfAbsent(instance, k -> Lists.newArrayList());
            l.add(mi);
        }
        List<IMethodInstance> result = Lists.newArrayList();
        for (Object instance : instanceList) {
            result.addAll((Collection)map.get(instance));
        }
        return result;
    }
}

