/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.nodes.OutlineNode;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;

public class OutlineOperator
extends JTableOperator {
    public OutlineOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public OutlineOperator(ContainerOperator containerOperator, int n) {
        super((JTable)((Outline)containerOperator.waitSubComponent((ComponentChooser)new OutlineFinder(ComponentSearcher.getTrueChooser((String)"Any Outline")), n)));
        this.copyEnvironment((Operator)containerOperator);
    }

    public OutlineOperator(Outline outline) {
        super((JTable)outline);
    }

    public Outline getOutline() {
        return (Outline)this.getSource();
    }

    public int getTreeColumnIndex() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (this.convertColumnIndexToModel(i) != 0) continue;
            return i;
        }
        return -1;
    }

    public TreePath findNextPathElement(TreePath treePath, String string, int n) {
        TreePath treePath2;
        if (!this.isExpanded(treePath)) {
            this.expandPath(treePath);
        }
        Timeouts timeouts = this.getTimeouts().cloneThis();
        timeouts.setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JTreeOperator.WaitNextNodeTimeout"));
        try {
            Waiter waiter = new Waiter((Waitable)new NodeWaiter(treePath, string, n));
            waiter.setTimeouts(timeouts);
            treePath2 = (TreePath)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
        return treePath2;
    }

    public TreePath findNextPathElement(TreePath treePath, String string) {
        return this.findNextPathElement(treePath, string, 0);
    }

    public OutlineNode getRootNode(String string) {
        return this.getRootNode(string, 0);
    }

    public OutlineNode getRootNode(String string, int n) {
        TreePath treePath = new TreePath(this.getOutline().getOutlineModel().getRoot());
        return new OutlineNode(this, this.findNextPathElement(treePath, string, n));
    }

    public TreePath findPath(TreePath treePath, String string) {
        int n = string.indexOf("|");
        if (n > -1) {
            TreePath treePath2 = this.findNextPathElement(treePath, string.substring(0, n));
            return this.findPath(treePath2, string.substring(n + 1));
        }
        return this.findNextPathElement(treePath, string);
    }

    public TreePath findPath(String string) {
        TreePath treePath = new TreePath(this.getOutline().getOutlineModel().getRoot());
        return this.findPath(treePath, string);
    }

    public void waitExpanded(final TreePath treePath) {
        if (treePath == null) {
            throw new JemmyException("No such path: null");
        }
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return OutlineOperator.this.isExpanded(treePath);
            }

            public String getDescription() {
                return "Has \"" + treePath.toString() + "\" path expanded";
            }
        });
    }

    protected int getVisibleRootModifier() {
        return this.getOutline().isRootVisible() ? 0 : -1;
    }

    public Point getLocationForPath(TreePath treePath) {
        int n = this.getTreeColumnIndex();
        int n2 = this.getRowForPath(treePath);
        return n2 == -1 ? new Point(-1, -1) : new Point(n, n2);
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath.getParentPath() == null) {
            return this.getVisibleRootModifier();
        }
        if (!this.isExpanded(treePath.getParentPath())) {
            this.expandPath(treePath.getParentPath());
        }
        int n = -1;
        while (treePath.getParentPath() != null) {
            n += 1 + this.getPrecedingSiblingsRowSpan(treePath);
            treePath = treePath.getParentPath();
        }
        return n;
    }

    protected int getPrecedingSiblingsRowSpan(TreePath treePath) {
        OutlineModel outlineModel = this.getOutline().getOutlineModel();
        if (treePath.getParentPath() == null) {
            return 0 + this.getVisibleRootModifier();
        }
        Object object = treePath.getLastPathComponent();
        TreePath treePath2 = treePath.getParentPath();
        int n = 0;
        int n2 = outlineModel.getIndexOfChild(treePath2.getLastPathComponent(), object);
        for (int i = n2 - 1; i >= 0; --i) {
            Object object2 = outlineModel.getChild(treePath2.getLastPathComponent(), i);
            n += this.getRowSpanOfLastElement(treePath2.pathByAddingChild(object2));
        }
        return n;
    }

    protected int getRowSpanOfLastElement(TreePath treePath) {
        OutlineModel outlineModel = this.getOutline().getOutlineModel();
        if (!this.isExpanded(treePath)) {
            return 1;
        }
        Object object = treePath.getLastPathComponent();
        int n = 1;
        int n2 = outlineModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            Object object2 = outlineModel.getChild(object, i);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            n += this.getRowSpanOfLastElement(treePath2);
        }
        return n;
    }

    public void selectPath(TreePath treePath) {
        Point point = this.getLocationForPath(treePath);
        if (!point.equals(new Point(-1, -1))) {
            this.selectCell(point.y, point.x);
        }
    }

    public void scrollToPath(TreePath treePath) {
        Point point = this.getLocationForPath(treePath);
        if (!point.equals(new Point(-1, -1))) {
            this.scrollToCell(point.y, point.x);
        }
    }

    public void expandPath(final TreePath treePath) {
        this.runMapping(new Operator.MapVoidAction("expandPath"){

            public void map() {
                OutlineOperator.this.getOutline().expandPath(treePath);
            }
        });
    }

    public boolean isExpanded(final TreePath treePath) {
        return (Boolean)this.runMapping(new Operator.MapAction("isExpanded"){

            public Object map() {
                return OutlineOperator.this.getOutline().isExpanded(treePath);
            }
        });
    }

    private class NodeWaiter
    implements Waitable {
        private TreePath parentPath;
        private int[] rowsToSearch = null;
        private String name;
        private int index;

        public NodeWaiter(TreePath treePath, String string, int n) {
            this.parentPath = treePath;
            this.name = string;
            this.index = n;
        }

        private int[] getRowsToSearch() {
            int n = OutlineOperator.this.getOutline().getOutlineModel().getChildCount(this.parentPath.getLastPathComponent());
            if (this.rowsToSearch == null || this.rowsToSearch.length != n) {
                int n2 = OutlineOperator.this.getRowForPath(this.parentPath) + 1;
                int n3 = 0;
                this.rowsToSearch = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.rowsToSearch[i] = n2 + n3;
                    Object object = OutlineOperator.this.getOutline().getOutlineModel().getChild(this.parentPath.getLastPathComponent(), i);
                    TreePath treePath = this.parentPath.pathByAddingChild(object);
                    n3 += OutlineOperator.this.getRowSpanOfLastElement(treePath);
                }
            }
            return this.rowsToSearch;
        }

        public Object actionProduced(Object object) {
            Point point = OutlineOperator.this.findCell(this.name, this.getRowsToSearch(), new int[]{OutlineOperator.this.getTreeColumnIndex()}, this.index);
            if (point.equals(new Point(-1, -1))) {
                return null;
            }
            TreePath treePath = OutlineOperator.this.getOutline().getLayoutCache().getPathForRow(point.y);
            if (treePath == null) {
                return null;
            }
            if (treePath.getPathCount() != this.parentPath.getPathCount() + 1) {
                return null;
            }
            return treePath;
        }

        public String getDescription() {
            return "Tree node cell with name '" + this.name + "' present.";
        }
    }

    private static class OutlineFinder
    implements ComponentChooser {
        private ComponentChooser subFinder;

        public OutlineFinder(ComponentChooser componentChooser) {
            this.subFinder = componentChooser;
        }

        public boolean checkComponent(Component component) {
            Class<?> clazz = component.getClass();
            do {
                if (!clazz.getName().equals("org.netbeans.swing.outline.Outline")) continue;
                return this.subFinder.checkComponent(component);
            } while ((clazz = clazz.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }
}

