/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/DetailedReceiver;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "typesFromSmartCasts", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isStable", "", "originalBaseType", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Ljava/util/Set;ZLorg/jetbrains/kotlin/types/KotlinType;)V", "getReceiverValue", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getTypesFromSmartCasts", "()Ljava/util/Set;", "()Z", "allOriginalTypes", "getAllOriginalTypes", "hasTypesFromSmartCasts", "toString", "", "resolution"})
public final class ReceiverValueWithSmartCastInfo
implements DetailedReceiver {
    @NotNull
    private final ReceiverValue receiverValue;
    @NotNull
    private final Set<KotlinType> typesFromSmartCasts;
    private final boolean isStable;
    @NotNull
    private final Set<KotlinType> allOriginalTypes;

    public ReceiverValueWithSmartCastInfo(@NotNull ReceiverValue receiverValue, @NotNull Set<? extends KotlinType> typesFromSmartCasts, boolean isStable, @NotNull KotlinType originalBaseType) {
        Intrinsics.checkNotNullParameter(receiverValue, "receiverValue");
        Intrinsics.checkNotNullParameter(typesFromSmartCasts, "typesFromSmartCasts");
        Intrinsics.checkNotNullParameter(originalBaseType, "originalBaseType");
        this.receiverValue = receiverValue;
        this.typesFromSmartCasts = typesFromSmartCasts;
        this.isStable = isStable;
        this.allOriginalTypes = SetsKt.plus(this.typesFromSmartCasts, originalBaseType);
    }

    public /* synthetic */ ReceiverValueWithSmartCastInfo(ReceiverValue receiverValue, Set set, boolean bl, KotlinType kotlinType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            KotlinType kotlinType2 = receiverValue.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            kotlinType = kotlinType2;
        }
        this(receiverValue, set, bl, kotlinType);
    }

    @NotNull
    public final ReceiverValue getReceiverValue() {
        return this.receiverValue;
    }

    @NotNull
    public final Set<KotlinType> getTypesFromSmartCasts() {
        return this.typesFromSmartCasts;
    }

    public final boolean isStable() {
        return this.isStable;
    }

    @NotNull
    public final Set<KotlinType> getAllOriginalTypes() {
        return this.allOriginalTypes;
    }

    public final boolean hasTypesFromSmartCasts() {
        return !((Collection)this.typesFromSmartCasts).isEmpty();
    }

    @NotNull
    public String toString() {
        return this.receiverValue.toString();
    }
}

