/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class ReplaceMissingWithUserConstant
extends PotentialClassIgnorer
implements UnsupervisedFilter,
StreamableFilter,
EnvironmentHandler,
WeightedInstancesHandler,
WeightedAttributesHandler {
    private static final long serialVersionUID = -7334039452189350356L;
    protected transient Environment m_env;
    protected Range m_selectedRange;
    protected String m_range = "first-last";
    protected String m_resolvedRange = "";
    protected String m_nominalStringConstant = "";
    protected String m_resolvedNominalStringConstant = "";
    protected String m_numericConstant = "0";
    protected String m_resolvedNumericConstant = "";
    protected double m_numericConstVal = 0.0;
    protected String m_dateConstant = "";
    protected String m_resolvedDateConstant = "";
    protected double m_dateConstVal = 0.0;
    protected String m_defaultDateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    protected String m_resolvedDateFormat = "";

    public String globalInfo() {
        return "Replaces all missing values for nominal, string, numeric and date attributes in the dataset with user-supplied constant values.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> opts = new Vector<Option>(5);
        opts.addElement(new Option("\tSpecify list of attributes to replace missing values for \n\t(as weka range list of indices or a comma separated list of attribute names).\n\t(default: consider all attributes)", "R", 1, "-A <index1,index2-index4,... | att-name1,att-name2,...>"));
        opts.addElement(new Option("\tSpecify the replacement constant for nominal/string attributes", "N", 1, "-N"));
        opts.addElement(new Option("\tSpecify the replacement constant for numeric attributes\n\t(default: 0)", "R", 1, "-R"));
        opts.addElement(new Option("\tSpecify the replacement constant for date attributes", "D", 1, "-D"));
        opts.addElement(new Option("\tSpecify the date format for parsing the replacement date constant\n\t(default: yyyy-MM-dd'T'HH:mm:ss)", "F", 1, "-F"));
        opts.addAll(Collections.list(super.listOptions()));
        return opts.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String formatString;
        String dateString;
        String numString;
        String nomString;
        String atts = Utils.getOption('A', options);
        if (atts.length() > 0) {
            this.setAttributes(atts);
        }
        if ((nomString = Utils.getOption('N', options)).length() > 0) {
            this.setNominalStringReplacementValue(nomString);
        }
        if ((numString = Utils.getOption('R', options)).length() > 0) {
            this.setNumericReplacementValue(numString);
        }
        if ((dateString = Utils.getOption('D', options)).length() > 0) {
            this.setDateReplacementValue(dateString);
        }
        if ((formatString = Utils.getOption('F', options)).length() > 0) {
            this.setDateFormat(formatString);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.getAttributes().length() > 0) {
            options.add("-A");
            options.add(this.getAttributes());
        }
        if (this.getNominalStringReplacementValue().length() > 0) {
            options.add("-N");
            options.add(this.getNominalStringReplacementValue());
        }
        if (this.getNumericReplacementValue().length() > 0) {
            options.add("-R");
            options.add(this.getNumericReplacementValue());
        }
        if (this.getDateReplacementValue().length() > 0) {
            options.add("-D");
            options.add(this.getDateReplacementValue());
        }
        if (this.getDateFormat().length() > 0) {
            options.add("-F");
            options.add(this.getDateFormat());
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[1]);
    }

    public String attributesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\". Can alternatively specify a comma separated list of attribute names. Note that  you can't mix indices and attribute names in the same list";
    }

    public void setAttributes(String range) {
        this.m_range = range;
    }

    public String getAttributes() {
        return this.m_range;
    }

    public String nominalStringReplacementValueTipText() {
        return "The constant to replace missing values in nominal/string attributes with";
    }

    public String getNominalStringReplacementValue() {
        return this.m_nominalStringConstant;
    }

    public void setNominalStringReplacementValue(String nominalStringConstant) {
        this.m_nominalStringConstant = nominalStringConstant;
    }

    public String numericReplacementValueTipText() {
        return "The constant to replace missing values in numeric attributes with";
    }

    public String getNumericReplacementValue() {
        return this.m_numericConstant;
    }

    public void setNumericReplacementValue(String numericConstant) {
        this.m_numericConstant = numericConstant;
    }

    public String dateReplacementValueTipText() {
        return "The constant to replace missing values in date attributes with";
    }

    public void setDateReplacementValue(String dateConstant) {
        this.m_dateConstant = dateConstant;
    }

    public String getDateReplacementValue() {
        return this.m_dateConstant;
    }

    public String dateFormatTipText() {
        return "The formatting string to use for parsing the date replacement value";
    }

    public void setDateFormat(String dateFormat) {
        this.m_defaultDateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.m_defaultDateFormat;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_resolvedNominalStringConstant = this.m_nominalStringConstant;
        this.m_resolvedNumericConstant = this.m_numericConstant;
        this.m_resolvedDateConstant = this.m_dateConstant;
        this.m_resolvedDateFormat = this.m_defaultDateFormat;
        this.m_resolvedRange = this.m_range;
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        try {
            if (this.m_resolvedNominalStringConstant != null && this.m_resolvedNominalStringConstant.length() > 0) {
                this.m_resolvedNominalStringConstant = this.m_env.substitute(this.m_resolvedNominalStringConstant);
            }
            if (this.m_resolvedNumericConstant != null && this.m_resolvedNumericConstant.length() > 0) {
                this.m_resolvedNumericConstant = this.m_env.substitute(this.m_resolvedNumericConstant);
            }
            if (this.m_resolvedDateConstant != null && this.m_resolvedDateConstant.length() > 0) {
                this.m_resolvedDateConstant = this.m_env.substitute(this.m_resolvedDateConstant);
            }
            if (this.m_resolvedDateFormat != null && this.m_resolvedDateFormat.length() > 0) {
                this.m_resolvedDateFormat = this.m_env.substitute(this.m_resolvedDateFormat);
            }
            if (this.m_resolvedRange != null && this.m_resolvedRange.length() > 0) {
                this.m_resolvedRange = this.m_env.substitute(this.m_resolvedRange);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_selectedRange = new Range(this.m_resolvedRange);
        try {
            this.m_selectedRange.setUpper(instanceInfo.numAttributes() - 1);
        }
        catch (IllegalArgumentException e) {
            String[] parts = this.m_resolvedRange.split(",");
            if (parts.length == 0) {
                throw new Exception("Must specify which attributes to replace missing values for!");
            }
            StringBuffer indexList = new StringBuffer();
            for (String att : parts) {
                Attribute a = instanceInfo.attribute(att = att.trim());
                if (a == null) {
                    throw new Exception("I can't find the requested attribute '" + att + "' in the incoming instances.");
                }
                indexList.append(",").append(a.index() + 1);
            }
            String result = indexList.toString();
            result = result.substring(1, result.length());
            this.m_selectedRange = new Range(result);
            this.m_selectedRange.setUpper(instanceInfo.numAttributes() - 1);
        }
        boolean hasNominal = false;
        boolean hasString = false;
        boolean hasNumeric = false;
        boolean hasDate = false;
        for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
            if (!this.m_selectedRange.isInRange(i)) continue;
            if (instanceInfo.attribute(i).isNominal()) {
                hasNominal = true;
                continue;
            }
            if (instanceInfo.attribute(i).isString()) {
                hasString = true;
                continue;
            }
            if (instanceInfo.attribute(i).isDate()) {
                hasDate = true;
                continue;
            }
            if (!instanceInfo.attribute(i).isNumeric()) continue;
            hasNumeric = true;
        }
        if ((hasNominal || hasString) && (this.m_resolvedNominalStringConstant == null || this.m_resolvedNominalStringConstant.length() == 0)) {
            if (this.m_resolvedNumericConstant != null && this.m_resolvedNumericConstant.length() > 0) {
                this.m_resolvedNominalStringConstant = "" + this.m_resolvedNumericConstant;
            } else {
                throw new Exception("Data contains nominal/string attributes and no replacement constant has been supplied");
            }
        }
        if (hasNumeric) {
            if (this.m_numericConstant == null || this.m_numericConstant.length() == 0) {
                if (this.m_resolvedNominalStringConstant != null && this.m_resolvedNominalStringConstant.length() > 0) {
                    try {
                        Double.parseDouble(this.m_resolvedNominalStringConstant);
                        this.m_resolvedNumericConstant = this.m_resolvedNominalStringConstant;
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Data contains numeric attributes and no numeric constant has been supplied. Unable to parse nominal constant as a number either.");
                    }
                } else {
                    throw new Exception("Data contains numeric attributes and no replacement constant has been supplied");
                }
            }
            try {
                this.m_numericConstVal = Double.parseDouble(this.m_resolvedNumericConstant);
            }
            catch (NumberFormatException e) {
                throw new Exception("Unable to parse numeric constant");
            }
        }
        if (hasDate) {
            if (this.m_resolvedDateConstant == null || this.m_resolvedDateConstant.length() == 0) {
                throw new Exception("Data contains date attributes and no replacement constant has been supplied");
            }
            SimpleDateFormat sdf = new SimpleDateFormat(this.m_resolvedDateFormat);
            Date d = sdf.parse(this.m_resolvedDateConstant);
            this.m_dateConstVal = d.getTime();
        }
        Instances outputFormat = new Instances(instanceInfo, 0);
        ArrayList<Attribute> updatedNoms = new ArrayList<Attribute>();
        for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
            Attribute temp;
            if (i == instanceInfo.classIndex() || !this.m_selectedRange.isInRange(i) || !(temp = instanceInfo.attribute(i)).isNominal() || temp.indexOfValue(this.m_resolvedNominalStringConstant) >= 0) continue;
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.m_resolvedNominalStringConstant);
            for (int j = 0; j < temp.numValues(); ++j) {
                values.add(temp.value(j));
            }
            Attribute newAtt = new Attribute(temp.name(), values);
            newAtt.setWeight(temp.weight());
            updatedNoms.add(newAtt);
        }
        if (updatedNoms.size() > 0) {
            int nomCount = 0;
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
                if (i != instanceInfo.classIndex() && this.m_selectedRange.isInRange(i)) {
                    if (instanceInfo.attribute(i).isNominal()) {
                        atts.add((Attribute)updatedNoms.get(nomCount++));
                        continue;
                    }
                    atts.add(instanceInfo.attribute(i));
                    continue;
                }
                atts.add(instanceInfo.attribute(i));
            }
            outputFormat = new Instances(instanceInfo.relationName(), atts, 0);
            outputFormat.setClassIndex(this.getInputFormat().classIndex());
        }
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance inst) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] vals = new double[inst.numAttributes()];
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (inst.isMissing(i) && this.m_selectedRange.isInRange(i)) {
                if (i != inst.classIndex()) {
                    if (inst.attribute(i).isDate()) {
                        vals[i] = this.m_dateConstVal;
                        continue;
                    }
                    if (inst.attribute(i).isNumeric()) {
                        vals[i] = this.m_numericConstVal;
                        continue;
                    }
                    if (inst.attribute(i).isNominal()) {
                        int temp = inst.attribute(i).indexOfValue(this.m_resolvedNominalStringConstant);
                        vals[i] = temp >= 0 ? (double)temp : 0.0;
                        continue;
                    }
                    if (inst.attribute(i).isString()) {
                        if (inst.attribute(i).numValues() <= 1) {
                            this.outputFormatPeek().attribute(i).setStringValue(this.m_resolvedNominalStringConstant);
                            vals[i] = 0.0;
                            continue;
                        }
                        vals[i] = this.outputFormatPeek().attribute(i).addStringValue(this.m_resolvedNominalStringConstant);
                        continue;
                    }
                    vals[i] = inst.value(i);
                    continue;
                }
                vals[i] = inst.value(i);
                continue;
            }
            if (this.m_selectedRange.isInRange(i)) {
                if (inst.attribute(i).isString()) {
                    if (inst.attribute(i).numValues() <= 1) {
                        this.outputFormatPeek().attribute(i).setStringValue(inst.stringValue(i));
                    } else {
                        this.outputFormatPeek().attribute(i).addStringValue(inst.stringValue(i));
                    }
                    vals[i] = this.outputFormatPeek().attribute(i).indexOfValue(inst.stringValue(i));
                    continue;
                }
                if (inst.attribute(i).isNominal() && i != inst.classIndex()) {
                    vals[i] = this.outputFormatPeek().attribute(i).indexOfValue(inst.stringValue(i));
                    continue;
                }
                vals[i] = inst.value(i);
                continue;
            }
            vals[i] = inst.value(i);
        }
        AbstractInstance newInst = null;
        newInst = inst instanceof SparseInstance ? new SparseInstance(inst.weight(), vals) : new DenseInstance(inst.weight(), vals);
        newInst.setDataset(this.getOutputFormat());
        this.push(newInst, false);
        return true;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] args) {
        ReplaceMissingWithUserConstant.runFilter(new ReplaceMissingWithUserConstant(), args);
    }
}

