/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.environment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarFile;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import uk.org.webcompere.systemstubs.internal.ProcessEnvironmentInterceptor;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We need to set up the stub, but interaction is set on construction")
public class EnvironmentVariableMocker {
    private static final Stack<Map<String, String>> REPLACEMENT_ENV = new Stack();
    private static final Map<String, String> ORIGINAL_ENV = new HashMap<String, String>(System.getenv());

    private static void installInterceptorIntoBootLoader(Instrumentation instrumentation) throws IOException {
        File tempFile = File.createTempFile("interceptor", ".jar");
        tempFile.deleteOnExit();
        try (FileOutputStream file = new FileOutputStream(tempFile);
             InputStream resourceStream = EnvironmentVariableMocker.class.getClassLoader().getResourceAsStream("system-stubs-interceptor.jar");){
            resourceStream.transferTo(file);
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(tempFile));
    }

    @Deprecated(since="2.1.5")
    public static void connect(Map<String, String> newEnvironmentVariables) {
        EnvironmentVariableMocker.connect(newEnvironmentVariables, Collections.emptySet());
    }

    public static void connect(Map<String, String> newEnvironmentVariables, Set<String> variablesToRemove) {
        System.getenv().entrySet().stream().filter(entry -> !newEnvironmentVariables.containsKey(entry.getKey())).forEach(entry -> newEnvironmentVariables.put((String)entry.getKey(), (String)entry.getValue()));
        variablesToRemove.forEach(newEnvironmentVariables::remove);
        REPLACEMENT_ENV.push(newEnvironmentVariables);
        ProcessEnvironmentInterceptor.setEnv(newEnvironmentVariables);
    }

    public static synchronized boolean pop() {
        if (!REPLACEMENT_ENV.empty()) {
            REPLACEMENT_ENV.pop();
        }
        if (!REPLACEMENT_ENV.empty()) {
            ProcessEnvironmentInterceptor.setEnv(REPLACEMENT_ENV.peek());
        } else {
            ProcessEnvironmentInterceptor.setEnv(ORIGINAL_ENV);
        }
        return REPLACEMENT_ENV.empty();
    }

    public static synchronized boolean remove(Map<String, String> theOneToPop) {
        boolean result = REPLACEMENT_ENV.remove(theOneToPop);
        if (!REPLACEMENT_ENV.empty()) {
            ProcessEnvironmentInterceptor.setEnv(REPLACEMENT_ENV.peek());
        } else {
            ProcessEnvironmentInterceptor.setEnv(ORIGINAL_ENV);
        }
        return result;
    }

    static {
        try {
            Instrumentation instrumentation = ByteBuddyAgent.install();
            EnvironmentVariableMocker.installInterceptorIntoBootLoader(instrumentation);
            ByteBuddy byteBuddy = new ByteBuddy();
            byteBuddy.redefine(Class.forName("java.lang.ProcessEnvironment")).method((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"getenv", "environment", "toEnvironmentBlock"}))).intercept((Implementation)MethodDelegation.to(ProcessEnvironmentInterceptor.class)).make().load(EnvironmentVariableMocker.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
            ProcessEnvironmentInterceptor.setEnv(ORIGINAL_ENV);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot set up environment mocking: " + e.getMessage() + ".", e);
        }
    }
}

