/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;

public class FileToStreamTailer
extends Thread
implements AutoCloseable {
    private final File file;
    private final PrintStream stream;
    private final int intervalMsec;
    private boolean ignoreHead = true;
    private volatile boolean keepReading = true;
    private volatile boolean flush = false;

    public FileToStreamTailer(File file, PrintStream printStream, int n) {
        super("Tail");
        this.intervalMsec = n;
        this.setDaemon(true);
        this.file = file;
        this.stream = printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.isInterrupted()) {
            this.keepReading = false;
        }
        Optional<BufferedReader> optional = Optional.empty();
        try {
            while (true) {
                if (!this.keepReading) {
                    if (!this.flush) return;
                }
                this.flush = false;
                try {
                    if (!optional.isPresent()) {
                        try {
                            optional = Optional.of(new BufferedReader(new FileReader(this.file)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.ignoreHead = false;
                        }
                    }
                    optional.ifPresent(bufferedReader -> {
                        try {
                            String string;
                            while ((string = bufferedReader.readLine()) != null) {
                                if (this.ignoreHead) continue;
                                this.stream.println(string);
                            }
                            this.ignoreHead = false;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    if (!this.keepReading) continue;
                }
                catch (Throwable throwable) {
                    if (!this.keepReading) throw throwable;
                    try {
                        Thread.sleep(this.intervalMsec);
                        throw throwable;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Thread.sleep(this.intervalMsec);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
                break;
            }
        }
        finally {
            optional.ifPresent(bufferedReader -> {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void interrupt() {
        this.keepReading = false;
        super.interrupt();
    }

    public void flush() {
        this.flush = true;
    }

    @Override
    public void close() throws Exception {
        this.flush();
        this.interrupt();
    }
}

