/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestRunner;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;

public class TestNGTestClassProcessor
implements RequiresTestFrameworkTestClassProcessor {
    private final List<Class<?>> testClasses = new ArrayList();
    private final File testReportDir;
    private final TestNGSpec spec;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final ActorFactory actorFactory;
    private ClassLoader applicationClassLoader;
    private Actor resultProcessorActor;
    private TestResultProcessor resultProcessor;
    private boolean startedProcessing;

    public TestNGTestClassProcessor(File testReportDir, TestNGSpec spec, List<File> suiteFiles, IdGenerator<?> idGenerator, Clock clock, ActorFactory actorFactory) {
        this.testReportDir = testReportDir;
        this.spec = spec;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.actorFactory = actorFactory;
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.testng.TestNG");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestClassProcessor.TestFrameworkNotAvailableException("Failed to load TestNG.  Please ensure that TestNG is available on the test runtime classpath.");
        }
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.assertTestFrameworkAvailable();
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)resultProcessor);
        this.resultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.spec.isDryRun()) {
            System.setProperty("testng.mode.dryrun", "true");
        }
        this.startedProcessing = true;
    }

    public void processTestClass(TestClassRunInfo testClass) {
        if (this.startedProcessing) {
            try {
                this.testClasses.add(this.applicationClassLoader.loadClass(testClass.getTestClassName()));
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not load test class '%s'.", testClass.getTestClassName()), e);
            }
        }
    }

    public void stop() {
        if (this.startedProcessing) {
            try {
                new TestNGTestRunner(this.testReportDir, this.suiteFiles, this.idGenerator, this.clock, this.resultProcessor, this.applicationClassLoader, this.spec, this.testClasses).runTests();
            }
            finally {
                this.resultProcessorActor.stop();
            }
        }
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

