@q file: o2linker_defs.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@*1 Structure implementation.
@*2 |prt_called_thread_list_ast_functor| implementation.
@<Structure implementations@>=
extern void PRINT_CALLED_THREAD_LIST(AST* Node,std::ofstream* Ow_linker_file,int Idx)
{
    char big_buf_[BIG_BUFFER_32K];
    thread_attributes* ta = (thread_attributes*)AST::content(*Node); 
    KCHARP w_called_threads =	
        "\\Linkercalledthreads{%s}{%i}";
       char xlate_gfile[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(ta->thread_name_->c_string()->c_str(),xlate_gfile);
        int x = sprintf(big_buf_
 		,w_called_threads
		,xlate_gfile
                ,Idx
 		);	
      (*Ow_linker_file).write(big_buf_,x);
      (*Ow_linker_file) << endl;
    KCHARP w_called_threads_index =	
        "@@.%s@@>";
        x = sprintf(big_buf_
 		,w_called_threads_index
		,xlate_gfile
 		);	
      (*Ow_linker_file).write(big_buf_,x);
      (*Ow_linker_file) << endl;
}
@/
yacco2::functor_result_type @/
prt_called_thread_list_ast_functor::operator()(yacco2::ast_base_stack* Stk_env){
    stk_env_ = Stk_env;
    srec_ = stk_env_->cur_stk_rec_;
    idx_ = stk_env_->idx_;
    yacco2::INT pidx = idx_ - 1;
    cnode_ = srec_->node_;
    if(pidx <= 0) goto prt_prefix;
    {
      ast_base_stack::s_rec* psrec = stk_env_->stk_rec(pidx);
    }
prt_prefix:@/
@<acquire trace mu@>;
    yacco2::INT no_lt(0);
    for (yacco2::INT x = 0; x <= idx_; ++x) 
      if(stk_env_->stk_rec(x)->act_ == ast_base_stack::left) ++no_lt;
@<release trace mu@>;
call_prt_func:@/
    (*prt_funct_)(cnode_,ow_linker_file_,no_lt+1);
    return accept_node;//continue looping thru ast
  }

  prt_called_thread_list_ast_functor::
  prt_called_thread_list_ast_functor(PFF Func)
    :prt_funct_(Func),cnt_(0),ow_linker_file_(0){}
  
  void 
  prt_called_thread_list_ast_functor::
  reset_cnt(){
  cnt_ = 0;
  }
  void prt_called_thread_list_ast_functor::o_file(std::ofstream* Ow_linker_file){
   ow_linker_file_ = Ow_linker_file;
  }

@*2 Acquire trace mu.\fbreak
Used to serialize trace output. 
Sometimes the traced output is skewed due to the threading.
The output to a global container is not thread safe, so make it by use of a mutex.
@<acquire trace mu@>=
      LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
    yacco2::lrclog  << "YACCO2_MU_TRACING__::Acquired trace mu" << std::endl;
}

@*2 Release trace mu.\fbreak
Used to serialize trace output.
@<release trace mu@>=
if(yacco2::YACCO2_MU_TRACING__){
    yacco2::lrclog  << "YACCO2_MU_TRACING__::Releasing trace mu" << std::endl;
}
      UNLOCK_MUTEX(yacco2::TRACE_MU);

@** Write out |o2linker_defs.cpp| Structure implementations.\fbreak
@(o2linker_defs.cpp@>=
#include "o2linker.h"
@<Structure implementations@>;
