/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rtn_component.lex
Dates:		  16 Dec, 2005
Purpose:	  a T returned from a thread
Output:       T_in_stbl
              "|||"
              assorted errors
  
              
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rtn_component| Thread.\fbreak
A  T returned from a thread.
@/
fsm	
(fsm-id "rtn_component.lex"
,fsm-filename rtn_component
,fsm-namespace NS_rtn_component
,fsm-class Crtn_component{
  user-prefix-declaration
#include "identifier.h"
#include "c_string.h"
#include "unq_str.h"
#include "yacco2_stbl.h"
  ***
  user-declaration
    public:
      void fnd_T_of_chr_str(const char* Str,yacco2::CAbs_lr1_sym* Tok);
  ***
  user-implementation
      void Crtn_component::fnd_T_of_chr_str(const char* Str,yacco2::CAbs_lr1_sym* Tok){
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        find_sym_in_stbl(report_card,*Str);
        if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
          CAbs_lr1_sym* sym = new Err_subrule_use_undefined_T;
          sym->set_rc(*parser__->start_token__,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true); 
          return; 
        }
        if(report_card.tbl_entry_->type_ != table_entry::terminal){
          CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th;
          sym->set_rc(*parser__->start_token__,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true); 
          return; 
        }
	report_card.tbl_entry_->used_ = true;
        CAbs_lr1_sym* sym = report_card.tbl_entry_->symbol_;
        T_in_stbl* T = (T_in_stbl*)sym;
        refered_T* rT = new refered_T(*T);
        rT->set_rc(*Tok,__FILE__,__LINE__);
        
        T->add_T_into_xref(*rT);

        RSVP_FSM(T);
        parser__->set_stop_parse(true);  
      }
  ***
}
,fsm-version "1.0",fsm-date "16 dec. 2005",fsm-debug "false"
,fsm-comments "Recognizer of returned T from a thread call expression.")
parallel-parser	
(	
  parallel-thread-function
    TH_rtn_component
  ***
  parallel-la-boundary
eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rrtn_component (
lhs
,parallel-control-monitor{
 /@
   unquoted-string supersets identifier 
    and also includes other T like $-$$>$ and cweb comments ie cweb-marker.
    Code only gets tried when \# parms in accept queue $>$ 1.
 Single entry is one of identifier or cweb.
 @/
  arbitrator-code
	using namespace NS_yacco2_T_enum;
         for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                != NS_yacco2_T_enum::T_Enum::T_T_unquoted_string_){// bypass unq str
	        goto arbitrated_parameter;
             }
         }
  ***
  }
){
  -> ||| identifier NS_identifier::TH_identifier {
    op // used rule and not defined, so create it
	CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
	rule_info__.parser__->set_stop_parse(true); 
    ***
    }
  -> ||| "c-string" NS_c_string::TH_c_string { // T type
    op
      Crtn_component* fsm = (Crtn_component*)rule_info__.parser__->fsm_tbl__;
      fsm->fnd_T_of_chr_str(sf->p2__->c_string()->c_str(),sf->p2__);// stop parsing in call
      sf->p2__->set_auto_delete(true);
	rule_info__.parser__->set_stop_parse(true); 
    ***
    }
  -> ||| "unquoted-string" NS_unq_str::TH_unq_str {// T type
    op // only accept when no identifier
      Crtn_component* fsm = (Crtn_component*)rule_info__.parser__->fsm_tbl__;
      fsm->fnd_T_of_chr_str(sf->p2__->unquoted_string()->c_str(),sf->p2__);// stop parsing in call
	  sf->p2__->set_auto_delete(true);
	rule_info__.parser__->set_stop_parse(true); 
     ***
    }
  -> ||| |+| NULL { // forward errors
/@
  Forward the error.
@/
    op
      RSVP(sf->p2__);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  ||| "T-in-stbl" NULL {
      op 
	using namespace yacco2_stbl;
	T_sym_tbl_report_card report_card;
	find_sym_in_stbl(report_card,*sf->p2__->t_def()->t_name()->c_str());
	if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
		CAbs_lr1_sym* sym = new Err_T_not_in_stbl;
		sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
		RSVP(sym);
		rule_info__.parser__->set_stop_parse(true); 
		return;        
	}
	report_card.tbl_entry_->used_ = true;
	refered_T* rt = new refered_T(*sf->p2__);
	rt->set_rc(*sf->p2__,__FILE__,__LINE__);

        sf->p2__->add_T_into_xref(*rt);
	RSVP(sf->p2__);
	rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
  ->  ||| "rule-in-stbl" NULL {
      op 
	CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
	rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
  ->  ||| "kw-in-stbl" NULL {
      op 
	CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
	rule_info__.parser__->set_stop_parse(true); 
	return;        
      ***
      }     
}
}// end of rules
