/*
 File: o2_sdc.cpp
 Date and Time: Fri Jan 30 18:55:17 2015 
*/
#include "o2_sdc.h"
using namespace NS_yacco2_T_enum;// enumerate
using namespace NS_yacco2_err_symbols;// error symbols
using namespace NS_yacco2_k_symbols;// lrk 
using namespace NS_yacco2_terminals;// terminals
using namespace NS_yacco2_characters;// rc 
using namespace yacco2;// yacco2 library
using namespace NS_o2_sdc;// grammar's ns
// first set terminals
fsm_rules_reuse_table_type::fsm_rules_reuse_table_type(){
 no_rules_entries_ = 3;
 per_rule_s_table_[0] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[1] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[2] =  new Per_rule_s_reuse_table();
}
  Co2_sdc::
  Co2_sdc()
    :yacco2::CAbs_fsm
      ("o2_sdc.lex"
      ,"1.0"
      ,"30 dec 2002"
      ,false
      ,"\\O2's syntax directed code extractor."
      ,"Fri Jan 30 18:55:17 2015 "
      ,S1_Co2_sdc){
    
   ddd_idx_ = 0;
   ddd_[ddd_idx_] = 0;
 
  }
 
Co2_sdc::~Co2_sdc(){

  for(int x = 0;x < 3;++x){
   ///delete fsm_rules_reuse_table.per_rule_s_table_[x];
  }
} 

  bool Co2_sdc::failed(){
      return false;
  }
  void Co2_sdc::op(){
    ddd_idx_ = 0;
    ddd_[ddd_idx_] = 0;
    parser__->set_use_all_shift_on();
    CAbs_lr1_sym* sym = parser__->start_token__;
	switch (sym->enumerated_id__){
	  
	  case T_Enum::T_LR1_eog_: break;
	  default: return;		
    }
    parser__->set_use_all_shift_off();
  
}
int Co2_sdc::rhs_to_rules_mapping_[11] = {
 -1
 ,0 // subrule 1 for rule 1
 ,1 // subrule 2 for rule 2
 ,1 // subrule 3 for rule 2
 ,2 // subrule 4 for rule 3
 ,2 // subrule 5 for rule 3
 ,2 // subrule 6 for rule 3
 ,2 // subrule 7 for rule 3
 ,2 // subrule 8 for rule 3
 ,2 // subrule 9 for rule 3
 ,2 // subrule 10 for rule 3
}; 

    void Co2_sdc::copy_str_into_buffer(std::string* Str){  
      const char* y = Str->c_str(); 
      int x(0);
      for(;y[x]!=0;++x,++ddd_idx_)ddd_[ddd_idx_] = y[x];
      ddd_[ddd_idx_] = 0;
    }

    void Co2_sdc::copy_kstr_into_buffer(const char* Str){
      const char* y = Str; 
      int x(0);
      for(;y[x]!=0;++x,++ddd_idx_)ddd_[ddd_idx_] = y[x];
      ddd_[ddd_idx_] = 0;
    }
  
Ryacco2_syntax_code::Ryacco2_syntax_code(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Ryacco2_syntax_code",0,Co2_sdc::R_Ryacco2_syntax_code_,P,false,false){
}

void Ryacco2_syntax_code::op(){
  sstrace_rulesss
 
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* sym(0);
    if(fsm->ddd_idx_ == 0){
      sym = new Err_no_syntax_code_present;
      sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
      return;
    }
    sym = new T_syntax_code((const char*)&fsm->ddd_);
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    RSVP(sym);
  
}
Rchrs::Rchrs(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rchrs",0,Co2_sdc::R_Rchrs_,P,false,false){
}

Rchr::Rchr(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rchr",0,Co2_sdc::R_Rchr_,P,false,false){
}

void Rchr::op(){
  sstrace_rulesss
 
    if(rule_info__.parser__->stop_parse__ == true) return;
    CAbs_lr1_sym* la_sym = rule_info__.parser__->current_token();
    using namespace NS_yacco2_T_enum;
    using namespace NS_yacco2_terminals;
    // watch for overrun
    if(la_sym->enumerated_id__ == T_Enum::T_LR1_eog_){
      CAbs_lr1_sym* sym = new Err_no_end_of_code;
      sym->set_rc(*la_sym,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
    } 
  
}
void Rchr::sr1(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_comment* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
      T_comment* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      fsm->copy_str_into_buffer(k->comment_data());
    
}

void Rchr::sr2(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_cweb_comment* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
      T_cweb_comment* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      if(PRT_SW == 'n') return;// bypass the cweve comments in the cpp code
      fsm->copy_str_into_buffer(k->comment_data());
      string fmt("@<More code@>+=\n");
      fsm->copy_str_into_buffer(&fmt);
    
}

void Rchr::sr3(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_c_string* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
      T_c_string* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      // add back the bounding double quotes
      fsm->ddd_[fsm->ddd_idx_] = '"';
      ++fsm->ddd_idx_;
      fsm->copy_str_into_buffer(k->c_string());
      fsm->ddd_[fsm->ddd_idx_] = '"';
      ++fsm->ddd_idx_;
      fsm->ddd_[fsm->ddd_idx_] = 0;
    
}

void Rchr::sr4(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_c_literal* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
      T_c_literal* k = sf->p2__;
      k->set_auto_delete(true);
      // add back the bounding single quotes
      fsm->ddd_[fsm->ddd_idx_] = '\'';
      ++fsm->ddd_idx_;
      fsm->copy_str_into_buffer(k->c_literal());
      fsm->ddd_[fsm->ddd_idx_] = '\'';
      ++fsm->ddd_idx_;
      fsm->ddd_[fsm->ddd_idx_] = 0;
    
}

void Rchr::sr5(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_eocode* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
      sf->p2__->set_auto_delete(true);
      rule_info__.parser__->set_use_all_shift_off();
    
}

void Rchr::sr6(){
  struct SF{
   CAbs_lr1_sym* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
    Co2_sdc* fsm = (Co2_sdc*)rule_info__.parser__->fsm_tbl__;
      CAbs_lr1_sym* k = sf->p1__;
		switch (k->enumerated_id__){
			case T_Enum::T_LR1_eog_:{
			    rule_info__.parser__->set_use_all_shift_off();
    				break;
			}
			case T_Enum::T_T_eol_:{
		fsm->copy_kstr_into_buffer("\n");
				break;
			}
			case T_Enum::T_raw_sp_:{
		fsm->copy_kstr_into_buffer(" ");
				break;
			}
			case T_Enum::T_raw_ff_:{
		fsm->copy_kstr_into_buffer("\f");
				break;
			}
			case T_Enum::T_raw_vt_:{
		fsm->copy_kstr_into_buffer("\v");
				break;
			}
			case T_Enum::T_raw_ht_:{
		fsm->copy_kstr_into_buffer("\t");
				break;
			}
			default:{
      fsm->ddd_[fsm->ddd_idx_] = k->id__[0];
      ++fsm->ddd_idx_;
      fsm->ddd_[fsm->ddd_idx_] = 0;
			}
		}
    
}

void Rchr::sr7(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   CAbs_lr1_sym* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
       RSVP(sf->p2__);
       rule_info__.parser__->set_stop_parse(true);
    
}

