/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		enumerate_grammar.lex
Dates:		23 Sept. 2005
Purpose:	determine first set per rule.
How:	Read the grammar's components in prefix order filtering out:
			excluding ``rules-phrase''
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |enumerate_grammar| grammar.\fbreak
Enumerate a grammar's components.
Each component: ``rule-def'', ''subrule-def'', ``refered-rule'', ``refered-T''
and ``eosubrule'' contains a string that receives its enumerate literal.
This reference will be used throughout the outputed document giving
a GPS to the reader.
@/

fsm	
(fsm-id "enumerate_grammar.lex"
,fsm-filename enumerate_grammar
,fsm-namespace NS_enumerate_grammar
,fsm-class Cenumerate_grammar{
  user-prefix-declaration
#include "o2_externs.h"
  ***
  user-declaration
    public:
  int rule_no_;
  int subrule_no_;
  int enum_subrule_no_;
  int elem_no_;
  ***
  op
    rule_no_ = 0;
	subrule_no_ = 0;
	elem_no_ = 0;
        enum_subrule_no_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "26 sept. 2005",fsm-debug "false"
,fsm-comments "Dump aid: Enumerate grammar's components")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rfirst_set_rules  
(){
  -> Rrules eog
}

Rrules  (){
  -> Rrule
  -> Rrules Rrule
}

Rrule  (){
  -> Rrule_def Rsubrules 
}

Rrule_def  (){
  -> "rule-def" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	fsm->subrule_no_ = 0;
	fsm->elem_no_ = 0;
	++fsm->rule_no_;
    char buf[128];
	KCHARP rule_no =	"%i";
	sprintf(buf,rule_no,fsm->rule_no_);
    sf->p1__->grammar_s_enumerate(buf);
  ***
  }
}
Rsubrules  (){
  -> Rsubrule 
  -> Rsubrules Rsubrule
}

Rsubrule  (){
  -> Rsubrule_def Relements
}

Rsubrule_def  (){
  -> "subrule-def" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->subrule_no_;
        ++fsm->enum_subrule_no_;
        sf->p1__->its_grammar_s_pos(fsm->enum_subrule_no_);
	fsm->elem_no_ = 0;    
    char buf[128];
	KCHARP subrule_no =	"%i.%i";
	sprintf(buf,subrule_no,fsm->rule_no_,fsm->subrule_no_);
    sf->p1__->grammar_s_enumerate(buf);
  ***
  }
}

Relements  (){
  -> Relement 
  -> Relements Relement
}
Relement  (){
  -> "refered-rule" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->elem_no_;    
    char buf[128];
	KCHARP elem_no =	"%i.%i.%i";
	sprintf(buf,elem_no,fsm->rule_no_,fsm->subrule_no_,fsm->elem_no_);
    sf->p1__->grammar_s_enumerate(buf);
    sf->p1__->element_pos(fsm->elem_no_);
  ***
  }
  -> "refered-T" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->elem_no_;    
    char buf[128];
	KCHARP elem_no =	"%i.%i.%i";
	sprintf(buf,elem_no,fsm->rule_no_,fsm->subrule_no_,fsm->elem_no_);
    sf->p1__->grammar_s_enumerate(buf);
    sf->p1__->element_pos(fsm->elem_no_);
  ***
  }
  -> "eosubrule" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->elem_no_;    
    char buf[128];
	KCHARP elem_no =	"%i.%i.%i";
	sprintf(buf,elem_no,fsm->rule_no_,fsm->subrule_no_,fsm->elem_no_);
    sf->p1__->grammar_s_enumerate(buf);
    sf->p1__->element_pos(fsm->elem_no_);
  ***
  }
  -> "called thread eosubrule" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->elem_no_;    
    char buf[128];
	KCHARP elem_no =	"%i.%i.%i";
	sprintf(buf,elem_no,fsm->rule_no_,fsm->subrule_no_,fsm->elem_no_);
    sf->p1__->grammar_s_enumerate(buf);
    sf->p1__->element_pos(fsm->elem_no_);
  ***
  }
  -> "null call thread eosubrule" {
  op
    Cenumerate_grammar* fsm = (Cenumerate_grammar*)rule_info__.parser__->fsm_tbl__;
	++fsm->elem_no_;    
    char buf[128];
	KCHARP elem_no =	"%i.%i.%i";
	sprintf(buf,elem_no,fsm->rule_no_,fsm->subrule_no_,fsm->elem_no_);
    sf->p1__->grammar_s_enumerate(buf);
    sf->p1__->element_pos(fsm->elem_no_);
  ***
  }
}

}// end of rules
