/*
 File: cweave_lhs_sdc.cpp
 Date and Time: Fri Jan 30 18:55:07 2015 
*/
#include "cweave_lhs_sdc.h"
using namespace NS_yacco2_T_enum;// enumerate
using namespace NS_yacco2_err_symbols;// error symbols
using namespace NS_yacco2_k_symbols;// lrk 
using namespace NS_yacco2_terminals;// terminals
using namespace NS_yacco2_characters;// rc 
using namespace yacco2;// yacco2 library
using namespace NS_cweave_lhs_sdc;// grammar's ns
// first set terminals
fsm_rules_reuse_table_type::fsm_rules_reuse_table_type(){
 no_rules_entries_ = 3;
 per_rule_s_table_[0] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[1] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[2] =  new Per_rule_s_reuse_table();
}
  Ccweave_lhs_sdc::
  Ccweave_lhs_sdc()
    :yacco2::CAbs_fsm
      ("cweave_lhs_sdc.lex"
      ,"1.0"
      ,"5 Jan. 2006"
      ,false
      ,"Write out cweave rule's lhs directives sentences"
      ,"Fri Jan 30 18:55:07 2015 "
      ,S1_Ccweave_lhs_sdc){
    
  }
 
Ccweave_lhs_sdc::~Ccweave_lhs_sdc(){

  for(int x = 0;x < 3;++x){
   ///delete fsm_rules_reuse_table.per_rule_s_table_[x];
  }
} 

  bool Ccweave_lhs_sdc::failed(){
      return false;
  }
  void Ccweave_lhs_sdc::op(){
}
int Ccweave_lhs_sdc::rhs_to_rules_mapping_[10] = {
 -1
 ,0 // subrule 1 for rule 1
 ,1 // subrule 2 for rule 2
 ,1 // subrule 3 for rule 2
 ,2 // subrule 4 for rule 3
 ,2 // subrule 5 for rule 3
 ,2 // subrule 6 for rule 3
 ,2 // subrule 7 for rule 3
 ,2 // subrule 8 for rule 3
 ,2 // subrule 9 for rule 3
}; 

 	void Ccweave_lhs_sdc::initialize
		(std::ofstream* Cweave_file
		,yacco2::KCHARP Rule_name){
			cweave_file_ = Cweave_file;
			rule_name_ = Rule_name;
		}

    void Ccweave_lhs_sdc::wrt_directive(const char* Directive,T_syntax_code* Sdc){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];

      KCHARP cweave_sentence = "@< %s %s directive@>=\n";
      output_sdcode_title(Directive);
      if(Sdc == 0){
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
        sprintf(big_buf_,cweave_sentence,xa,Directive);
        (*cweave_file_) << "/";
        (*cweave_file_) << "/ no sdcode" << endl;
        return;
      }      
      if(Sdc->cweb_marker() != 0){
        WRT_CWEB_MARKER(cweave_file_,Sdc->cweb_marker());   
	  }
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
      sprintf(big_buf_,cweave_sentence,xa,Directive);
      (*cweave_file_) << big_buf_;
      string xlate;
      int len = Sdc->syntax_code()->length();
      string& sdc=*Sdc->syntax_code();
      // prescan @ due to cweave reqmts
      for(int x=0;x<len;++x){
        char nc = sdc[x];
        if(nc=='@'){
          // check next char for cweave type directives
          char nnc = sdc[x+1];
          if((nnc == '*') || (nnc == '<') || (nnc == '>')){
            xlate += nc;
             continue;
          }else{
            xlate += "@@";
            continue;
          }			
	}else{
            xlate += nc;
            continue;
	}
      }
      (*cweave_file_) << xlate.c_str() << endl;
    }

   void Ccweave_lhs_sdc::output_sdcode_title(const char* Directive){
	  char big_buf_[BIG_BUFFER_32K];		
 char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
     KCHARP cweave_sentence =
        "@*3 %s %s directive.\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }
  
Rweave_sdc::Rweave_sdc(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rweave_sdc",0,Ccweave_lhs_sdc::R_Rweave_sdc_,P,false,false){
}

Rdirectives::Rdirectives(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rdirectives",0,Ccweave_lhs_sdc::R_Rdirectives_,P,false,false){
}

Rdirective::Rdirective(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rdirective",0,Ccweave_lhs_sdc::R_Rdirective_,P,false,false){
}

void Rdirective::sr1(){
  struct SF{
   T_arbitrator_code* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      string include_war_code;
      include_war_code.append("#include \"war_begin_code.h\"\n");
      include_war_code.append(sf->p1__->syntax_code()->syntax_code()->c_str());
      include_war_code.append("#include \"war_end_code.h\"\n");
      sf->p1__->syntax_code()->syntax_code()->clear();
      sf->p1__->syntax_code()->syntax_code()->append(include_war_code.c_str());
      
      KCHARP sdc = "arbitrator-code";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr2(){
  struct SF{
   T_user_declaration* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr3(){
  struct SF{
   T_user_implementation* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-implementation";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr4(){
  struct SF{
   T_constructor* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "constructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr5(){
  struct SF{
   T_destructor* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "destructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr6(){
  struct SF{
   T_op* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "op";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

