/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/main.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#include "common.h"

#include "global.h"
#include "fn.h"
#include "main.h"
#include "msg.h"
#include "str.h"
#include "cnf.h"
#include "mst.h"
#include "cmd.h"

#include "debug.h"




/*-----------------------------------------------------------------------------
disable argument globbing
*/
#ifdef __DJGPP__
char **__crt0_glob_function(char *argument) {  return NULL; }
#endif


/*-----------------------------------------------------------------------------
  argoptfile
  resolves -c, -c$, -m and -m$ options by giving pointer (arg)
  pointing behind -c or -m in argument.
  given: arg: pointer to remaining argstring,
         default-environment-var
         address of (char *) to store result.
*/

int ARG_optfile(PSZ arg, PSZ defenvvar, PPSZ store)
{
PCH p1;
PCH p2;

  p1 = arg;
  if (*p1==DEF_ENVPREFIX)
    {
      p1++;
      p2 = getenv(p1);
      if (!p2) p2 = getenv(defenvvar);
      if (!p2) return 1;            /* still no result, use default file */
      STR_copy_string(store, p2);
      return 1;
    }
  else
    { /* <file> */  
      if (*p1)
        {
          STR_copy_string(store, p1);
          return 1;
        }
    }
  return 0;
}


/*----------------------------------------------------------------------------
  argopt
  process given option. call MSG_usage() if unknown.
  returns: nothing (if it returns)
*/

void ARG_opt(PSZ arg)
{
PCH p1;
PCH p2;

  p1 = arg; p1++;   /* &arg[1] */
  p2 = p1;  p2++;   /* &arg[2] */
                                                              /* Option  -k */
  if ((*p1=='k') && (!*p2))     /* arg[0]=='-' still checked */
     { 
       OPT_mode_keyword  = 1;
       return; 
     }
                                                               /* Option -s */
  if ((*p1=='s') && (!*p2))     /* arg[0]=='-' still checked */
     { 
       OPT_mode_silent  = 1;
       return; 
     }
                                                        /* debug options -D */
  if ((*p1=='D') && (*p2))           /* arg[0]=='-' still checked */
    {
       p1++; p2++;
       if ((*p1=='f') && (!*p2))
          {
            OPT_debug_files  = 1;
            return;
          }
       if ((*p1=='a') && (!*p2))
          {
            OPT_debug_args  = 1;
            return;
          }
     }
                                                 /* -c<file> -c$ -c$<envvar>*/
  if (*p1=='c')
    {
      STR_copy_string(&szConfigFile, DEF_CONFIGFILE);        /* preset */
      if (ARG_optfile(p2, DEF_CONFVAR, &szConfigFile)) return;
    }
                                                 /* -m<file> -m$ -m$<envvar>*/
  if (*p1=='m')
    {
      STR_copy_string(&szMasterFile, DEF_MASTERFILE);   /* preset */
      if (ARG_optfile(p2, DEF_MASTVAR, &szMasterFile)) return;
    }
  MSG_usage();                /* reached this point ? option unknown or wrong ! */
}


/*----------------------------------------------------------------------------
  argsect
  get section name from c-line arg.
  if we already got one, call MSG_usage(); if not properly quoted as well.
  returns: nothing (if it returns) 
*/

void ARG_sect(PSZ arg)
{
  if (szCLSection) MSG_usage();
  STR_copy_string(&szCLSection,arg);
                 /* strip quotes until remaining string is unquoted */
  while (STR_unquote_string(&szCLSection));
}


/*----------------------------------------------------------------------------
  void ARG_PlainArg(char *arg)
  get the plain argument from cmdline (eitherfilename or keyword).
  complain if we got already one.
*/

void ARG_PlainArg(PSZ arg)
{
  if (szCLPlainArg) MSG_usage();
  STR_copy_string(&szCLPlainArg, arg);
}

/*----------------------------------------------------------------------------
  cleanup
  free memory for any string no longer used
*/

void cleanup1(void)
{
    STR_delete_string(&szCLPlainArg);
    STR_delete_string(&szCLSection);
    STR_delete_string(&szCLFileName);
    STR_delete_string(&szConfigFile);
    STR_delete_string(&szMasterFile);
    STR_delete_string(&szCLKeyWord);
  
    STR_delete_string(&szCNFdrive);
    STR_delete_string(&szCNFpath);
    STR_delete_string(&szCNFname);
    STR_delete_string(&szCNFext);
    STR_delete_string(&szCNFdelim);
    STR_delete_string(&szCNFcmd);
}
    
void cleanup2(void)
{
    STR_delete_string(&szStartUpDir);
    STR_delete_string(&szCLFileDir);
    STR_delete_string(&szCmdLine);
}


void dbg_args(int argc, char **argv)
{
int    n;
char **arg;

  MSG_msg("txlaunch: ");
  for (n=1, arg=argv, arg++; (n<argc); n++, arg++)
    {
      MSG_msg(*arg); MSG_msg(" ");
    }
  MSG_msg("\n");
}


/*----------------------------------------------------------------------------
  main
*/


int main(int argc, char **argv)
{
int    retcode;
int    n;
char **arg;

   DBG1("args: ");
                                          /* check first for any option on cmdline */
  for (n=1, arg=argv, arg++; (n<argc); n++, arg++)
    {
      DBG2("%s ",*arg);
      if (**arg=='-')
        ARG_opt(*arg);
    }
  DBG1("\n\n");
                                         /* run along the args a second time */
  for (n=1, arg=argv, arg++; (n<argc); n++, arg++)
    {
      if (STR_is_quoted(*arg))
        ARG_sect(*arg);                   /* get sectionname */
      else 
        if (**arg!='-')
           ARG_PlainArg(*arg);            /* get filename/keyword */
    }

  MSG_copyright();                                       /* ... unless silent-mode */
  if (OPT_debug_args) dbg_args(argc, argv);

  if (!szCLSection)   MSG_usage();                     /* did we get all we need ? */
  if (!OPT_mode_keyword)
    if (!szCLPlainArg)  MSG_usage();

  if (OPT_mode_keyword)
    STR_copy_string(&szCLKeyWord, szCLPlainArg);
  else
    {
      FN_MakeStd(szMasterFile);
      FN_MakeStd(szCLFileName);
      FN_MakeAbs(&szCLFileName, szCLPlainArg, NULL);       /* make given file abs */
      FN_MakeAbsPath(&szCLFileDir, szCLPlainArg, NULL);    /* and store path too */
    }
  STR_delete_string(&szCLPlainArg);

  if (!szConfigFile)                                      /* no configfile ? */
    STR_copy_string(&szConfigFile,DEF_CONFIGFILE);        /* use default     */
  FN_MakeStd(szConfigFile);                               /* change slashes and case */


  DBG2("OPT_mode_keyword = %i\n",OPT_mode_keyword);
  DBG2("OPT_mode_silent  = %i\n",OPT_mode_silent);
  DBG2("OPT_debug_files  = %i\n",OPT_debug_files);
  DBG2("szCLSection:  >%s<\n", szCLSection);
  DBG2("szCLFileName: >%s<\n", szCLFileName);
  DBG2("szCLFileDir:  >%s<\n", szCLFileDir);
  DBG2("szConfigFile: >%s<\n", szConfigFile);
  DBG2("szMasterFile: >%s<\n", szMasterFile);
  DBG2("szCLKeyWord:  >%s<\n\n", szCLKeyWord);
  
  if (!CNF_lookup(szConfigFile, szCLSection))           /* get info from configfile */
    return 255;

  DBG2("szCNFdrive: >%s<\n",   szCNFdrive);
  DBG2("szCNFpath:  >%s<\n",   szCNFpath);
  DBG2("szCNFname:  >%s<\n",   szCNFname);
  DBG2("szCNFext:   >%s<\n",   szCNFext);
  DBG2("szCNFdelim: >%s<\n",   szCNFdelim);
  DBG2("szCNFcmd:   >%s<\n\n", szCNFcmd);

  if (!OPT_mode_keyword)
    {
      FN_GetAbsWD(&szStartUpDir);                                /* get cwd */
                                                       /* try to find masterdoc */
      DBG1("resloving Masterfile\n\n");                /* replaces szCLFileName */
      MST_resolve();                                   /* and szCLFileDir       */
      DBG2("szStartUpDir: >%s<\n",   szStartUpDir);
      DBG2("szCLFileName: >%s<\n\n", szCLFileName);
      DBG2("szCLFileDir:  >%s<\n\n", szCLFileDir);
      DBG2("szCLKeyWord:  >%s<\n\n", szCLKeyWord);
   }
      
  DBG1("constructing cmdline\n\n");
  if (!CMD_make_cmd())                     /* make commandline following the */
    return 255;                            /* 'rules' from configfile        */
  DBG2("szCmdLine:    >%s<\n\n", szCmdLine);

  DBG1("cleanup1\n");
  cleanup1();

  DBG1("executing cmdline\n\n");
  retcode = CMD_invoke_cmd();             /* execute... */
  DBG2("retcode = %i \n\n", retcode);

  DBG1("cleanup2\n");
  cleanup2();

  return retcode;
}
/*------------------------------------------------------------------------- */
